/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.internal.ide.ui.editors.template.quickfix;

import org.eclipse.acceleo.ide.ui.AcceleoUIActivator;
import org.eclipse.acceleo.internal.ide.ui.editors.template.AcceleoEditor;
import org.eclipse.acceleo.internal.ide.ui.editors.template.AcceleoSourceContent;
import org.eclipse.acceleo.parser.cst.CSTNode;
import org.eclipse.acceleo.parser.cst.ForBlock;
import org.eclipse.acceleo.parser.cst.LetBlock;
import org.eclipse.acceleo.parser.cst.Macro;
import org.eclipse.acceleo.parser.cst.Query;
import org.eclipse.acceleo.parser.cst.Template;
import org.eclipse.acceleo.parser.cst.Variable;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.ui.IMarkerResolution2;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public abstract class AbstractCreateModuleElementResolution
implements IMarkerResolution2 {
    public void run(IMarker marker) {
        int newOffset;
        AcceleoEditor editor;
        IDocument document;
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window != null && window.getActivePage() != null && window.getActivePage().getActiveEditor() instanceof AcceleoEditor && (document = (editor = (AcceleoEditor)window.getActivePage().getActiveEditor()).getDocumentProvider().getDocument((Object)editor.getEditorInput())) != null && editor.getContent() != null && (newOffset = this.createModuleElement(document, editor.getContent(), marker)) > -1) {
            editor.selectAndReveal(newOffset, 0);
        }
    }

    protected int createModuleElement(IDocument document, AcceleoSourceContent content, IMarker marker) {
        try {
            String message = marker.getAttribute("message", "");
            int posBegin = marker.getAttribute("charStart", -1);
            int posEnd = marker.getAttribute("charEnd", posBegin);
            if (message != null && posBegin > -1 && posEnd > -1) {
                int newOffset = this.newOffset(document, content, posBegin);
                String paramType = "";
                if (message.contains("for the type") && message.endsWith(")") && message.lastIndexOf(40) > -1) {
                    paramType = message.substring(message.lastIndexOf(40) + 1, message.length() - 1).trim();
                }
                if (paramType.length() == 0) {
                    CSTNode currentNode = content.getCSTNode(posBegin, posBegin);
                    paramType = this.getCurrentVariableTypeName(currentNode, "E");
                }
                String paramName = String.valueOf(Character.toLowerCase(paramType.charAt(0))) + paramType.substring(1);
                StringBuilder newText = new StringBuilder();
                if (newOffset > 0) {
                    newText.append('\n');
                    if (!"\n".equals(document.get(newOffset - 1, 1))) {
                        newText.append("\n");
                    }
                }
                int selectAndReveal = newOffset + newText.length();
                String templateName = document.get(posBegin, posEnd - posBegin);
                int newTextLength = newText.length();
                this.append(newText, templateName, paramType, paramName);
                if (newText.length() > newTextLength) {
                    document.replace(newOffset, 0, newText.toString());
                    marker.delete();
                    return selectAndReveal;
                }
            }
        }
        catch (BadLocationException e) {
            AcceleoUIActivator.getDefault().getLog().log((IStatus)new Status(2, "org.eclipse.acceleo.ide.ui", e.getMessage(), (Throwable)e));
        }
        catch (CoreException e) {
            AcceleoUIActivator.getDefault().getLog().log(e.getStatus());
        }
        return -1;
    }

    private String getCurrentVariableTypeName(CSTNode currentNode, String defaultType) {
        Variable eContext = null;
        if (currentNode instanceof Template) {
            Template iTemplate = (Template)currentNode;
            if (iTemplate.getParameter().size() > 0) {
                eContext = (Variable)iTemplate.getParameter().get(0);
            }
        } else if (currentNode instanceof Query) {
            Query iQuery = (Query)currentNode;
            if (iQuery.getParameter().size() > 0) {
                eContext = (Variable)iQuery.getParameter().get(0);
            }
        } else if (currentNode instanceof Macro) {
            Macro iMacro = (Macro)currentNode;
            if (iMacro.getParameter().size() > 0) {
                eContext = (Variable)iMacro.getParameter().get(0);
            }
        } else if (currentNode instanceof ForBlock) {
            eContext = ((ForBlock)currentNode).getLoopVariable();
        } else if (currentNode instanceof LetBlock) {
            eContext = ((LetBlock)currentNode).getLetVariable();
        }
        String res = eContext != null && eContext.getType() != null ? eContext.getType() : (currentNode != null && currentNode.eContainer() instanceof CSTNode ? this.getCurrentVariableTypeName((CSTNode)currentNode.eContainer(), defaultType) : defaultType);
        return res;
    }

    protected int newOffset(IDocument document, AcceleoSourceContent content, int offset) {
        return document.getLength();
    }

    protected abstract void append(StringBuilder var1, String var2, String var3, String var4);
}

