/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.internal.ide.ui.debug.model;

import org.eclipse.acceleo.internal.ide.ui.debug.core.StackInfo;
import org.eclipse.acceleo.internal.ide.ui.debug.model.AbstractDebugElement;
import org.eclipse.acceleo.internal.ide.ui.debug.model.AcceleoVariable;
import org.eclipse.acceleo.model.mtl.Module;
import org.eclipse.acceleo.model.mtl.ModuleElement;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IRegisterGroup;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.debug.core.model.IThread;
import org.eclipse.debug.core.model.IVariable;
import org.eclipse.ocl.utilities.ASTNode;

public class AcceleoStackFrame
extends AbstractDebugElement
implements IStackFrame {
    private static final String SELF_VARIABLE_NAME = "self";
    private IThread thread;
    private StackInfo stackInfo;

    public AcceleoStackFrame(IThread thread, StackInfo aStackInfo) {
        super(thread.getDebugTarget());
        this.thread = thread;
        this.stackInfo = aStackInfo;
    }

    public IThread getThread() {
        return this.thread;
    }

    public IVariable[] getVariables() throws DebugException {
        IVariable[] ret = new AcceleoVariable[this.stackInfo.getVariables().keySet().size()];
        int i = 1;
        for (String name : this.stackInfo.getVariables().keySet()) {
            Object value = this.stackInfo.getVariables().get(name);
            AcceleoVariable var = new AcceleoVariable(this, name, value, 0);
            if (SELF_VARIABLE_NAME.equals(name)) {
                ret[0] = var;
                continue;
            }
            ret[i++] = var;
        }
        return ret;
    }

    public boolean hasVariables() throws DebugException {
        return this.getVariables().length > 0;
    }

    public int getLineNumber() throws DebugException {
        return this.stackInfo.getLine();
    }

    public int getCharStart() throws DebugException {
        return this.stackInfo.getCharStart();
    }

    public int getCharEnd() throws DebugException {
        return this.stackInfo.getCharEnd();
    }

    public String getName() throws DebugException {
        return this.stackInfo.getFile().getName();
    }

    public IRegisterGroup[] getRegisterGroups() throws DebugException {
        return null;
    }

    public boolean hasRegisterGroups() throws DebugException {
        return false;
    }

    public boolean canStepInto() {
        return this.getThread().canStepInto();
    }

    public boolean canStepOver() {
        return this.getThread().canStepOver();
    }

    public boolean canStepReturn() {
        return this.getThread().canStepReturn();
    }

    public boolean isStepping() {
        return this.getThread().isStepping();
    }

    public void stepInto() throws DebugException {
        this.getThread().stepInto();
    }

    public void stepOver() throws DebugException {
        this.getThread().stepOver();
    }

    public void stepReturn() throws DebugException {
        this.getThread().stepReturn();
    }

    public boolean canResume() {
        return this.getThread().canResume();
    }

    public boolean canSuspend() {
        return this.getThread().canSuspend();
    }

    public boolean isSuspended() {
        return this.getThread().isSuspended();
    }

    public void resume() throws DebugException {
        this.getThread().resume();
    }

    public void suspend() throws DebugException {
        this.getThread().suspend();
    }

    public boolean canTerminate() {
        return this.getThread().canTerminate();
    }

    public boolean isTerminated() {
        return this.getThread().isTerminated();
    }

    public void terminate() throws DebugException {
        this.getThread().terminate();
    }

    public String getSourceName() {
        if (this.stackInfo != null && this.stackInfo.getFile() != null) {
            return this.stackInfo.getFile().getName();
        }
        return "";
    }

    public String getASTNodeDisplayString() {
        ASTNode containingModuleElement = this.stackInfo.getASTNode();
        while (!(containingModuleElement instanceof ModuleElement)) {
            containingModuleElement = containingModuleElement.eContainer();
        }
        Module containingModule = (Module)containingModuleElement.eContainer();
        return String.valueOf(containingModule.getName()) + '.' + containingModuleElement.toString();
    }

    public boolean equals(Object obj) {
        if (obj instanceof AcceleoStackFrame) {
            AcceleoStackFrame sf = (AcceleoStackFrame)((Object)obj);
            try {
                return sf.getSourceName().equals(this.getSourceName()) && sf.getLineNumber() == this.getLineNumber() && sf.getCharStart() == this.getCharStart() && sf.getCharEnd() == this.getCharEnd();
            }
            catch (DebugException debugException) {}
        }
        return false;
    }

    public int hashCode() {
        return this.getSourceName().hashCode();
    }

    public StackInfo getStackInfo() {
        return this.stackInfo;
    }
}

