/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.internal.ide.ui.builders;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.acceleo.common.utils.ModelUtils;
import org.eclipse.acceleo.ide.ui.AcceleoUIActivator;
import org.eclipse.acceleo.ide.ui.resources.AcceleoProject;
import org.eclipse.acceleo.internal.ide.ui.AcceleoUIMessages;
import org.eclipse.acceleo.internal.ide.ui.builders.AcceleoBuilderSettings;
import org.eclipse.acceleo.internal.ide.ui.builders.runner.CreateRunnableAcceleoOperation;
import org.eclipse.acceleo.internal.parser.cst.utils.FileContent;
import org.eclipse.acceleo.internal.parser.cst.utils.Sequence;
import org.eclipse.acceleo.parser.AcceleoFile;
import org.eclipse.acceleo.parser.AcceleoParser;
import org.eclipse.acceleo.parser.AcceleoParserProblem;
import org.eclipse.acceleo.parser.AcceleoParserProblems;
import org.eclipse.acceleo.parser.AcceleoSourceBuffer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.BasicMonitor;
import org.eclipse.emf.common.util.Monitor;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.ocl.ecore.OperationCallExp;

public class AcceleoCompileOperation
implements IWorkspaceRunnable {
    private IProject project;
    private IFile[] files;
    private boolean isClean;
    private StringBuilder messages;

    public AcceleoCompileOperation(IProject project, IFile[] files, boolean isClean) throws CoreException {
        this.project = project;
        this.files = files;
        this.isClean = isClean;
        this.messages = new StringBuilder();
    }

    public void run(IProgressMonitor monitor) throws CoreException {
        this.messages = new StringBuilder();
        monitor.beginTask(AcceleoUIMessages.getString("AcceleoCompileOperation.Task.Compile"), this.files.length);
        AcceleoProject acceleoProject = new AcceleoProject(this.project);
        int i = 0;
        while (i < this.files.length) {
            IFile outputFile;
            monitor.subTask(AcceleoUIMessages.getString("AcceleoCompileOperation.Task.Clean", this.files[0].getFullPath().toString()));
            this.files[i].deleteMarkers("org.eclipse.core.resources.problemmarker", true, 2);
            IPath outputPath = acceleoProject.getOutputFilePath(this.files[i]);
            if (outputPath != null && (outputFile = this.project.getFile(outputPath.removeFirstSegments(1))) != null && outputFile.exists()) {
                try {
                    outputFile.delete(true, monitor);
                }
                catch (CoreException coreException) {}
            }
            ++i;
        }
        if (!this.isClean) {
            this.doCompileResources(monitor);
        }
        monitor.done();
    }

    public String getMessages() {
        return this.messages.toString();
    }

    private void doCompileResources(IProgressMonitor monitor) throws CoreException {
        AcceleoBuilderSettings settings;
        IFile workspaceFile;
        AcceleoProject acceleoProject = new AcceleoProject(this.project);
        List<URI> dependenciesURIs = acceleoProject.getAccessibleOutputFiles();
        AcceleoParser parser = new AcceleoParser();
        ArrayList<AcceleoFile> iFiles = new ArrayList<AcceleoFile>();
        ArrayList<URI> oURIs = new ArrayList<URI>();
        int i = 0;
        while (i < this.files.length) {
            IPath outputPath;
            if (acceleoProject.getOutputFilePath(this.files[i]) != null && (outputPath = acceleoProject.getOutputFilePath(this.files[i])) != null) {
                String javaPackageName = acceleoProject.getPackageName(this.files[i]);
                AcceleoFile acceleoFile = new AcceleoFile(this.files[i].getLocation().toFile(), AcceleoFile.javaPackageToFullModuleName((String)javaPackageName, (String)new Path(this.files[i].getName()).removeFileExtension().lastSegment()));
                iFiles.add(acceleoFile);
                URI platformURI = URI.createPlatformResourceURI((String)outputPath.toString(), (boolean)false);
                oURIs.add(platformURI);
            }
            ++i;
        }
        parser.parse(iFiles, oURIs, dependenciesURIs, (Monitor)new BasicMonitor.EclipseSubProgress(monitor, 1));
        for (AcceleoFile iFile : iFiles) {
            AcceleoParserProblems problems = parser.getProblems(iFile);
            if (problems == null || (workspaceFile = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation((IPath)new Path(iFile.getMtlFile().getAbsolutePath()))) == null || !workspaceFile.isAccessible()) continue;
            List list = problems.getList();
            for (AcceleoParserProblem problem : list) {
                this.reportError(workspaceFile, problem.getLine(), problem.getPosBegin(), problem.getPosEnd(), problem.getMessage());
            }
        }
        if (!monitor.isCanceled()) {
            ArrayList<IFile> filesWithMainTag = new ArrayList<IFile>();
            for (AcceleoFile iFile : iFiles) {
                workspaceFile = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation((IPath)new Path(iFile.getMtlFile().getAbsolutePath()));
                if (workspaceFile == null || !workspaceFile.isAccessible() || !this.hasMainTag(workspaceFile)) continue;
                filesWithMainTag.add(workspaceFile);
            }
            CreateRunnableAcceleoOperation createRunnableAcceleoOperation = new CreateRunnableAcceleoOperation(acceleoProject, filesWithMainTag);
            createRunnableAcceleoOperation.run(monitor);
        }
        if ("strict" == (settings = new AcceleoBuilderSettings(this.project)).getCompliance()) {
            Iterator itFiles = iFiles.iterator();
            Iterator itURIs = oURIs.iterator();
            while (!monitor.isCanceled() && itURIs.hasNext() && itFiles.hasNext()) {
                AcceleoFile iFile = (AcceleoFile)itFiles.next();
                URI oURI = (URI)itURIs.next();
                this.checkFullOMGCompliance(iFile.getMtlFile(), oURI);
            }
        }
    }

    private void checkFullOMGCompliance(File iFile, URI oURI) {
        try {
            AcceleoSourceBuffer buffer = new AcceleoSourceBuffer(iFile);
            ResourceSetImpl oResourceSet = new ResourceSetImpl();
            EObject oRoot = ModelUtils.load((URI)oURI, (ResourceSet)oResourceSet);
            TreeIterator oAllContents = oRoot.eAllContents();
            while (oAllContents.hasNext()) {
                IFile workspaceFile;
                OperationCallExp oOperationCallExp;
                EObject oNext = (EObject)oAllContents.next();
                if (!(oNext instanceof OperationCallExp) || (oOperationCallExp = (OperationCallExp)oNext).getReferredOperation() == null || ((EOperation)oOperationCallExp.getReferredOperation()).getEAnnotation("MTL non-standard") == null || (workspaceFile = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation((IPath)new Path(iFile.getAbsolutePath()))) == null || !workspaceFile.isAccessible() || oOperationCallExp.getStartPosition() <= -1) continue;
                int line = buffer.getLineOfOffset(oOperationCallExp.getStartPosition());
                this.reportError(workspaceFile, line, oOperationCallExp.getStartPosition(), oOperationCallExp.getEndPosition(), AcceleoUIMessages.getString("AcceleoCompileOperation.NotFullyCompliant", ((EOperation)oOperationCallExp.getReferredOperation()).getName()));
            }
        }
        catch (IOException e) {
            Status status = new Status(2, "org.eclipse.acceleo.ide.ui", e.getMessage(), (Throwable)e);
            AcceleoUIActivator.getDefault().getLog().log((IStatus)status);
        }
        catch (CoreException e) {
            AcceleoUIActivator.getDefault().getLog().log(e.getStatus());
        }
    }

    private boolean hasMainTag(IFile file) {
        Sequence pattern = new Sequence("@main");
        try {
            InputStream inputStream = file.getContents();
            int available = inputStream.available();
            byte[] bytes = new byte[available];
            inputStream.read(bytes);
            StringBuffer contents = FileContent.getFileContent((File)file.getLocation().toFile());
            if (pattern.search(contents).b() > -1) {
                return true;
            }
        }
        catch (CoreException e) {
            AcceleoUIActivator.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.acceleo.ide.ui", e.getMessage(), (Throwable)e));
        }
        catch (IOException e) {
            AcceleoUIActivator.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.acceleo.ide.ui", e.getMessage(), (Throwable)e));
        }
        return false;
    }

    private void reportError(IFile file, int line, int posBegin, int posEnd, String message) throws CoreException {
        IMarker m = file.createMarker("org.eclipse.acceleo.ide.ui.problem");
        m.setAttribute("lineNumber", line);
        m.setAttribute("charStart", posBegin);
        m.setAttribute("charEnd", posEnd);
        m.setAttribute("message", (Object)message);
        m.setAttribute("priority", 2);
        m.setAttribute("severity", 2);
        this.messages.append(file.getFullPath().toString());
        this.messages.append(" line ");
        this.messages.append(line);
        this.messages.append('\n');
        this.messages.append(message);
        this.messages.append('\n');
        this.messages.append('\n');
    }
}

