/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jet.internal.xpath.ast;

import java.util.Iterator;
import org.eclipse.jet.internal.xpath.NodeSetImpl;
import org.eclipse.jet.internal.xpath.ast.Axis;
import org.eclipse.jet.internal.xpath.ast.NodeSetExpr;
import org.eclipse.jet.internal.xpath.ast.NodeTest;
import org.eclipse.jet.internal.xpath.ast.Predicate;
import org.eclipse.jet.xpath.Context;
import org.eclipse.jet.xpath.NodeSet;

public class Step
extends NodeSetExpr {
    private static final Predicate[] EMPTY_PREDICATE_EXPRS = new Predicate[0];
    private final Axis axis;
    private final NodeTest nodeTest;
    private final NodeSetExpr leftLocationPath;
    private final Predicate[] predicates;

    public Step(NodeSetExpr leftLocationPath, Axis axis, NodeTest nodeTest) {
        this(leftLocationPath, axis, nodeTest, EMPTY_PREDICATE_EXPRS);
    }

    public Step(NodeSetExpr leftLocationPath, Axis axis, NodeTest nodeTest, Predicate[] predicates) {
        this.leftLocationPath = leftLocationPath;
        this.axis = axis;
        this.nodeTest = nodeTest;
        this.predicates = predicates;
    }

    public NodeSet evalAsNodeSet(Context context) {
        NodeSet leftNodeSet = this.leftLocationPath.evalAsNodeSet(context);
        NodeSet result = NodeSetImpl.EMPTY_SET;
        int contextSize = leftNodeSet.size();
        int contextPosition = 1;
        Iterator i = leftNodeSet.iterator();
        while (i.hasNext()) {
            Object contextNode = i.next();
            Context subContext = context.newSubContext(contextNode, contextPosition, contextSize);
            NodeSet subResult = this.axis.evaluate(this.nodeTest, subContext);
            int j = 0;
            while (j < this.predicates.length) {
                Predicate predicate = this.predicates[j];
                subResult = predicate.filter(context, subResult);
                ++j;
            }
            if (result.size() == 0 && subResult.size() > 0) {
                result = subResult;
            } else if (subResult.size() > 0) {
                result.addAll(subResult);
            }
            ++contextPosition;
        }
        return result;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.leftLocationPath).append("/").append(this.axis.toString()).append(this.nodeTest.toString());
        int i = 0;
        while (i < this.predicates.length) {
            buffer.append(this.predicates[i].toString());
            ++i;
        }
        return buffer.toString();
    }
}

