/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jet.internal.compiler;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.jet.core.parser.ast.JETASTVisitor;
import org.eclipse.jet.core.parser.ast.JETCompilationUnit;
import org.eclipse.jet.core.parser.ast.XMLBodyElement;
import org.eclipse.jet.core.parser.ast.XMLElement;
import org.eclipse.jet.core.parser.ast.XMLEmptyElement;
import org.eclipse.jet.taglib.TagLibraryReference;

public class TagUsageVisitor
extends JETASTVisitor {
    private boolean hasTags = false;
    private boolean hasAttributelessTags = false;
    private Set nsPrefixesUsed = new HashSet();
    private Map tagOrdinals = new IdentityHashMap();

    private void handleTagElement(XMLElement xmlTagElement) {
        this.nsPrefixesUsed.add(xmlTagElement.getNSPrefix());
        this.hasTags = true;
        if (!this.tagOrdinals.containsKey(xmlTagElement)) {
            this.tagOrdinals.put(xmlTagElement, new Integer(this.tagOrdinals.size()));
        }
        if (xmlTagElement.getAttributes().size() == 0) {
            this.hasAttributelessTags = true;
        }
    }

    public boolean hasAttributelessTags() {
        return this.hasAttributelessTags;
    }

    public boolean visit(XMLBodyElement xmlBodyElement) {
        this.handleTagElement((XMLElement)xmlBodyElement);
        return true;
    }

    public boolean visit(XMLEmptyElement xmlEmptyElement) {
        this.handleTagElement((XMLElement)xmlEmptyElement);
        return true;
    }

    public boolean hasTags() {
        return this.hasTags;
    }

    public TagLibraryReference[] getUsedTagLibraryReferences(JETCompilationUnit cu) {
        TagLibraryReference[] tlrefs = cu.getTagLibraryReferences();
        ArrayList<TagLibraryReference> usedRefs = new ArrayList<TagLibraryReference>();
        int i = 0;
        while (i < tlrefs.length) {
            if (this.nsPrefixesUsed.contains(tlrefs[i].getPrefix())) {
                usedRefs.add(tlrefs[i]);
            }
            ++i;
        }
        return usedRefs.toArray(new TagLibraryReference[usedRefs.size()]);
    }

    public int ordinal(XMLElement xmlTagElement) {
        Integer result = (Integer)this.tagOrdinals.get(xmlTagElement);
        if (result == null) {
            throw new IllegalStateException("Tag ordinals have not yet been computed");
        }
        return result;
    }

    public String ordinalExpr(XMLElement xmlTagElement) {
        return "[" + this.ordinal(xmlTagElement) + "]";
    }
}

