/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jet.internal.taglib.java;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.jet.internal.taglib.java.ImpliedImportTag;
import org.eclipse.jet.internal.taglib.java.ImportTag;
import org.eclipse.jet.internal.taglib.java.ImportsLocationTag;
import org.eclipse.jet.internal.taglib.java.JavaClassTag;
import org.eclipse.jet.internal.taglib.java.JavaFormatTag;
import org.eclipse.jet.internal.taglib.java.JavaResourceTag;
import org.eclipse.jet.internal.taglib.java.MergeTag;
import org.eclipse.jet.internal.taglib.java.PackageTag;
import org.eclipse.jet.taglib.CustomTag;
import org.eclipse.jet.taglib.JET2TagException;
import org.eclipse.jet.taglib.TagInstanceFactory;

public class TagFactory
implements TagInstanceFactory {
    private final Map tagOrdinalByName = new HashMap(8);

    public TagFactory() {
        this.tagOrdinalByName.put("class", new Integer(1));
        this.tagOrdinalByName.put("format", new Integer(2));
        this.tagOrdinalByName.put("impliedImport", new Integer(3));
        this.tagOrdinalByName.put("import", new Integer(4));
        this.tagOrdinalByName.put("importsLocation", new Integer(5));
        this.tagOrdinalByName.put("merge", new Integer(6));
        this.tagOrdinalByName.put("package", new Integer(7));
        this.tagOrdinalByName.put("resource", new Integer(8));
    }

    public CustomTag createCustomTag(String name) {
        Integer ordinal = (Integer)this.tagOrdinalByName.get(name);
        switch (ordinal == null ? 0 : ordinal) {
            case 1: {
                return new JavaClassTag();
            }
            case 2: {
                return new JavaFormatTag();
            }
            case 3: {
                return new ImpliedImportTag();
            }
            case 4: {
                return new ImportTag();
            }
            case 5: {
                return new ImportsLocationTag();
            }
            case 6: {
                return new MergeTag();
            }
            case 7: {
                return new PackageTag();
            }
            case 8: {
                return new JavaResourceTag();
            }
        }
        throw new JET2TagException("Unknown Tag: " + name);
    }
}

