/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.internal.ide.ui.views.result;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.eclipse.acceleo.engine.event.AcceleoTextGenerationEvent;
import org.eclipse.acceleo.engine.event.IAcceleoTextGenerationListener;
import org.eclipse.acceleo.internal.ide.ui.views.result.TraceabilityContainer;
import org.eclipse.acceleo.internal.ide.ui.views.result.TraceabilityModel;
import org.eclipse.acceleo.internal.ide.ui.views.result.TraceabilityRegion;
import org.eclipse.acceleo.internal.ide.ui.views.result.TraceabilityTargetFile;
import org.eclipse.acceleo.internal.ide.ui.views.result.TraceabilityTemplate;
import org.eclipse.acceleo.model.mtl.Block;
import org.eclipse.acceleo.model.mtl.Module;
import org.eclipse.acceleo.model.mtl.ModuleElement;
import org.eclipse.acceleo.model.mtl.TemplateExpression;
import org.eclipse.acceleo.traceability.GeneratedFile;
import org.eclipse.acceleo.traceability.GeneratedText;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.ocl.utilities.ASTNode;

public class AcceleoResultContent
implements IAcceleoTextGenerationListener {
    private Map<String, TraceabilityTargetFile> targetFiles = new HashMap<String, TraceabilityTargetFile>();

    public TraceabilityTargetFile[] getTargetFiles() {
        Collection<TraceabilityTargetFile> values = this.targetFiles.values();
        return values.toArray(new TraceabilityTargetFile[values.size()]);
    }

    public TraceabilityTargetFile getTargetFile(String path) {
        return this.targetFiles.get(path);
    }

    public void fileGenerated(AcceleoTextGenerationEvent event) {
        EObject traceabilityElement = event.getTraceabilityInformation();
        if (traceabilityElement instanceof GeneratedFile) {
            GeneratedFile generatedFile = (GeneratedFile)traceabilityElement;
            String targetPath = new Path(generatedFile.getPath()).toString();
            TraceabilityTargetFile targetFile = new TraceabilityTargetFile(targetPath);
            this.targetFiles.put(targetPath, targetFile);
            for (GeneratedText generatedText : generatedFile.getGeneratedRegions()) {
                EObject eObject = event.getSource();
                if (generatedText.getSourceElement() != null && generatedText.getSourceElement().getModelElement() != null) {
                    eObject = generatedText.getSourceElement().getModelElement();
                }
                Block astNode = event.getBlock();
                if (generatedText.getModuleElement() != null && generatedText.getModuleElement().getModuleElement() instanceof ASTNode) {
                    astNode = (ASTNode)generatedText.getModuleElement().getModuleElement();
                }
                this.onGeneratedText(targetFile, generatedText, eObject, (ASTNode)astNode);
            }
        }
    }

    private void onGeneratedText(TraceabilityTargetFile targetFile, GeneratedText generatedText, EObject eObject, ASTNode astNode) {
        if (generatedText.getEndOffset() > generatedText.getStartOffset() && eObject != null && astNode != null) {
            TraceabilityModel templateNode;
            TraceabilityModel model = this.getOrCreateModelInChildren(targetFile, eObject);
            TraceabilityModel templateRoot = this.getOrCreateModelInChildren(model, EcoreUtil.getRootContainer((EObject)astNode));
            ASTNode currentModuleElement = astNode;
            while (currentModuleElement != null && !(currentModuleElement instanceof ModuleElement)) {
                currentModuleElement = currentModuleElement.eContainer();
            }
            if (currentModuleElement instanceof ModuleElement) {
                TraceabilityModel templateModuleElement = this.getOrCreateModelInChildren(templateRoot, (EObject)currentModuleElement);
                templateNode = currentModuleElement == astNode ? templateModuleElement : this.getOrCreateModelInChildren(templateModuleElement, (EObject)astNode);
            } else {
                templateNode = this.getOrCreateModelInChildren(templateRoot, (EObject)astNode);
            }
            TraceabilityRegion region = new TraceabilityRegion(generatedText.getStartOffset(), generatedText.getEndOffset() - generatedText.getStartOffset(), astNode);
            templateNode.getRegions().add(region);
            region.setParent(templateNode);
        }
    }

    private TraceabilityModel getOrCreateModelInChildren(TraceabilityContainer parent, EObject eObject) {
        for (TraceabilityModel child : parent.getChildren()) {
            TraceabilityModel result = null;
            if (child.getEObject() == eObject) {
                result = child;
            } else if (this.ancestorOf(child.getEObject(), eObject)) {
                result = this.getOrCreateModelInChildren(child, eObject);
            }
            if (result == null) continue;
            return result;
        }
        TraceabilityModel newModel = eObject instanceof Module ? new TraceabilityTemplate((Module)eObject) : (eObject instanceof TemplateExpression ? new TraceabilityTemplate((TemplateExpression)eObject) : new TraceabilityModel(eObject));
        HashSet<TraceabilityModel> toMove = new HashSet<TraceabilityModel>();
        for (TraceabilityModel sibling : parent.getChildren()) {
            if (!this.ancestorOf(newModel.getEObject(), sibling.getEObject())) continue;
            toMove.add(sibling);
        }
        for (TraceabilityModel next : toMove) {
            this.addInChildren(newModel, next);
            parent.getChildren().remove(next);
        }
        this.addInChildren(parent, newModel);
        return newModel;
    }

    private void addInChildren(TraceabilityContainer parent, TraceabilityModel child) {
        int index = -1;
        if (!(child instanceof TraceabilityTemplate)) {
            int i = 0;
            for (TraceabilityModel otherChild : parent.getChildren()) {
                if (otherChild instanceof TraceabilityTemplate) {
                    index = i;
                    break;
                }
                ++i;
            }
        }
        if (index == -1) {
            parent.getChildren().add(child);
        } else {
            parent.getChildren().add(index, child);
        }
        child.setParent(parent);
    }

    private boolean ancestorOf(EObject ancestor, EObject object) {
        EObject current = object.eContainer();
        while (current != null) {
            if (current == ancestor) {
                return true;
            }
            current = current.eContainer();
        }
        return false;
    }

    public void generationEnd(AcceleoTextGenerationEvent event) {
    }

    public boolean listensToGenerationEnd() {
        return false;
    }

    public void filePathComputed(AcceleoTextGenerationEvent event) {
    }

    public void textGenerated(AcceleoTextGenerationEvent event) {
    }
}

