/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.internal.ide.ui.editors.template;

import java.util.ArrayList;
import java.util.Map;
import org.eclipse.acceleo.internal.ide.ui.editors.template.AcceleoCompletionProcessor;
import org.eclipse.acceleo.internal.ide.ui.editors.template.AcceleoEditor;
import org.eclipse.acceleo.internal.ide.ui.editors.template.AcceleoHover;
import org.eclipse.acceleo.internal.ide.ui.editors.template.AcceleoTemplateReconcilingStrategy;
import org.eclipse.acceleo.internal.ide.ui.editors.template.scanner.AbstractAcceleoScanner;
import org.eclipse.acceleo.internal.ide.ui.editors.template.scanner.AcceleoBehavioralFeatureScanner;
import org.eclipse.acceleo.internal.ide.ui.editors.template.scanner.AcceleoBlockScanner;
import org.eclipse.acceleo.internal.ide.ui.editors.template.scanner.AcceleoCommentScanner;
import org.eclipse.acceleo.internal.ide.ui.editors.template.scanner.AcceleoDefaultScanner;
import org.eclipse.acceleo.internal.ide.ui.editors.template.scanner.AcceleoForScanner;
import org.eclipse.acceleo.internal.ide.ui.editors.template.scanner.AcceleoIfScanner;
import org.eclipse.acceleo.internal.ide.ui.editors.template.scanner.AcceleoLetScanner;
import org.eclipse.acceleo.internal.ide.ui.editors.template.scanner.AcceleoProtectedAreaScanner;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.DefaultTextDoubleClickStrategy;
import org.eclipse.jface.text.ITextDoubleClickStrategy;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ContentAssistant;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContentAssistant;
import org.eclipse.jface.text.presentation.IPresentationDamager;
import org.eclipse.jface.text.presentation.IPresentationReconciler;
import org.eclipse.jface.text.presentation.IPresentationRepairer;
import org.eclipse.jface.text.presentation.PresentationReconciler;
import org.eclipse.jface.text.reconciler.IReconciler;
import org.eclipse.jface.text.reconciler.IReconcilingStrategy;
import org.eclipse.jface.text.reconciler.MonoReconciler;
import org.eclipse.jface.text.rules.DefaultDamagerRepairer;
import org.eclipse.jface.text.rules.ITokenScanner;
import org.eclipse.jface.text.source.IAnnotationHover;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.swt.graphics.Point;
import org.eclipse.ui.editors.text.TextSourceViewerConfiguration;

public class AcceleoConfiguration
extends TextSourceViewerConfiguration {
    private static final int COMPLETION_AUTO_ACTIVATION_DELAY = 1000;
    protected AcceleoEditor editor;
    private AbstractAcceleoScanner[] scanners;

    public AcceleoConfiguration(AcceleoEditor editor, IPreferenceStore preferenceStore) {
        this.editor = editor;
        this.fPreferenceStore = preferenceStore;
    }

    protected AbstractAcceleoScanner[] getScanners() {
        if (this.scanners == null) {
            ArrayList<AbstractAcceleoScanner> list = new ArrayList<AbstractAcceleoScanner>();
            list.add(new AcceleoBehavioralFeatureScanner(this.editor.getColorManager()));
            list.add(new AcceleoForScanner(this.editor.getColorManager()));
            list.add(new AcceleoIfScanner(this.editor.getColorManager()));
            list.add(new AcceleoLetScanner(this.editor.getColorManager()));
            list.add(new AcceleoProtectedAreaScanner(this.editor.getColorManager()));
            list.add(new AcceleoCommentScanner(this.editor.getColorManager()));
            list.add(new AcceleoBlockScanner(this.editor.getColorManager()));
            list.add(new AcceleoDefaultScanner(this.editor.getColorManager()));
            this.scanners = list.toArray(new AbstractAcceleoScanner[list.size()]);
        }
        return this.scanners;
    }

    public String[] getConfiguredContentTypes(ISourceViewer sourceViewer) {
        AbstractAcceleoScanner[] acceleoScanners = this.getScanners();
        String[] result = new String[acceleoScanners.length];
        int i = 0;
        while (i < acceleoScanners.length) {
            AbstractAcceleoScanner scanner = acceleoScanners[i];
            result[i] = scanner.getConfiguredContentType();
            ++i;
        }
        return result;
    }

    public ITextDoubleClickStrategy getDoubleClickStrategy(ISourceViewer sourceViewer, String contentType) {
        return new DefaultTextDoubleClickStrategy(){

            public void doubleClicked(ITextViewer part) {
                super.doubleClicked(part);
                Point point = part.getSelectedRange();
                if (point != null) {
                    int posBegin = point.x;
                    int posEnd = point.y;
                    AcceleoConfiguration.this.editor.updateSelection(posBegin, posEnd);
                }
            }
        };
    }

    public IPresentationReconciler getPresentationReconciler(ISourceViewer sourceViewer) {
        PresentationReconciler reconciler = new PresentationReconciler();
        AbstractAcceleoScanner[] acceleoScanners = this.getScanners();
        int i = 0;
        while (i < acceleoScanners.length) {
            AbstractAcceleoScanner scanner = acceleoScanners[i];
            DefaultDamagerRepairer dr = new DefaultDamagerRepairer((ITokenScanner)scanner);
            reconciler.setDamager((IPresentationDamager)dr, scanner.getConfiguredContentType());
            reconciler.setRepairer((IPresentationRepairer)dr, scanner.getConfiguredContentType());
            ++i;
        }
        return reconciler;
    }

    public IContentAssistant getContentAssistant(ISourceViewer sourceViewer) {
        ContentAssistant assistant = new ContentAssistant();
        assistant.setDocumentPartitioning(this.getConfiguredDocumentPartitioning(sourceViewer));
        AcceleoCompletionProcessor processor = new AcceleoCompletionProcessor(this.editor.getContent());
        AbstractAcceleoScanner[] acceleoScanners = this.getScanners();
        int i = 0;
        while (i < acceleoScanners.length) {
            AbstractAcceleoScanner scanner = acceleoScanners[i];
            if (!(scanner instanceof AcceleoCommentScanner)) {
                assistant.setContentAssistProcessor((IContentAssistProcessor)processor, scanner.getConfiguredContentType());
            }
            ++i;
        }
        assistant.enableAutoActivation(true);
        assistant.setAutoActivationDelay(1000);
        assistant.setProposalPopupOrientation(10);
        assistant.setInformationControlCreator(this.getInformationControlCreator(sourceViewer));
        return assistant;
    }

    public IAnnotationHover getAnnotationHover(ISourceViewer sourceViewer) {
        return new AcceleoHover(this.editor);
    }

    public IReconciler getReconciler(ISourceViewer sourceViewer) {
        return new MonoReconciler((IReconcilingStrategy)new AcceleoTemplateReconcilingStrategy(this.editor), false);
    }

    protected Map getHyperlinkDetectorTargets(ISourceViewer sourceViewer) {
        Map targets = super.getHyperlinkDetectorTargets(sourceViewer);
        targets.put("org.eclipse.acceleo.ide.ui.AcceleoTemplateSource", this.editor);
        return targets;
    }
}

