/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.internal.ide.ui.debug.model;

import java.io.File;
import org.eclipse.acceleo.engine.internal.debug.ASTFragment;
import org.eclipse.acceleo.internal.ide.ui.AcceleoUIMessages;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IBreakpointManager;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.core.model.LineBreakpoint;
import org.eclipse.emf.ecore.EObject;

public class AcceleoLineBreakpoint
extends LineBreakpoint {
    public static final String MARKER_ID = "org.eclipse.acceleo.ide.ui.debug.markerType.lineBreakpoint";
    public static final String AST_FRAGMENT = "astFragment";

    public AcceleoLineBreakpoint() {
    }

    public AcceleoLineBreakpoint(final EObject astNode, final IResource resource, final int lineNumber, final int offset, final int length) throws CoreException {
        IWorkspaceRunnable runnable = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                IMarker marker = resource.createMarker(AcceleoLineBreakpoint.MARKER_ID);
                AcceleoLineBreakpoint.this.setMarker(marker);
                marker.setAttribute("org.eclipse.debug.core.enabled", (Object)Boolean.TRUE);
                marker.setAttribute("lineNumber", lineNumber);
                marker.setAttribute("org.eclipse.debug.core.id", (Object)AcceleoLineBreakpoint.this.getModelIdentifier());
                marker.setAttribute("charStart", offset);
                marker.setAttribute("charEnd", offset + length);
                marker.setAttribute(AcceleoLineBreakpoint.AST_FRAGMENT, (Object)new ASTFragment(astNode).toString());
                marker.setAttribute("message", (Object)AcceleoUIMessages.getString("AcceleoLineBreakpoint.HoverText", astNode.eClass().getName(), resource.getName(), Integer.toString(lineNumber)));
            }
        };
        this.run(this.getMarkerRule(resource), runnable);
    }

    public String getModelIdentifier() {
        return "org.eclipse.acceleo.ide.ui.debug.model.AcceleoModelPresentation";
    }

    public File getFile() {
        File ret = null;
        if (this.getMarker().getResource() instanceof IFile) {
            ret = ((IFile)this.getMarker().getResource()).getLocation().toFile();
        }
        return ret;
    }

    public void setEnabled(boolean enabled) throws CoreException {
        super.setEnabled(enabled);
        IBreakpointManager breakpointManager = DebugPlugin.getDefault().getBreakpointManager();
        if (breakpointManager != null) {
            breakpointManager.fireBreakpointChanged((IBreakpoint)this);
        }
    }

    public ASTFragment getASTFragment() {
        return new ASTFragment(this.getMarker().getAttribute(AST_FRAGMENT, ""));
    }
}

