/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.internal.ide.ui.builders.runner;

import org.eclipse.acceleo.internal.ide.ui.builders.runner.CreateRunnableAcceleoContent;

public class CreateRunnableJavaWriter {
    protected static String nl;
    public final String NL = nl == null ? System.getProperties().getProperty("line.separator") : nl;
    protected final String TEXT_1 = "/*******************************************************************************" + this.NL + " * Copyright (c) 2008, 2009 Obeo." + this.NL + " * All rights reserved. This program and the accompanying materials" + this.NL + " * are made available under the terms of the Eclipse Public License v1.0" + this.NL + " * which accompanies this distribution, and is available at" + this.NL + " * http://www.eclipse.org/legal/epl-v10.html" + this.NL + " * " + this.NL + " * Contributors:" + this.NL + " *     Obeo - initial API and implementation" + this.NL + " *******************************************************************************/" + this.NL + "package ";
    protected final String TEXT_2 = ";" + this.NL + this.NL + "import java.io.File;" + this.NL + "import java.io.IOException;" + this.NL + "import java.net.URL;" + this.NL + "import java.util.HashMap;" + this.NL + "import java.util.Map;" + this.NL + "import java.util.List;" + this.NL + "import java.util.ArrayList;" + this.NL + this.NL + "import org.eclipse.emf.common.util.URI;" + this.NL + "import org.eclipse.emf.ecore.EObject;" + this.NL + "import org.eclipse.emf.ecore.EPackage;" + this.NL + "import org.eclipse.emf.ecore.resource.Resource;" + this.NL + "import org.eclipse.emf.ecore.resource.ResourceSet;" + this.NL + "import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;" + this.NL + "import org.eclipse.emf.ecore.util.EcoreUtil;" + this.NL + "import org.eclipse.emf.ecore.xmi.XMLResource;" + this.NL + "import org.eclipse.emf.ecore.xmi.impl.EcoreResourceFactoryImpl;" + this.NL + "import org.eclipse.emf.ecore.xmi.impl.XMIResourceFactoryImpl;" + this.NL + "import org.eclipse.acceleo.model.mtl.Module;" + this.NL + "import org.eclipse.acceleo.model.mtl.MtlPackage;" + this.NL + "import org.eclipse.core.runtime.FileLocator;" + this.NL + "import org.eclipse.emf.common.EMFPlugin;" + this.NL + "import org.eclipse.acceleo.engine.service.AcceleoService;" + this.NL + "import org.eclipse.ocl.ecore.EcoreEnvironment;" + this.NL + "import org.eclipse.ocl.ecore.EcoreEnvironmentFactory;" + this.NL + this.NL + "/**" + this.NL + " * Entry point of the '";
    protected final String TEXT_3 = "' generation module." + this.NL + " * " + this.NL + " * @author <a href=\"mailto:jonathan.musset@obeo.fr\">Jonathan Musset</a>" + this.NL + " */" + this.NL + "public class ";
    protected final String TEXT_4 = " {" + this.NL + this.NL + "\t/**" + this.NL + "\t * The name of the module." + this.NL + "\t * @generated" + this.NL + "\t */" + this.NL + "\tpublic static final String MODULE_FILE_NAME = \"";
    protected final String TEXT_5 = "\";" + this.NL + "\t" + this.NL + "\t/**" + this.NL + "\t * The name of the templates that are to be generated." + this.NL + "\t * @generated" + this.NL + "\t */" + this.NL + "\tpublic static final String[] TEMPLATE_NAMES = { ";
    protected final String TEXT_6 = "\"";
    protected final String TEXT_7 = "\", ";
    protected final String TEXT_8 = "};" + this.NL + this.NL + "\t/**" + this.NL + "\t * The root element of the module." + this.NL + "\t */" + this.NL + "\tprivate Module module;" + this.NL + this.NL + "\t/**" + this.NL + "\t * The model." + this.NL + "\t */" + this.NL + "\tprivate EObject model;" + this.NL + this.NL + "\t/**" + this.NL + "\t * The output folder." + this.NL + "\t */" + this.NL + "\tprivate File targetFolder;" + this.NL + this.NL + "\t/**" + this.NL + "\t * The other arguments." + this.NL + "\t */" + this.NL + "\tList<? extends Object> arguments;" + this.NL + this.NL + "\t/**" + this.NL + "\t * Constructor." + this.NL + "\t * " + this.NL + "\t * @param modelURI" + this.NL + "\t *            is the URI of the model." + this.NL + "\t * @param targetFolder" + this.NL + "\t *            is the output folder" + this.NL + "\t * @param arguments" + this.NL + "\t *            are the other arguments" + this.NL + "\t * @throws IOException" + this.NL + "\t *             Thrown when the output cannot be saved." + this.NL + "\t * @generated" + this.NL + "\t */" + this.NL + "\tpublic ";
    protected final String TEXT_9 = "(URI modelURI, File targetFolder, List<? extends Object> arguments) throws IOException {" + this.NL + "\t\tResourceSet resourceSet = new ResourceSetImpl();" + this.NL + "\t\tregisterResourceFactories(resourceSet);" + this.NL + "\t\tregisterPackages(resourceSet);" + this.NL + "\t\tfinal URL templateURL;" + this.NL + "\t\tif (EMFPlugin.IS_ECLIPSE_RUNNING) {" + this.NL + "\t\t\ttemplateURL = FileLocator.toFileURL(";
    protected final String TEXT_10 = ".class.getResource(MODULE_FILE_NAME + \".emtl\"));" + this.NL + "\t\t} else {" + this.NL + "\t\t\ttemplateURL = ";
    protected final String TEXT_11 = ".class.getResource(MODULE_FILE_NAME + \".emtl\");" + this.NL + "\t\t}" + this.NL + "\t\tif (templateURL == null) {" + this.NL + "\t\t\tthrow new IOException(\"'\" + MODULE_FILE_NAME + \".emtl' not found\");" + this.NL + "\t\t} else {" + this.NL + "\t\t\tURI templateURI = createTemplateURI(templateURL.getPath());" + this.NL + "\t\t\tmodule = (Module)load(templateURI, resourceSet);" + this.NL + "\t\t\tmodel = load(modelURI, resourceSet);" + this.NL + "\t\t\tthis.targetFolder = targetFolder;" + this.NL + "\t\t\tthis.arguments = arguments;" + this.NL + "\t\t}" + this.NL + "\t}" + this.NL + this.NL + "\t/**" + this.NL + "\t * Constructor." + this.NL + "\t * " + this.NL + "\t * @param model" + this.NL + "\t *            is the root element of the model." + this.NL + "\t * @param targetFolder" + this.NL + "\t *            is the output folder" + this.NL + "\t * @param arguments" + this.NL + "\t *            are the other arguments" + this.NL + "\t * @throws IOException" + this.NL + "\t *             Thrown when the output cannot be saved." + this.NL + "\t * @generated" + this.NL + "\t */" + this.NL + "\tpublic ";
    protected final String TEXT_12 = "(EObject model, File targetFolder, List<? extends Object> arguments) throws IOException {" + this.NL + "\t\tResourceSet resourceSet = model.eResource().getResourceSet();" + this.NL + "\t\tregisterResourceFactories(resourceSet);" + this.NL + "\t\tregisterPackages(resourceSet);" + this.NL + "\t\tfinal URL templateURL;" + this.NL + "\t\tif (EMFPlugin.IS_ECLIPSE_RUNNING) {" + this.NL + "\t\t\ttemplateURL = FileLocator.toFileURL(";
    protected final String TEXT_13 = ".class.getResource(MODULE_FILE_NAME + \".emtl\"));" + this.NL + "\t\t} else {" + this.NL + "\t\t\ttemplateURL = ";
    protected final String TEXT_14 = ".class.getResource(MODULE_FILE_NAME + \".emtl\");" + this.NL + "\t\t}" + this.NL + "\t\tif (templateURL == null) {" + this.NL + "\t\t\tthrow new IOException(\"'\" + MODULE_FILE_NAME + \".emtl' not found\");" + this.NL + "\t\t} else {" + this.NL + "\t\t\tURI templateURI = createTemplateURI(templateURL.getPath());" + this.NL + "\t\t\tmodule = (Module)load(templateURI, resourceSet);" + this.NL + "\t\t\tthis.model = model;" + this.NL + "\t\t\tthis.targetFolder = targetFolder;" + this.NL + "\t\t\tthis.arguments = arguments;" + this.NL + "\t\t}" + this.NL + "\t}" + this.NL + this.NL + "\t/**" + this.NL + "\t * Creates the template URI." + this.NL + "\t * " + this.NL + "\t * @param entry" + this.NL + "\t *            is the local path of the EMTL file" + this.NL + "\t * @generated" + this.NL + "\t */" + this.NL + "\tprotected URI createTemplateURI(String entry) {" + this.NL + "\t\treturn URI.createFileURI(URI.decode(entry));" + this.NL + "\t}" + this.NL + this.NL + "\t/**" + this.NL + "\t * Gets the model." + this.NL + "\t * @return the model root element" + this.NL + "\t */" + this.NL + "\tpublic EObject getModel() {" + this.NL + "\t\treturn model;" + this.NL + "\t}" + this.NL + this.NL + "\t/**" + this.NL + "\t * Updates the registry used for looking up a package based namespace, in the resource set." + this.NL + "\t * " + this.NL + "\t * @param resourceSet" + this.NL + "\t *            is the resource set" + this.NL + "\t * @generated" + this.NL + "\t */" + this.NL + "\tprivate void registerPackages(ResourceSet resourceSet) {";
    protected final String TEXT_15 = String.valueOf(this.NL) + "\t\tresourceSet.getPackageRegistry().put(";
    protected final String TEXT_16 = ".eINSTANCE.getNsURI(), ";
    protected final String TEXT_17 = ".eINSTANCE);";
    protected final String TEXT_18 = String.valueOf(this.NL) + "\t\tresourceSet.getPackageRegistry().put(org.eclipse.ocl.ecore.EcorePackage.eINSTANCE.getNsURI(), org.eclipse.ocl.ecore.EcorePackage.eINSTANCE);" + this.NL + "\t\tresourceSet.getPackageRegistry().put(org.eclipse.ocl.expressions.ExpressionsPackage.eINSTANCE.getNsURI(), org.eclipse.ocl.expressions.ExpressionsPackage.eINSTANCE);" + this.NL + "\t\tresourceSet.getPackageRegistry().put(MtlPackage.eINSTANCE.getNsURI(), MtlPackage.eINSTANCE);" + this.NL + "\t\tresourceSet.getPackageRegistry().put(\"http://www.eclipse.org/ocl/1.1.0/oclstdlib.ecore\", getOCLStdLibPackage());" + this.NL + "\t}" + this.NL + "\t" + this.NL + "\t/**" + this.NL + "\t * Returns the package containing the OCL standard library." + this.NL + "\t * " + this.NL + "\t * @return The package containing the OCL standard library." + this.NL + "\t * @generated" + this.NL + "\t */" + this.NL + "\tprivate EPackage getOCLStdLibPackage() {" + this.NL + "\t\tEcoreEnvironmentFactory factory = new EcoreEnvironmentFactory();" + this.NL + "\t\tEcoreEnvironment environment = (EcoreEnvironment)factory.createEnvironment();" + this.NL + "\t\treturn (EPackage)EcoreUtil.getRootContainer(environment.getOCLStandardLibrary().getBag());" + this.NL + "\t}" + this.NL + "\t" + this.NL + "\t/**" + this.NL + "\t * Updates the registry used for looking up resources factory in the given resource set." + this.NL + "\t *" + this.NL + "\t * @param resourceSet" + this.NL + "\t *            The resource set that is to be updated." + this.NL + "\t * @generated" + this.NL + "\t */" + this.NL + "\tprivate void registerResourceFactories(ResourceSet resourceSet) {" + this.NL + "\t\tresourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put(\"ecore\", new EcoreResourceFactoryImpl());" + this.NL + "\t\tresourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put(\"emtl\", new org.eclipse.acceleo.model.mtl.resource.EMtlResourceFactoryImpl());" + this.NL + "\t\tresourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put(Resource.Factory.Registry.DEFAULT_EXTENSION, new XMIResourceFactoryImpl());" + this.NL + "\t}" + this.NL + this.NL + "\t/**" + this.NL + "\t * The main method." + this.NL + "\t * " + this.NL + "\t * @param args" + this.NL + "\t *            are the arguments" + this.NL + "\t * @generated" + this.NL + "\t */" + this.NL + "\tpublic static void main(String[] args) {" + this.NL + "\t\ttry {" + this.NL + "\t\t\tif (args.length < 2) {" + this.NL + "\t\t\t\tSystem.out.println(\"Arguments not valid : {model, folder}.\");" + this.NL + "\t\t\t} else {" + this.NL + "\t\t\t\tURI modelURI = URI.createFileURI(args[0]);" + this.NL + "\t\t\t\tFile folder = new File(args[1]);" + this.NL + "\t\t\t\tList<String> arguments = new ArrayList<String>();" + this.NL + "\t\t\t\tfor (int i = 2; i < args.length; i++) {" + this.NL + "\t\t\t\t\targuments.add(args[i]);" + this.NL + "\t\t\t\t}" + this.NL + "\t\t\t\t";
    protected final String TEXT_19 = " generator = new ";
    protected final String TEXT_20 = "(modelURI, folder, arguments);" + this.NL + "\t\t\t\tgenerator.doGenerate();" + this.NL + "\t\t\t}" + this.NL + "\t\t} catch (IOException e) {" + this.NL + "\t\t\te.printStackTrace();" + this.NL + "\t\t}" + this.NL + "\t}" + this.NL + this.NL + "\t/**" + this.NL + "\t * Launches the generation." + this.NL + "\t * " + this.NL + "\t * @throws IOException" + this.NL + "\t *             Thrown when the output cannot be saved." + this.NL + "\t * @generated" + this.NL + "\t */" + this.NL + "\tpublic void doGenerate() throws IOException {" + this.NL + "\t\tif (!targetFolder.exists()) {" + this.NL + "\t\t\ttargetFolder.mkdirs();" + this.NL + "\t\t}" + this.NL + "\t\tfor (int i = 0; i < TEMPLATE_NAMES.length; i++) {" + this.NL + "\t\t\tAcceleoService.doGenerate(module, TEMPLATE_NAMES[i], model, arguments, targetFolder, false);" + this.NL + "\t\t}" + this.NL + "\t}" + this.NL + this.NL + "\t/**" + this.NL + "\t * Loads a model from an {@link org.eclipse.emf.common.util.URI URI} in a given {@link ResourceSet}." + this.NL + "\t * <p>" + this.NL + "\t * This will return the first root of the loaded model, other roots can be accessed via the resource's" + this.NL + "\t * content." + this.NL + "\t * </p>" + this.NL + "\t * " + this.NL + "\t * @param modelURI" + this.NL + "\t *            {@link org.eclipse.emf.common.util.URI URI} where the model is stored." + this.NL + "\t * @param resourceSet" + this.NL + "\t *            The {@link ResourceSet} to load the model in." + this.NL + "\t * @return The model loaded from the URI." + this.NL + "\t * @throws IOException" + this.NL + "\t *             If the given file does not exist." + this.NL + "\t * @generated" + this.NL + "\t */" + this.NL + "\tprivate EObject load(URI modelURI, ResourceSet resourceSet) throws IOException {" + this.NL + "\t\tEObject result = null;" + this.NL + "\t\tfinal Resource modelResource = createResource(modelURI, resourceSet);" + this.NL + "\t\tfinal Map<String, String> options = new HashMap<String, String>();" + this.NL + "\t\toptions.put(XMLResource.OPTION_ENCODING, System.getProperty(\"file.encoding\"));" + this.NL + "\t\tmodelResource.load(options);" + this.NL + "\t\tif (modelResource.getContents().size() > 0) {" + this.NL + "\t\t\tresult = modelResource.getContents().get(0);" + this.NL + "\t\t}" + this.NL + "\t\treturn result;" + this.NL + "\t}" + this.NL + this.NL + "\t/**" + this.NL + "\t * This will create a {@link Resource} given the model extension it is intended for and a ResourceSet." + this.NL + "\t * " + this.NL + "\t * @param modelURI" + this.NL + "\t *            {@link org.eclipse.emf.common.util.URI URI} where the model is stored." + this.NL + "\t * @param resourceSet" + this.NL + "\t *            The {@link ResourceSet} to load the model in." + this.NL + "\t * @return The {@link Resource} given the model extension it is intended for." + this.NL + "\t * @generated" + this.NL + "\t */" + this.NL + "\tprivate Resource createResource(URI modelURI, ResourceSet resourceSet) {" + this.NL + "\t\tString fileExtension = modelURI.fileExtension();" + this.NL + "\t\tif (fileExtension == null || fileExtension.length() == 0) {" + this.NL + "\t\t\tfileExtension = Resource.Factory.Registry.DEFAULT_EXTENSION;" + this.NL + "\t\t}" + this.NL + "\t\tfinal Resource.Factory.Registry registry = Resource.Factory.Registry.INSTANCE;" + this.NL + "\t\tfinal Object resourceFactory = registry.getExtensionToFactoryMap().get(fileExtension);" + this.NL + "\t\tif (resourceFactory != null) {" + this.NL + "\t\t\tresourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put(fileExtension," + this.NL + "\t\t\t\t\tresourceFactory);" + this.NL + "\t\t} else {" + this.NL + "\t\t\tresourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put(fileExtension," + this.NL + "\t\t\t\t\tnew XMIResourceFactoryImpl());" + this.NL + "\t\t}" + this.NL + "\t\treturn resourceSet.createResource(modelURI);" + this.NL + "\t}" + this.NL + this.NL + "}";
    protected final String TEXT_21 = this.NL;

    public static synchronized CreateRunnableJavaWriter create(String lineSeparator) {
        nl = lineSeparator;
        CreateRunnableJavaWriter result = new CreateRunnableJavaWriter();
        nl = null;
        return result;
    }

    public String generate(Object argument) {
        StringBuffer stringBuffer = new StringBuffer();
        CreateRunnableAcceleoContent content = (CreateRunnableAcceleoContent)argument;
        stringBuffer.append(this.TEXT_1);
        stringBuffer.append(content.getBasePackage());
        stringBuffer.append(this.TEXT_2);
        stringBuffer.append(content.getClassShortName());
        stringBuffer.append(this.TEXT_3);
        stringBuffer.append(content.getClassShortName());
        stringBuffer.append(this.TEXT_4);
        stringBuffer.append(content.getModuleFileShortName());
        stringBuffer.append(this.TEXT_5);
        int i = 0;
        while (i < content.getTemplateNames().size()) {
            stringBuffer.append("\"");
            stringBuffer.append(content.getTemplateNames().get(i));
            stringBuffer.append("\", ");
            ++i;
        }
        stringBuffer.append(this.TEXT_8);
        stringBuffer.append(content.getClassShortName());
        stringBuffer.append(this.TEXT_9);
        stringBuffer.append(content.getClassShortName());
        stringBuffer.append(this.TEXT_10);
        stringBuffer.append(content.getClassShortName());
        stringBuffer.append(this.TEXT_11);
        stringBuffer.append(content.getClassShortName());
        stringBuffer.append(this.TEXT_12);
        stringBuffer.append(content.getClassShortName());
        stringBuffer.append(this.TEXT_13);
        stringBuffer.append(content.getClassShortName());
        stringBuffer.append(this.TEXT_14);
        i = 0;
        while (i < content.getPackages().size()) {
            stringBuffer.append(this.TEXT_15);
            stringBuffer.append(content.getPackages().get(i));
            stringBuffer.append(".eINSTANCE.getNsURI(), ");
            stringBuffer.append(content.getPackages().get(i));
            stringBuffer.append(".eINSTANCE);");
            ++i;
        }
        stringBuffer.append(this.TEXT_18);
        stringBuffer.append(content.getClassShortName());
        stringBuffer.append(" generator = new ");
        stringBuffer.append(content.getClassShortName());
        stringBuffer.append(this.TEXT_20);
        stringBuffer.append(this.TEXT_21);
        return stringBuffer.toString();
    }
}

