/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.engine.internal.environment;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.acceleo.common.utils.ModelUtils;
import org.eclipse.acceleo.engine.AcceleoEngineMessages;
import org.eclipse.acceleo.engine.AcceleoEnginePlugin;
import org.eclipse.acceleo.engine.AcceleoEvaluationException;
import org.eclipse.acceleo.engine.internal.environment.AcceleoLibraryOperationVisitor;
import org.eclipse.acceleo.engine.internal.environment.AcceleoPropertiesLookup;
import org.eclipse.acceleo.engine.internal.environment.DynamicModulesURIConverter;
import org.eclipse.acceleo.engine.internal.utils.AcceleoOverrideAdapter;
import org.eclipse.acceleo.engine.service.AcceleoDynamicTemplatesRegistry;
import org.eclipse.acceleo.model.mtl.Module;
import org.eclipse.acceleo.model.mtl.ModuleElement;
import org.eclipse.acceleo.model.mtl.Template;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.ocl.EvaluationEnvironment;
import org.eclipse.ocl.ecore.EcoreEvaluationEnvironment;
import org.eclipse.ocl.ecore.Variable;
import org.eclipse.ocl.options.EvaluationOptions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AcceleoEvaluationEnvironment
extends EcoreEvaluationEnvironment {
    private static final Object NULL_ARGUMENT = new Object();
    private static final String TEMPORARY_CONTEXT_VAR_PREFIX = "context$";
    private static final String TEMPORARY_INVOCATION_ARG_PREFIX = "temporaryInvocationVariable$";
    private final Set<Module> currentModules = new HashSet<Module>();
    private final Map<Template, Set<Template>> dynamicOverrides = new HashMap<Template, Set<Template>>();
    private final Map<Template, Set<Template>> overridingTemplates = new HashMap<Template, Set<Template>>();
    private AcceleoPropertiesLookup propertiesLookup;
    private final Map<String, Set<Template>> templates = new HashMap<String, Set<Template>>();
    private final LinkedList<Map<String, LinkedList<Object>>> scopedVariableMap = new LinkedList();
    private final Map<String, LinkedList<Object>> globalVariableMap = new HashMap<String, LinkedList<Object>>();

    public AcceleoEvaluationEnvironment(EvaluationEnvironment<EClassifier, EOperation, EStructuralFeature, EClass, EObject> parent, Module module, AcceleoPropertiesLookup properties) {
        super(parent);
        this.scopedVariableMap.add(new HashMap());
        this.mapAllTemplates(module);
        this.mapDynamicOverrides();
        this.setOption(EvaluationOptions.LAX_NULL_HANDLING, Boolean.FALSE);
        this.propertiesLookup = properties;
    }

    public AcceleoEvaluationEnvironment(Module module, AcceleoPropertiesLookup properties) {
        this.scopedVariableMap.add(new HashMap());
        this.mapAllTemplates(module);
        this.mapDynamicOverrides();
        this.setOption(EvaluationOptions.LAX_NULL_HANDLING, Boolean.FALSE);
        this.propertiesLookup = properties;
    }

    public void add(String name, Object value) {
        Map<String, LinkedList<Object>> variableMap = name.startsWith(TEMPORARY_CONTEXT_VAR_PREFIX) || name.startsWith(TEMPORARY_INVOCATION_ARG_PREFIX) ? this.globalVariableMap : this.scopedVariableMap.getLast();
        LinkedList<Object> values = variableMap.get(name);
        if (values == null) {
            values = new LinkedList();
            variableMap.put(name, values);
        }
        values.add(value);
    }

    public Object callOperation(EOperation operation, int opcode, Object source, Object[] args) {
        Object result = null;
        result = operation.getEAnnotation("MTL") != null ? AcceleoLibraryOperationVisitor.callStandardOperation(this, operation, source, args) : (operation.getEAnnotation("MTL non-standard") != null ? AcceleoLibraryOperationVisitor.callNonStandardOperation(this, operation, source, args) : super.callOperation(operation, opcode, source, args));
        return result;
    }

    public void clear() {
        super.clear();
        this.scopedVariableMap.clear();
        this.globalVariableMap.clear();
    }

    public void createVariableScope() {
        this.scopedVariableMap.add(new HashMap());
    }

    public List<Template> getAllCandidates(Module origin, Template call, List<Object> arguments) {
        ArrayList<Object> argumentTypes = new ArrayList<Object>(arguments.size());
        for (Object arg : arguments) {
            if (arg instanceof EObject) {
                argumentTypes.add(((EObject)arg).eClass());
                continue;
            }
            if (arg != null) {
                argumentTypes.add(arg.getClass());
                continue;
            }
            argumentTypes.add(NULL_ARGUMENT);
        }
        List<Template> orderedNamesakes = this.reorderCandidatesPriority(origin, this.getAllCandidateNamesakes(origin, call, argumentTypes));
        List<Template> dynamicOverriding = this.reorderDynamicOverrides(this.getAllDynamicCandidateOverriding(orderedNamesakes, argumentTypes));
        List<Template> overriding = this.getAllCandidateOverriding(origin, orderedNamesakes, argumentTypes);
        ArrayList<Template> applicableCandidates = new ArrayList<Template>();
        applicableCandidates.addAll(dynamicOverriding);
        applicableCandidates.addAll(overriding);
        applicableCandidates.addAll(orderedNamesakes);
        return applicableCandidates;
    }

    public Template getMostSpecificTemplate(List<Template> candidates, List<Object> arguments) {
        Iterator<Template> candidateIterator = candidates.iterator();
        if (candidates.size() == 1) {
            return candidateIterator.next();
        }
        ArrayList<Object> argumentTypes = new ArrayList<Object>(arguments.size());
        for (Object arg : arguments) {
            if (arg instanceof EObject) {
                argumentTypes.add(((EObject)arg).eClass());
                continue;
            }
            argumentTypes.add(arg.getClass());
        }
        Template mostSpecific = candidateIterator.next();
        while (candidateIterator.hasNext()) {
            mostSpecific = this.mostSpecificTemplate(mostSpecific, candidateIterator.next(), arguments);
        }
        return mostSpecific;
    }

    public AcceleoPropertiesLookup getPropertiesLookup() {
        return this.propertiesLookup;
    }

    public Map<String, Object> getCurrentVariables() {
        Map<String, LinkedList<Object>> variableMap = this.scopedVariableMap.getLast();
        HashMap<String, Object> availableVariables = new HashMap<String, Object>();
        for (Map.Entry<String, LinkedList<Object>> var : variableMap.entrySet()) {
            if (var.getValue().isEmpty()) continue;
            availableVariables.put(var.getKey(), var.getValue().getLast());
        }
        return availableVariables;
    }

    public Object getInvalidResult() {
        return super.getInvalidResult();
    }

    public Object getValueOf(String name) {
        Object value = null;
        Map<String, LinkedList<Object>> variableMap = this.scopedVariableMap.getLast();
        if (variableMap.containsKey(name)) {
            value = variableMap.get(name).getLast();
        } else if (this.globalVariableMap.containsKey(name)) {
            value = this.globalVariableMap.get(name).getLast();
        }
        return value;
    }

    public boolean overrides(EOperation operation, int opcode) {
        boolean result = false;
        if (operation.getEAnnotation("MTL") != null) {
            result = true;
        } else if (operation.getEAnnotation("MTL non-standard") != null) {
            if (opcode == 1) {
                Adapter adapter = EcoreUtil.getAdapter((List)operation.eAdapters(), AcceleoOverrideAdapter.class);
                result = adapter != null;
                operation.eAdapters().remove((Object)adapter);
            } else {
                result = true;
            }
        } else {
            result = super.overrides((Object)operation, opcode);
        }
        return result;
    }

    public Object remove(String name) {
        Map<String, LinkedList<Object>> variableMap;
        if (this.scopedVariableMap.getLast().containsKey(name)) {
            variableMap = this.scopedVariableMap.getLast();
        } else if (this.globalVariableMap.containsKey(name)) {
            variableMap = this.globalVariableMap;
        } else {
            return null;
        }
        Object removedValue = variableMap.get(name).removeLast();
        if (variableMap.get(name).size() == 0) {
            variableMap.remove(name);
        }
        return removedValue;
    }

    public Map<String, LinkedList<Object>> removeVariableScope() {
        return this.scopedVariableMap.removeLast();
    }

    public void replace(String name, Object value) {
        Map<String, LinkedList<Object>> variableMap = name.startsWith(TEMPORARY_CONTEXT_VAR_PREFIX) || name.startsWith(TEMPORARY_INVOCATION_ARG_PREFIX) ? this.globalVariableMap : this.scopedVariableMap.getLast();
        if (variableMap.containsKey(name)) {
            variableMap.get(name).removeLast();
        }
        this.add(name, value);
    }

    public String toString() {
        Map<String, LinkedList<Object>> variableMap = this.scopedVariableMap.getLast();
        return variableMap.toString();
    }

    private Set<Template> applicableTemplates(Set<Template> candidates, List<Object> argumentTypes) {
        LinkedHashSet<Template> applicableCandidates = new LinkedHashSet<Template>(candidates);
        for (Template candidate : candidates) {
            if (candidate.getParameter().size() == argumentTypes.size()) continue;
            applicableCandidates.remove(candidate);
        }
        int i = 0;
        while (i < argumentTypes.size()) {
            for (Template candidate : new LinkedHashSet<Template>(applicableCandidates)) {
                Object parameterType = ((Variable)candidate.getParameter().get(i)).getType();
                if (this.isApplicableArgument(parameterType, argumentTypes.get(i))) continue;
                applicableCandidates.remove(candidate);
            }
            ++i;
        }
        return applicableCandidates;
    }

    private Set<Template> getAllCandidateNamesakes(Module origin, Template call, List<Object> argumentTypes) {
        LinkedHashSet<Template> namesakes = new LinkedHashSet<Template>();
        Set<Template> candidates = this.templates.get(call.getName());
        if (candidates == null) {
            throw new AcceleoEvaluationException(AcceleoEngineMessages.getString("AcceleoEvaluationEnvironment.ModuleResolutionError"));
        }
        HashSet<Module> scope = new HashSet<Module>();
        scope.add(origin);
        scope.addAll(this.getScopeOf(origin));
        for (Template candidate : candidates) {
            if (!scope.contains(candidate.eContainer())) continue;
            namesakes.add(candidate);
        }
        if (namesakes.size() == 1) {
            return namesakes;
        }
        namesakes.retainAll(this.applicableTemplates(candidates, argumentTypes));
        return namesakes;
    }

    private Set<Module> getScopeOf(Module module) {
        HashSet<Module> scope = new HashSet<Module>();
        if (module.getExtends().size() > 0) {
            Module extended = (Module)module.getExtends().get(0);
            scope.add(extended);
            scope.addAll(this.getScopeOf(extended));
        }
        scope.addAll((Collection<Module>)module.getImports());
        return scope;
    }

    private List<Template> getAllCandidateOverriding(Module origin, List<Template> overridenTemplates, List<Object> argumentTypes) {
        ArrayList<Template> candidateOverriding = new ArrayList<Template>();
        for (Template overriden : overridenTemplates) {
            Set<Template> candidates = this.overridingTemplates.get(overriden);
            if (candidates == null) continue;
            Set<Template> applicableCandidates = this.applicableTemplates(candidates, argumentTypes);
            candidateOverriding.addAll(applicableCandidates);
            candidateOverriding.addAll(this.getAllCandidateOverriding(origin, new ArrayList<Template>(applicableCandidates), argumentTypes));
        }
        Collections.reverse(candidateOverriding);
        return candidateOverriding;
    }

    private Set<Template> getAllDynamicCandidateOverriding(List<Template> overridenTemplates, List<Object> argumentTypes) {
        LinkedHashSet<Template> dynamicOverriding = new LinkedHashSet<Template>();
        for (Template overriden : overridenTemplates) {
            Set<Template> candidates = this.dynamicOverrides.get(overriden);
            if (candidates == null) continue;
            Set<Template> applicableCandidates = this.applicableTemplates(candidates, argumentTypes);
            dynamicOverriding.addAll(applicableCandidates);
        }
        return dynamicOverriding;
    }

    Set<Module> getCurrentModules() {
        return new HashSet<Module>(this.currentModules);
    }

    private boolean isApplicableArgument(Object expectedType, Object argumentType) {
        boolean isApplicable = false;
        isApplicable = argumentType == NULL_ARGUMENT ? true : (expectedType instanceof EClass && argumentType instanceof EClass ? expectedType == argumentType || this.isSubTypeOf((EClass)expectedType, (EClass)argumentType) : (expectedType instanceof Class && argumentType instanceof Class ? ((Class)expectedType).isAssignableFrom((Class)argumentType) : (expectedType instanceof EDataType && argumentType instanceof Class ? ((EDataType)expectedType).getInstanceClass() == argumentType : expectedType.getClass().isInstance(argumentType))));
        return isApplicable;
    }

    private boolean isSubTypeOf(EClass superType, EClass eClass) {
        for (EClass candidate : eClass.getEAllSuperTypes()) {
            if (candidate != superType) continue;
            return true;
        }
        return false;
    }

    private Set<Module> loadDynamicModules() {
        Set<File> dynamicModuleFiles = AcceleoDynamicTemplatesRegistry.INSTANCE.getRegisteredModules();
        LinkedHashSet<Module> dynamicModules = new LinkedHashSet<Module>();
        if (dynamicModuleFiles.size() > 0) {
            ResourceSet resourceSet = null;
            for (Module module : this.currentModules) {
                if (module.eResource() == null || module.eResource().getResourceSet() == null) continue;
                resourceSet = module.eResource().getResourceSet();
                break;
            }
            if (resourceSet == null) {
                AcceleoEnginePlugin.log(AcceleoEngineMessages.getString("AcceleoEvaluationEnvironment.DynamicModulesLoadingFailure"), true);
                return dynamicModules;
            }
            if (!(resourceSet.getURIConverter() instanceof DynamicModulesURIConverter)) {
                resourceSet.setURIConverter((URIConverter)new DynamicModulesURIConverter(this));
            }
            for (File moduleFile : dynamicModuleFiles) {
                if (!moduleFile.exists() || !moduleFile.canRead()) continue;
                try {
                    Resource res = ModelUtils.load((File)moduleFile, (ResourceSet)resourceSet).eResource();
                    for (EObject root : res.getContents()) {
                        if (!(root instanceof Module)) continue;
                        dynamicModules.add((Module)root);
                    }
                }
                catch (IOException e) {
                    AcceleoEnginePlugin.log(e, false);
                }
            }
        }
        return dynamicModules;
    }

    private void mapAllTemplates(Module module) {
        if (this.currentModules.contains(module)) {
            return;
        }
        this.currentModules.add(module);
        for (ModuleElement elem : module.getOwnedModuleElement()) {
            if (!(elem instanceof Template)) continue;
            Set<Template> namesakes = this.templates.get(elem.getName());
            if (namesakes == null) {
                namesakes = new LinkedHashSet<Template>();
                this.templates.put(elem.getName(), namesakes);
            }
            namesakes.add((Template)elem);
            this.mapOverridingTemplate((Template)elem);
        }
        for (Module extended : module.getExtends()) {
            this.mapAllTemplates(extended);
        }
        for (Module imported : module.getImports()) {
            this.mapAllTemplates(imported);
        }
    }

    private void mapDynamicModule(Module module, Set<Module> dynamicModules) {
        boolean map = false;
        LinkedHashSet<Module> unMappedRequiredModules = new LinkedHashSet<Module>();
        for (Module extended : module.getExtends()) {
            if (dynamicModules.contains(extended)) {
                this.mapDynamicModule(extended, dynamicModules);
            }
            if (this.currentModules.contains(extended)) {
                map = true;
                continue;
            }
            unMappedRequiredModules.add(extended);
        }
        if (!map) {
            return;
        }
        for (Module imported : module.getImports()) {
            if (this.currentModules.contains(imported)) continue;
            unMappedRequiredModules.add(imported);
        }
        for (Module required : unMappedRequiredModules) {
            this.mapAllTemplates(required);
        }
        for (ModuleElement elem : module.getOwnedModuleElement()) {
            if (!(elem instanceof Template)) continue;
            Template ownedTemplate = (Template)elem;
            for (Template overriden : ownedTemplate.getOverrides()) {
                Set<Template> overriding = this.dynamicOverrides.get(overriden);
                if (overriding == null && this.templates.containsKey(overriden.getName())) {
                    overriding = new LinkedHashSet<Template>();
                    Template match = overriden;
                    Set<Template> candidates = this.templates.get(overriden.getName());
                    for (Template template : candidates) {
                        if (!EcoreUtil.equals((EObject)template, (EObject)overriden)) continue;
                        match = template;
                        break;
                    }
                    this.dynamicOverrides.put(match, overriding);
                }
                if (overriding == null) continue;
                overriding.add(ownedTemplate);
            }
            if (ownedTemplate.getOverrides().size() != 0) continue;
            Set<Template> namesakes = this.templates.get(ownedTemplate.getName());
            if (namesakes == null) {
                namesakes = new LinkedHashSet<Template>();
                this.templates.put(ownedTemplate.getName(), namesakes);
            }
            namesakes.add(ownedTemplate);
        }
        this.currentModules.add(module);
    }

    private void mapDynamicOverrides() {
        Set<Module> dynamicModules = this.loadDynamicModules();
        for (Module module : dynamicModules) {
            this.mapDynamicModule(module, dynamicModules);
        }
    }

    private void mapOverridingTemplate(Template elem) {
        for (Template overriden : elem.getOverrides()) {
            Set<Template> overriding = this.overridingTemplates.get(overriden);
            if (overriding == null) {
                overriding = new LinkedHashSet<Template>();
                this.overridingTemplates.put(overriden, overriding);
            }
            overriding.add(elem);
        }
    }

    private Template mostSpecificTemplate(Template template1, Template template2, List<Object> actualArgumentTypes) {
        int template1SpecificArgumentCount = 0;
        int template2SpecificArgumentCount = 0;
        int i = 0;
        while (i < actualArgumentTypes.size()) {
            EClassifier template2Type;
            Object actualArgumentType = actualArgumentTypes.get(i);
            EClassifier template1Type = (EClassifier)((Variable)template1.getParameter().get(i)).getType();
            if (template1Type != (template2Type = (EClassifier)((Variable)template2.getParameter().get(i)).getType())) {
                if (actualArgumentType instanceof EObject) {
                    if (this.isSubTypeOf((EClass)template1Type, (EClass)template2Type)) {
                        ++template2SpecificArgumentCount;
                    } else {
                        ++template1SpecificArgumentCount;
                    }
                } else assert (false);
            }
            ++i;
        }
        Template mostSpecific = template1SpecificArgumentCount >= template2SpecificArgumentCount ? template1 : template2;
        return mostSpecific;
    }

    private List<Template> reorderCandidatesPriority(Module origin, Set<Template> candidates) {
        ArrayList<Template> reorderedList = new ArrayList<Template>(candidates.size());
        for (Template candidate : new LinkedHashSet<Template>(candidates)) {
            boolean isOverridingCandidate = false;
            Module module = (Module)candidate.eContainer();
            while (!isOverridingCandidate && module != null && module.getExtends().size() > 0) {
                if (module.getExtends().get(0) == origin) {
                    reorderedList.add(candidate);
                    candidates.remove(candidate);
                    isOverridingCandidate = true;
                }
                module = (Module)module.getExtends().get(0);
            }
        }
        for (Template candidate : new LinkedHashSet<Template>(candidates)) {
            if (candidate.eContainer() != origin) continue;
            reorderedList.add(candidate);
            candidates.remove(candidate);
        }
        for (Template candidate : new LinkedHashSet<Template>(candidates)) {
            for (Module extended : origin.getExtends()) {
                if (candidate.eContainer() != extended) continue;
                reorderedList.add(candidate);
                candidates.remove(candidate);
            }
        }
        for (Template candidate : new LinkedHashSet<Template>(candidates)) {
            for (Module imported : origin.getImports()) {
                if (candidate.eContainer() != imported) continue;
                reorderedList.add(candidate);
                candidates.remove(candidate);
            }
        }
        return reorderedList;
    }

    private List<Template> reorderDynamicOverrides(Set<Template> candidates) {
        ArrayList<Template> reorderedList = new ArrayList<Template>(candidates.size());
        LinkedHashSet<Template> lowest = new LinkedHashSet<Template>(candidates);
        while (!lowest.isEmpty()) {
            for (Template candidate : new LinkedHashSet<Template>(lowest)) {
                for (Template overriden : candidate.getOverrides()) {
                    if (!lowest.contains(overriden)) continue;
                    lowest.remove(overriden);
                }
            }
            if (lowest.isEmpty()) {
                ArrayList<Template> remainingCandidates = new ArrayList<Template>(candidates);
                remainingCandidates.removeAll(reorderedList);
                reorderedList.addAll(remainingCandidates);
                continue;
            }
            reorderedList.addAll(lowest);
            lowest.clear();
            lowest.addAll(candidates);
            lowest.removeAll(reorderedList);
        }
        return reorderedList;
    }
}

