/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.internal.ide.ui.editors.template.utils;

import java.io.IOException;
import org.eclipse.acceleo.ide.ui.AcceleoUIActivator;
import org.eclipse.acceleo.internal.ide.ui.editors.template.utils.AcceleoUIDocumentationMessages;
import org.eclipse.acceleo.internal.ide.ui.resource.AcceleoUIResourceSet;
import org.eclipse.acceleo.model.mtl.Documentation;
import org.eclipse.acceleo.model.mtl.DocumentedElement;
import org.eclipse.acceleo.model.mtl.Macro;
import org.eclipse.acceleo.model.mtl.Module;
import org.eclipse.acceleo.model.mtl.ModuleDocumentation;
import org.eclipse.acceleo.model.mtl.ModuleElement;
import org.eclipse.acceleo.model.mtl.ModuleElementDocumentation;
import org.eclipse.acceleo.model.mtl.ParameterDocumentation;
import org.eclipse.acceleo.model.mtl.Query;
import org.eclipse.acceleo.model.mtl.Template;
import org.eclipse.acceleo.model.mtl.VisibilityKind;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EParameter;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.ocl.ecore.Variable;
import org.eclipse.swt.graphics.Image;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class AcceleoUIDocumentationUtils {
    public static final String DEFAULT_BEGIN = "[";
    public static final String DEFAULT_END = "] ";
    public static final String DEFAULT_VARIABLE_SEPARATOR = " : ";
    public static final String HTML_BOLD_BEGIN = "<b>";
    public static final String HTML_BOLD_END = "</b>";
    public static final String TAB = "<dd>";
    public static final String EOL = "<br/>";

    private AcceleoUIDocumentationUtils() {
    }

    public static String getDocumentation(DocumentedElement element) {
        String result = "";
        Documentation documentation = element.getDocumentation();
        if (documentation == null) {
            documentation = AcceleoUIDocumentationUtils.getDocumentationFromFile(element);
        }
        result = documentation != null ? AcceleoUIDocumentationUtils.getTextFrom(documentation) : AcceleoUIDocumentationUtils.getSignatureFrom((EObject)element);
        return result;
    }

    public static Image getCompletionImage(Template template) {
        VisibilityKind visibility = template.getVisibility();
        Image image = null;
        switch (visibility) {
            case PRIVATE: {
                image = AcceleoUIActivator.getDefault().getImage("icons/template-editor/completion/Template_private.gif");
                break;
            }
            case PROTECTED: {
                image = AcceleoUIActivator.getDefault().getImage("icons/template-editor/completion/Template_protected.gif");
                break;
            }
            case PUBLIC: {
                image = AcceleoUIActivator.getDefault().getImage("icons/template-editor/completion/Template.gif");
                break;
            }
            default: {
                image = AcceleoUIActivator.getDefault().getImage("icons/template-editor/completion/Template.gif");
            }
        }
        return image;
    }

    public static Image getCompletionImage(Query query) {
        VisibilityKind visibility = query.getVisibility();
        Image image = null;
        switch (visibility) {
            case PRIVATE: {
                image = AcceleoUIActivator.getDefault().getImage("icons/template-editor/completion/Completion_Query_private.gif");
                break;
            }
            case PROTECTED: {
                image = AcceleoUIActivator.getDefault().getImage("icons/template-editor/completion/Completion_Query_protected.gif");
                break;
            }
            case PUBLIC: {
                image = AcceleoUIActivator.getDefault().getImage("icons/template-editor/completion/Completion_Query.gif");
                break;
            }
            default: {
                image = AcceleoUIActivator.getDefault().getImage("icons/template-editor/completion/Completion_Query.gif");
            }
        }
        return image;
    }

    public static Documentation getDocumentationFromFile(DocumentedElement element) {
        Resource eResource = element.eResource();
        Documentation documentation = null;
        if (eResource != null && !"http".equals(eResource.getURI().scheme())) {
            try {
                EObject eObject = AcceleoUIResourceSet.getResource(eResource.getURI());
                if (eObject instanceof Module) {
                    Module module = (Module)eObject;
                    if (element instanceof Module) {
                        documentation = module.getDocumentation();
                    }
                    if (element instanceof ModuleElement) {
                        documentation = AcceleoUIDocumentationUtils.getDocumentationFromModule(module, element);
                    }
                }
            }
            catch (IOException iOException) {
            }
            catch (WrappedException wrappedException) {
                // empty catch block
            }
        }
        return documentation;
    }

    private static Documentation getDocumentationFromModule(Module module, DocumentedElement element) {
        EList eContents = module.eContents();
        for (EObject eObject : eContents) {
            URI uriObject = EcoreUtil.getURI((EObject)eObject);
            URI uriElement = EcoreUtil.getURI((EObject)element);
            if (!(eObject instanceof DocumentedElement) || uriObject == null || !uriObject.equals((Object)uriElement)) continue;
            DocumentedElement documentedElement = (DocumentedElement)eObject;
            return documentedElement.getDocumentation();
        }
        return null;
    }

    public static String getTextFrom(EOperation eOperation) {
        String documentation;
        StringBuffer buffer = new StringBuffer();
        String parameters = "";
        for (EParameter eParameter : eOperation.getEParameters()) {
            parameters = String.valueOf(parameters) + eParameter.getEType().getName() + ' ' + eParameter.getName();
            if (eParameter.equals(eOperation.getEParameters().get(eOperation.getEParameters().size() - 1))) continue;
            parameters = String.valueOf(parameters) + ", ";
        }
        String type = "";
        if (eOperation.getEType() != null) {
            type = eOperation.getEType().getName();
        }
        buffer.append(HTML_BOLD_BEGIN + type + ' ' + eOperation.getName() + '(' + parameters + ')' + HTML_BOLD_END + EOL);
        String name = eOperation.getName();
        if (name.contains("=")) {
            name = name.replaceAll("=", "EQUALS");
        }
        if ((documentation = AcceleoUIDocumentationMessages.getString(String.valueOf(name) + '_' + eOperation.getEParameters().size())).startsWith("!") || documentation.endsWith("!")) {
            return AcceleoUIDocumentationUtils.getSignatureFrom((EObject)eOperation);
        }
        buffer.append(String.valueOf(documentation.replaceAll("\n", EOL)) + EOL);
        return buffer.toString();
    }

    public static String getTextFrom(Documentation documentation) {
        String result = "";
        if (documentation instanceof ModuleElementDocumentation) {
            result = AcceleoUIDocumentationUtils.getTextFrom((ModuleElementDocumentation)documentation);
        } else if (documentation instanceof ModuleDocumentation) {
            result = AcceleoUIDocumentationUtils.getTextFrom((ModuleDocumentation)documentation);
        }
        if (documentation.getDocumentedElement().isDeprecated()) {
            result = String.valueOf(result) + AcceleoUIDocumentationUtils.computeDepreciationReason(documentation);
        }
        return result;
    }

    private static String getTextFrom(ModuleElementDocumentation templateDocumentation) {
        DocumentedElement element;
        StringBuffer res = new StringBuffer();
        res.append(HTML_BOLD_BEGIN + AcceleoUIDocumentationUtils.getSignatureFrom((EObject)templateDocumentation.getDocumentedElement()) + HTML_BOLD_END + EOL + EOL);
        res.append(String.valueOf(AcceleoUIDocumentationUtils.computeDescriptionFrom((Documentation)templateDocumentation)) + EOL);
        EList parametersDocumentation = templateDocumentation.getParametersDocumentation();
        if (parametersDocumentation.size() > 0) {
            res.append(AcceleoUIDocumentationUtils.getParameterTextFrom(templateDocumentation));
        }
        if ((element = templateDocumentation.getDocumentedElement()) instanceof Template) {
            Template template = (Template)element;
            EList overrides = template.getOverrides();
            for (Template override : overrides) {
                res.append("<br/><b>Overrides:</b><br/>");
                if (!(override.eContainer() instanceof Module)) continue;
                Module module = (Module)override.eContainer();
                res.append("<dd>Template " + override.getName() + " in Module " + module.getName() + EOL);
            }
        }
        return res.toString();
    }

    private static String getParameterTextFrom(ModuleElementDocumentation moduleElementDocumentation) {
        StringBuffer res = new StringBuffer();
        DocumentedElement documentedElement = moduleElementDocumentation.getDocumentedElement();
        EList parameters = null;
        if (documentedElement instanceof Template) {
            Template template = (Template)documentedElement;
            parameters = template.getParameter();
        }
        if (documentedElement instanceof Query) {
            Query query = (Query)documentedElement;
            parameters = query.getParameter();
        }
        if (documentedElement instanceof Macro) {
            Macro macro = (Macro)documentedElement;
            parameters = macro.getParameter();
        }
        if (parameters != null) {
            if (parameters.size() == 1) {
                res.append("<br/><b>Parameter:</b><br/>");
            } else {
                res.append("<br/><b>Parameters:</b><br/>");
            }
            for (ParameterDocumentation parameterDocumentation : moduleElementDocumentation.getParametersDocumentation()) {
                res.append("<dd><b>" + parameterDocumentation.getName() + '(' + AcceleoUIDocumentationUtils.getTypeOfParameter((EList<Variable>)parameters, parameterDocumentation.getName()) + ')' + HTML_BOLD_END + ' ' + parameterDocumentation.getBody().getValue() + EOL);
            }
        }
        return res.toString();
    }

    private static String getTypeOfParameter(EList<Variable> parameters, String parameterName) {
        for (Variable variable : parameters) {
            if (variable == null || variable.getType() == null || !variable.getName().equals(parameterName)) continue;
            return ((EClassifier)variable.getType()).getName();
        }
        return "";
    }

    private static String getTextFrom(ModuleDocumentation moduleDocumentation) {
        StringBuffer res = new StringBuffer();
        res.append(HTML_BOLD_BEGIN + AcceleoUIDocumentationUtils.getSignatureFrom((EObject)moduleDocumentation.getDocumentedElement()) + HTML_BOLD_END + EOL);
        res.append(String.valueOf(AcceleoUIDocumentationUtils.computeDescriptionFrom((Documentation)moduleDocumentation)) + EOL);
        if (moduleDocumentation.getVersion() != null && !"".equals(moduleDocumentation.getVersion())) {
            res.append("<b>Version:</b><br/>");
            res.append(TAB + moduleDocumentation.getVersion() + '\n');
        }
        if (moduleDocumentation.getAuthor() != null && !"".equals(moduleDocumentation.getAuthor())) {
            res.append("<b>Author:</b><br/>");
            res.append(TAB + moduleDocumentation.getAuthor() + EOL);
        }
        return res.toString();
    }

    private static String computeDescriptionFrom(Documentation documentation) {
        String value = documentation.getBody().getValue();
        int index = value.indexOf("@");
        if (index != -1) {
            return value.substring(0, index);
        }
        return value;
    }

    private static String computeDepreciationReason(Documentation documentation) {
        String value = documentation.getBody().getValue();
        int index = value.indexOf("@deprecated");
        if (index != -1) {
            value = "<b>Deprecated:<br/></b><dd>" + value.substring(index + "@deprecated".length()).trim();
        } else {
            DocumentedElement element = documentation.getDocumentedElement();
            if (element instanceof ModuleElement && element.eContainer() instanceof Module) {
                Module module = (Module)element.eContainer();
                if (module.isDeprecated()) {
                    value = "<b>Deprecated:<br/></b><dd>See module \"" + module.getName() + "\"";
                }
            } else {
                value = "";
            }
        }
        return value;
    }

    public static String getSignatureFrom(EObject object) {
        StringBuffer res = new StringBuffer();
        res.append(DEFAULT_BEGIN);
        res.append(object.eClass().getName());
        res.append(DEFAULT_END);
        if (object instanceof Module) {
            res.append(AcceleoUIDocumentationUtils.getSignatureFrom((Module)object));
        } else if (object instanceof Variable) {
            res.append(AcceleoUIDocumentationUtils.getSignatureFrom((Variable)object));
        } else if (object instanceof ModuleElement) {
            res.append(AcceleoUIDocumentationUtils.getSignatureFrom((ModuleElement)object));
        } else if (object instanceof EOperation) {
            res.append(AcceleoUIDocumentationUtils.getSignatureFrom((EOperation)object));
        } else if (object instanceof EStructuralFeature) {
            res.append(AcceleoUIDocumentationUtils.getSignatureFrom((EStructuralFeature)object));
        } else if (object instanceof EClass) {
            res.append(AcceleoUIDocumentationUtils.getSignatureFrom((EClass)object));
        }
        return res.toString();
    }

    private static String getSignatureFrom(Module module) {
        return module.getName();
    }

    private static String getSignatureFrom(Variable variable) {
        StringBuffer res = new StringBuffer();
        res.append(variable.getName());
        if (variable.getType() != null) {
            res.append(DEFAULT_VARIABLE_SEPARATOR);
            res.append(((EClassifier)variable.getType()).getName());
        }
        return res.toString();
    }

    private static String getSignatureFrom(ModuleElement moduleElement) {
        StringBuffer res = new StringBuffer();
        res.append(String.valueOf(moduleElement.getVisibility().getName()) + ' ');
        res.append(moduleElement.getName());
        if (moduleElement instanceof Template) {
            res.append(AcceleoUIDocumentationUtils.getSignatureFrom((Template)moduleElement));
        } else if (moduleElement instanceof Macro) {
            res.append(AcceleoUIDocumentationUtils.getSignatureFrom((Macro)moduleElement));
        } else if (moduleElement instanceof Query) {
            res.append(AcceleoUIDocumentationUtils.getSignatureFrom((Query)moduleElement));
        }
        return res.toString();
    }

    private static String getSignatureFrom(Template template) {
        StringBuffer res = new StringBuffer();
        res.append('(');
        boolean first = true;
        for (Variable iVariable : template.getParameter()) {
            if (first) {
                first = false;
            } else {
                res.append(',');
            }
            if (iVariable.getType() == null) continue;
            res.append(((EClassifier)iVariable.getType()).getName());
        }
        res.append(')');
        return res.toString();
    }

    private static String getSignatureFrom(Macro macro) {
        StringBuffer res = new StringBuffer();
        res.append('(');
        boolean first = true;
        for (Variable iVariable : macro.getParameter()) {
            if (first) {
                first = false;
            } else {
                res.append(',');
            }
            if (iVariable.getType() == null) continue;
            res.append(((EClassifier)iVariable.getType()).getName());
        }
        res.append(')');
        if (macro.getType() != null) {
            res.append(DEFAULT_VARIABLE_SEPARATOR);
            res.append(macro.getType().getName());
        }
        return res.toString();
    }

    private static String getSignatureFrom(Query query) {
        StringBuffer res = new StringBuffer();
        res.append('(');
        boolean first = true;
        for (Variable iVariable : query.getParameter()) {
            if (first) {
                first = false;
            } else {
                res.append(',');
            }
            if (iVariable.getType() == null) continue;
            res.append(((EClassifier)iVariable.getType()).getName());
        }
        res.append(')');
        if (query.getType() != null) {
            res.append(DEFAULT_VARIABLE_SEPARATOR);
            res.append(query.getType().getName());
        }
        return res.toString();
    }

    private static String getSignatureFrom(EOperation operation) {
        StringBuffer res = new StringBuffer();
        res.append(operation.getName());
        res.append('(');
        boolean first = true;
        for (EParameter eParameter : operation.getEParameters()) {
            if (first) {
                first = false;
            } else {
                res.append(',');
            }
            if (eParameter.getEType() == null) continue;
            res.append(eParameter.getEType().getName());
        }
        res.append(')');
        if (operation.getEType() != null) {
            res.append(DEFAULT_VARIABLE_SEPARATOR);
            res.append(operation.getEType().getName());
        }
        return res.toString();
    }

    private static String getSignatureFrom(EStructuralFeature feature) {
        StringBuffer res = new StringBuffer();
        res.append(feature.getName());
        if (feature.getEType() != null) {
            res.append(DEFAULT_VARIABLE_SEPARATOR);
            res.append(feature.getEType().getName());
            res.append(" [");
            res.append(feature.getLowerBound());
            res.append("..");
            if (feature.getUpperBound() == -1) {
                res.append("*");
            } else {
                res.append(feature.getUpperBound());
            }
            res.append("]");
        }
        return res.toString();
    }

    private static String getSignatureFrom(EClass eClass) {
        return eClass.getName();
    }
}

