/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.internal.ide.ui.editors.template.quickfix;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.acceleo.internal.ide.ui.editors.template.quickfix.ProblemMarkerResolutionProposal;
import org.eclipse.core.resources.IMarker;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.quickassist.IQuickAssistInvocationContext;
import org.eclipse.jface.text.quickassist.IQuickAssistProcessor;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.ui.IMarkerResolution;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.texteditor.MarkerAnnotation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AcceleoQuickFixProcessor
implements IQuickAssistProcessor {
    public boolean canAssist(IQuickAssistInvocationContext invocationContext) {
        return false;
    }

    public boolean canFix(Annotation annotation) {
        return annotation != null && "org.eclipse.acceleo.ide.ui.annotation.problem".equals(annotation.getType());
    }

    public ICompletionProposal[] computeQuickAssistProposals(IQuickAssistInvocationContext invocationContext) {
        ArrayList<ICompletionProposal> proposals = new ArrayList<ICompletionProposal>();
        if (invocationContext != null) {
            ISourceViewer sourceViewer = invocationContext.getSourceViewer();
            int offset = invocationContext.getOffset();
            List<Annotation> annotations = this.findAnnotationsAt(sourceViewer, offset);
            for (Annotation annotation : annotations) {
                AcceleoQuickFixProcessor.collectMarkerProposals(annotation, proposals);
            }
        }
        return proposals.toArray(new ICompletionProposal[proposals.size()]);
    }

    private List<Annotation> findAnnotationsAt(ISourceViewer sourceViewer, int offset) {
        IAnnotationModel annotationModel;
        ArrayList<Annotation> annotations = new ArrayList<Annotation>();
        if (sourceViewer != null && offset > -1 && (annotationModel = sourceViewer.getAnnotationModel()) != null) {
            Iterator it = annotationModel.getAnnotationIterator();
            while (it.hasNext()) {
                Annotation annotation = (Annotation)it.next();
                Position position = annotationModel.getPosition(annotation);
                if (position == null || offset < position.offset || offset > position.offset + position.length) continue;
                annotations.add(annotation);
            }
        }
        return annotations;
    }

    private static void collectMarkerProposals(Annotation annotation, Collection<ICompletionProposal> proposals) {
        IMarkerResolution[] res;
        IMarker marker;
        if (annotation instanceof MarkerAnnotation && (marker = ((MarkerAnnotation)annotation).getMarker()) != null && (res = IDE.getMarkerHelpRegistry().getResolutions(marker)) != null && res.length > 0) {
            int i = 0;
            while (i < res.length) {
                proposals.add(new ProblemMarkerResolutionProposal(res[i], marker));
                ++i;
            }
        }
    }

    public String getErrorMessage() {
        return null;
    }
}

