/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.internal.traceability.engine;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.acceleo.common.utils.CompactLinkedHashSet;
import org.eclipse.acceleo.traceability.GeneratedText;
import org.eclipse.acceleo.traceability.InputElement;
import org.eclipse.acceleo.traceability.TraceabilityFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractTrace {
    protected int currentOffset;
    protected final LinkedHashMap<InputElement, Set<GeneratedText>> traces = new LinkedHashMap();

    public void addTrace(InputElement input, GeneratedText trace, int length) {
        CompactLinkedHashSet referredTraces = this.traces.get(input);
        if (referredTraces == null) {
            referredTraces = new CompactLinkedHashSet();
            this.traces.put(input, (Set<GeneratedText>)referredTraces);
        }
        int startOffset = this.currentOffset;
        this.currentOffset += length;
        trace.setSourceElement(input);
        trace.setStartOffset(startOffset);
        trace.setEndOffset(this.currentOffset);
        referredTraces.add(trace);
    }

    public void addTrace(InputElement input, GeneratedText trace, Object value) {
        this.addTrace(input, trace, value.toString().length());
    }

    public void addTraceCopy(AbstractTrace other) {
        int gap = this.currentOffset;
        for (Map.Entry<InputElement, Set<GeneratedText>> entry : other.getTraces().entrySet()) {
            InputElement input = entry.getKey();
            CompactLinkedHashSet referredTraces = this.traces.get(input);
            if (referredTraces == null) {
                referredTraces = new CompactLinkedHashSet();
                this.traces.put(input, (Set<GeneratedText>)referredTraces);
            }
            for (GeneratedText original : entry.getValue()) {
                GeneratedText text = TraceabilityFactory.eINSTANCE.createGeneratedText();
                this.currentOffset = this.currentOffset + original.getEndOffset() - original.getStartOffset();
                text.setSourceElement(input);
                text.setStartOffset(original.getStartOffset() + gap);
                text.setEndOffset(original.getEndOffset() + gap);
                text.setModuleElement(original.getModuleElement());
                referredTraces.add(text);
            }
        }
    }

    public void dispose() {
        for (Map.Entry<InputElement, Set<GeneratedText>> entry : this.traces.entrySet()) {
            entry.getValue().clear();
        }
        this.traces.clear();
    }

    public int getOffset() {
        return this.currentOffset;
    }

    public LinkedHashMap<InputElement, Set<GeneratedText>> getTraces() {
        return this.traces;
    }

    public void setOffset(int offset) {
        this.currentOffset = offset;
    }
}

