/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.internal.ide.ui.wizards.project;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import org.eclipse.acceleo.internal.ide.ui.AcceleoUIMessages;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.IVMInstall2;
import org.eclipse.jdt.launching.IVMInstallType;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jdt.launching.VMStandin;
import org.eclipse.jdt.launching.environments.IExecutionEnvironment;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.util.Policy;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.eclipse.ui.dialogs.WizardNewProjectCreationPage;

public class AcceleoProjectPage
extends WizardNewProjectCreationPage {
    private static final String LAST_SELECTED_EE_SETTINGS_KEY = "org.eclipse.jdt.ui.last.selected.execution.enviroment";
    private static final String LAST_SELECTED_JRE_SETTINGS_KEY = "org.eclipse.jdt.ui.last.selected.project.jre";
    private Link fPreferenceLink;
    private IVMInstall[] fInstalledJVMs;
    private String[] fJRECompliance;
    private IExecutionEnvironment[] fInstalledEEs;
    private String[] fEECompliance;
    private IStructuredSelection selection;
    private Button executionEnvJREButton;
    private Button projectSpecificJREButton;
    private Button defaultJREButton;
    private Combo executionEnvJRECombo;
    private Combo projectSpecificJRECombo;

    public AcceleoProjectPage(String pageName, IStructuredSelection selection) {
        super(pageName);
        this.selection = selection;
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        this.createJREGroup((Composite)this.getControl());
        this.createWorkingSetGroup((Composite)this.getControl(), this.selection, new String[]{"org.eclipse.ui.resourceWorkingSetPage", "org.eclipse.jdt.ui.JavaWorkingSetPage"});
        Dialog.applyDialogFont((Control)this.getControl());
    }

    private void createJREGroup(Composite parent) {
        Group jreGroup = new Group(parent, 0);
        jreGroup.setLayoutData((Object)new GridData(768));
        jreGroup.setFont(parent.getFont());
        jreGroup.setLayout((Layout)this.initGridLayout(new GridLayout(2, false), true));
        jreGroup.setText(AcceleoUIMessages.getString("AcceleoProjectPage.JRE"));
        this.executionEnvJREButton = new Button((Composite)jreGroup, 16);
        this.executionEnvJREButton.setText(AcceleoUIMessages.getString("AcceleoProjectPage.ExecutionEnvironmentButtonLabel"));
        GridData gd = new GridData();
        gd.horizontalSpan = 1;
        gd.horizontalAlignment = 4;
        this.executionEnvJREButton.setLayoutData((Object)gd);
        this.executionEnvJRECombo = new Combo((Composite)jreGroup, 8);
        this.executionEnvJRECombo.setLayoutData((Object)new GridData(4, 2, true, false));
        this.projectSpecificJREButton = new Button((Composite)jreGroup, 16);
        this.projectSpecificJREButton.setText(AcceleoUIMessages.getString("AcceleoProjectPage.ProjectSpecificButtonLabel"));
        gd = new GridData();
        gd.horizontalSpan = 1;
        gd.horizontalAlignment = 4;
        this.projectSpecificJREButton.setLayoutData((Object)gd);
        this.projectSpecificJRECombo = new Combo((Composite)jreGroup, 8);
        this.projectSpecificJRECombo.setLayoutData((Object)new GridData(4, 2, true, false));
        this.defaultJREButton = new Button((Composite)jreGroup, 16);
        this.defaultJREButton.setText(AcceleoUIMessages.getString("AcceleoProjectPage.DefaultJREButtonLabel", this.getDefaultJVMName()));
        gd = new GridData();
        gd.horizontalSpan = 1;
        gd.horizontalAlignment = 4;
        this.defaultJREButton.setLayoutData((Object)gd);
        this.fPreferenceLink = new Link((Composite)jreGroup, 0);
        this.fPreferenceLink.setFont(jreGroup.getFont());
        this.fPreferenceLink.setText(AcceleoUIMessages.getString("AcceleoProjectPage.ConfigureJRE"));
        this.fPreferenceLink.setLayoutData((Object)new GridData(3, 2, false, false));
        this.fPreferenceLink.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                this.widgetDefaultSelected(e);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                String jreID = "org.eclipse.jdt.debug.ui.preferences.VMPreferencePage";
                String eeID = "org.eclipse.jdt.debug.ui.jreProfiles";
                String complianceId = "org.eclipse.jdt.ui.preferences.CompliancePreferencePage";
                String dataNoLink = "PropertyAndPreferencePage.nolink";
                HashMap<String, Boolean> data = new HashMap<String, Boolean>();
                data.put("PropertyAndPreferencePage.nolink", Boolean.TRUE);
                PreferencesUtil.createPreferenceDialogOn((Shell)AcceleoProjectPage.this.getShell(), (String)"org.eclipse.jdt.debug.ui.preferences.VMPreferencePage", (String[])new String[]{"org.eclipse.jdt.debug.ui.preferences.VMPreferencePage", "org.eclipse.jdt.ui.preferences.CompliancePreferencePage", "org.eclipse.jdt.debug.ui.jreProfiles"}, data).open();
                AcceleoProjectPage.this.defaultJREButton.setText(AcceleoUIMessages.getString("AcceleoProjectPage.DefaultJREButtonLabel", AcceleoProjectPage.this.getDefaultJVMName()));
                AcceleoProjectPage.this.fillInstalledJREs();
                AcceleoProjectPage.this.fillExecutionEnvironments();
            }
        });
        this.fillInstalledJREs();
        this.fillExecutionEnvironments();
        this.executionEnvJREButton.setSelection(true);
        SelectionListener listener = new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                AcceleoProjectPage.this.checkCompatibleEnvironment();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                AcceleoProjectPage.this.checkCompatibleEnvironment();
            }
        };
        this.executionEnvJREButton.addSelectionListener(listener);
        this.executionEnvJRECombo.addSelectionListener(listener);
        this.projectSpecificJREButton.addSelectionListener(listener);
        this.projectSpecificJRECombo.addSelectionListener(listener);
        this.defaultJREButton.addSelectionListener(listener);
    }

    private void checkCompatibleEnvironment() {
        if (this.executionEnvJREButton.getSelection()) {
            String text = this.executionEnvJRECombo.getText();
            if (!"J2SE-1.5".equals(text) && !"JavaSE-1.6".equals(text)) {
                this.setMessage(AcceleoUIMessages.getString("AcceleoProjectPage.NotJava5or6"), 2);
            } else {
                this.setMessage(null);
            }
        } else {
            this.setMessage(AcceleoUIMessages.getString("AcceleoProjectPage.NotJava5or6"), 2);
        }
    }

    private String getLastSelectedEE() {
        IDialogSettings settings = JavaPlugin.getDefault().getDialogSettings();
        return settings.get(LAST_SELECTED_EE_SETTINGS_KEY);
    }

    private String getLastSelectedJRE() {
        IDialogSettings settings = JavaPlugin.getDefault().getDialogSettings();
        return settings.get(LAST_SELECTED_JRE_SETTINGS_KEY);
    }

    private String getDefaultJVMName() {
        IVMInstall install = JavaRuntime.getDefaultVMInstall();
        if (install != null) {
            return install.getName();
        }
        return AcceleoUIMessages.getString("AcceleoProjectPage.Unknown");
    }

    private String getDefaultEEName() {
        IVMInstall defaultVM = JavaRuntime.getDefaultVMInstall();
        IExecutionEnvironment[] environments = JavaRuntime.getExecutionEnvironmentsManager().getExecutionEnvironments();
        if (defaultVM != null) {
            int i = 0;
            while (i < environments.length) {
                IVMInstall eeDefaultVM = environments[i].getDefaultVM();
                if (eeDefaultVM != null && defaultVM.getId().equals(eeDefaultVM.getId())) {
                    return environments[i].getId();
                }
                ++i;
            }
        }
        String defaultCC = defaultVM instanceof IVMInstall2 ? JavaModelUtil.getCompilerCompliance((IVMInstall2)((IVMInstall2)defaultVM), (String)"1.4") : "1.4";
        String result = "JavaSE-1.6";
        int i = 0;
        while (i < environments.length) {
            String eeCompliance = JavaModelUtil.getExecutionEnvironmentCompliance((IExecutionEnvironment)environments[i]);
            if (defaultCC.endsWith(eeCompliance)) {
                result = environments[i].getId();
                break;
            }
            ++i;
        }
        return result;
    }

    public String getSelectedJVM() {
        String selectedVM = this.getDefaultJVMName();
        if (this.projectSpecificJREButton.getSelection()) {
            int index = this.projectSpecificJRECombo.getSelectionIndex();
            if (index >= 0 && index < this.fInstalledJVMs.length) {
                selectedVM = this.fInstalledJVMs[index].getName();
            }
        } else if (this.executionEnvJREButton.getSelection()) {
            selectedVM = this.executionEnvJRECombo.getText();
        }
        return selectedVM;
    }

    public IPath getJREContainerPath() {
        int index;
        IPath jerContainerPath = JavaRuntime.newJREContainerPath((IVMInstall)JavaRuntime.getDefaultVMInstall());
        if (this.projectSpecificJREButton.getSelection()) {
            int index2 = this.projectSpecificJRECombo.getSelectionIndex();
            if (index2 >= 0 && index2 < this.fInstalledJVMs.length) {
                jerContainerPath = JavaRuntime.newJREContainerPath((IVMInstall)this.fInstalledJVMs[index2]);
            }
        } else if (this.executionEnvJREButton.getSelection() && (index = this.executionEnvJRECombo.getSelectionIndex()) >= 0 && index < this.fInstalledEEs.length) {
            jerContainerPath = JavaRuntime.newJREContainerPath((IExecutionEnvironment)this.fInstalledEEs[index]);
        }
        return jerContainerPath;
    }

    private String getSelectedCompilerCompliance() {
        int index;
        String selectedCompilerCompilance = null;
        if (this.projectSpecificJREButton.getSelection()) {
            int index2 = this.projectSpecificJRECombo.getSelectionIndex();
            if (index2 >= 0 && index2 < this.fJRECompliance.length) {
                selectedCompilerCompilance = this.fJRECompliance[index2];
            }
        } else if (this.executionEnvJREButton.getSelection() && (index = this.executionEnvJRECombo.getSelectionIndex()) >= 0 && index < this.fEECompliance.length) {
            selectedCompilerCompilance = this.fEECompliance[index];
        }
        return selectedCompilerCompilance;
    }

    private IVMInstall[] getWorkspaceJREs() {
        ArrayList<VMStandin> standins = new ArrayList<VMStandin>();
        IVMInstallType[] types = JavaRuntime.getVMInstallTypes();
        int i = 0;
        while (i < types.length) {
            IVMInstallType type = types[i];
            IVMInstall[] installs = type.getVMInstalls();
            int j = 0;
            while (j < installs.length) {
                IVMInstall install = installs[j];
                standins.add(new VMStandin(install));
                ++j;
            }
            ++i;
        }
        return standins.toArray(new IVMInstall[standins.size()]);
    }

    private GridLayout initGridLayout(GridLayout layout, boolean margins) {
        layout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        layout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
        if (margins) {
            layout.marginWidth = this.convertHorizontalDLUsToPixels(7);
            layout.marginHeight = this.convertVerticalDLUsToPixels(7);
        } else {
            layout.marginWidth = 0;
            layout.marginHeight = 0;
        }
        return layout;
    }

    private void fillInstalledJREs() {
        String selectedItem = this.getLastSelectedJRE();
        int selectionIndex = -1;
        if (this.projectSpecificJREButton.getSelection() && (selectionIndex = this.projectSpecificJRECombo.getSelectionIndex()) != -1) {
            selectedItem = this.projectSpecificJRECombo.getItems()[selectionIndex];
        }
        this.fInstalledJVMs = this.getWorkspaceJREs();
        Arrays.sort(this.fInstalledJVMs, new Comparator<IVMInstall>(){

            @Override
            public int compare(IVMInstall i0, IVMInstall i1) {
                if (i1 instanceof IVMInstall2 && i0 instanceof IVMInstall2) {
                    String cc0 = JavaModelUtil.getCompilerCompliance((IVMInstall2)((IVMInstall2)i0), (String)"1.4");
                    String cc1 = JavaModelUtil.getCompilerCompliance((IVMInstall2)((IVMInstall2)i1), (String)"1.4");
                    int result = cc1.compareTo(cc0);
                    if (result != 0) {
                        return result;
                    }
                }
                return Policy.getComparator().compare(i0.getName(), i1.getName());
            }
        });
        selectionIndex = -1;
        String[] jreLabels = new String[this.fInstalledJVMs.length];
        this.fJRECompliance = new String[this.fInstalledJVMs.length];
        int i = 0;
        while (i < this.fInstalledJVMs.length) {
            jreLabels[i] = this.fInstalledJVMs[i].getName();
            if (selectedItem != null && jreLabels[i].equals(selectedItem)) {
                selectionIndex = i;
            }
            this.fJRECompliance[i] = this.fInstalledJVMs[i] instanceof IVMInstall2 ? JavaModelUtil.getCompilerCompliance((IVMInstall2)((IVMInstall2)this.fInstalledJVMs[i]), (String)"1.4") : "1.4";
            ++i;
        }
        this.projectSpecificJRECombo.setItems(jreLabels);
        if (selectionIndex == -1) {
            this.projectSpecificJRECombo.setText(this.getDefaultJVMName());
        } else {
            this.projectSpecificJRECombo.setText(selectedItem);
        }
    }

    private void fillExecutionEnvironments() {
        String selectedItem = this.getLastSelectedEE();
        int selectionIndex = -1;
        if (this.executionEnvJREButton.getSelection() && (selectionIndex = this.executionEnvJRECombo.getSelectionIndex()) != -1) {
            selectedItem = this.executionEnvJRECombo.getItems()[selectionIndex];
        }
        this.fInstalledEEs = JavaRuntime.getExecutionEnvironmentsManager().getExecutionEnvironments();
        Arrays.sort(this.fInstalledEEs, new Comparator<IExecutionEnvironment>(){

            @Override
            public int compare(IExecutionEnvironment arg0, IExecutionEnvironment arg1) {
                return Policy.getComparator().compare(arg0.getId(), arg1.getId());
            }
        });
        selectionIndex = -1;
        String[] eeLabels = new String[this.fInstalledEEs.length];
        this.fEECompliance = new String[this.fInstalledEEs.length];
        int i = 0;
        while (i < this.fInstalledEEs.length) {
            eeLabels[i] = this.fInstalledEEs[i].getId();
            if (selectedItem != null && eeLabels[i].equals(selectedItem)) {
                selectionIndex = i;
            }
            this.fEECompliance[i] = JavaModelUtil.getExecutionEnvironmentCompliance((IExecutionEnvironment)this.fInstalledEEs[i]);
            ++i;
        }
        this.executionEnvJRECombo.setItems(eeLabels);
        if (selectionIndex == -1) {
            this.executionEnvJRECombo.setText(this.getDefaultEEName());
        } else {
            this.executionEnvJRECombo.setText(selectedItem);
        }
    }
}

