/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.internal.ide.ui.editors.template.scanner;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.acceleo.common.internal.utils.compatibility.AcceleoOCLReflection;
import org.eclipse.acceleo.internal.ide.ui.editors.template.color.AcceleoColor;
import org.eclipse.acceleo.internal.ide.ui.editors.template.rules.BlockNameRule;
import org.eclipse.acceleo.internal.ide.ui.editors.template.rules.FirstParenthesisRule;
import org.eclipse.acceleo.internal.ide.ui.editors.template.rules.ISequenceRule;
import org.eclipse.acceleo.internal.ide.ui.editors.template.rules.KeywordRule;
import org.eclipse.acceleo.internal.ide.ui.editors.template.rules.KeywordSequenceRule;
import org.eclipse.acceleo.internal.ide.ui.editors.template.rules.OverrideNameRule;
import org.eclipse.acceleo.internal.ide.ui.editors.template.rules.SequenceBlockRule;
import org.eclipse.acceleo.internal.ide.ui.editors.template.rules.VariableRule;
import org.eclipse.acceleo.internal.ide.ui.editors.template.scanner.AbstractAcceleoScanner;
import org.eclipse.acceleo.internal.ide.ui.editors.template.scanner.AcceleoToken;
import org.eclipse.acceleo.internal.ide.ui.editors.template.scanner.AcceleoWhitespaceDetector;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.jface.text.rules.IRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.IWhitespaceDetector;
import org.eclipse.jface.text.rules.WhitespaceRule;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AcceleoTemplateScanner
extends AbstractAcceleoScanner {
    public AcceleoTemplateScanner(IEclipsePreferences[] lookupOrder) {
        super(lookupOrder);
    }

    @Override
    protected void createRules() {
        ArrayList<SequenceBlockRule> rules = new ArrayList<SequenceBlockRule>();
        AcceleoToken literalToken = this.createToken(AcceleoColor.LITERAL);
        rules.add(new SequenceBlockRule((ISequenceRule)new KeywordRule("'"), (ISequenceRule)new KeywordRule("'"), new KeywordRule("\\'"), (IToken)literalToken));
        rules.add((SequenceBlockRule)new WhitespaceRule((IWhitespaceDetector)new AcceleoWhitespaceDetector()));
        rules.add((SequenceBlockRule)this.computeFirstParenthesisRule());
        rules.addAll(this.computeKeywordRules());
        rules.addAll(this.computeDelimiterRules());
        rules.add((SequenceBlockRule)this.computeVariableRule());
        rules.add((SequenceBlockRule)this.computeTemplateNameRule());
        rules.add((SequenceBlockRule)this.computeOverrideNameRule());
        rules.addAll(this.computeOCLKeywordRules());
        this.setRules(rules.toArray(new IRule[rules.size()]));
        this.setDefaultReturnToken((IToken)this.createToken(AcceleoColor.TEMPLATE_OCL_EXPRESSION));
    }

    private IRule computeFirstParenthesisRule() {
        return new FirstParenthesisRule("template", (IToken)this.createToken(AcceleoColor.TEMPLATE, null, 1));
    }

    private List<IRule> computeKeywordRules() {
        ArrayList<IRule> rules = new ArrayList<IRule>();
        rules.add(this.computeKeywordRule("[", "template", null));
        rules.add(this.computeKeywordRule("/", "template", "]"));
        rules.add(this.computeKeywordRule(")", "overrides", null));
        rules.add(this.computeKeywordRule(null, "?", "("));
        rules.add(this.computeKeywordRule(null, "post", "("));
        rules.add(this.computeKeywordRule("template", "public", null));
        rules.add(this.computeKeywordRule("template", "protected", null));
        rules.add(this.computeKeywordRule("template", "private", null));
        return rules;
    }

    private IRule computeKeywordRule(String precedingDelimiter, String keyword, String followingDelimiter) {
        return new KeywordSequenceRule(precedingDelimiter, keyword, followingDelimiter, (IToken)this.createToken(AcceleoColor.TEMPLATE, null, 1));
    }

    private List<IRule> computeDelimiterRules() {
        ArrayList<IRule> rules = new ArrayList<IRule>();
        rules.add(this.computeDelimiterRule(null, "[", "template"));
        rules.add(this.computeDelimiterRule(null, "[", "/"));
        rules.add(this.computeDelimiterRule("[", "/", null));
        rules.add(this.computeDelimiterRule(null, "/", "]"));
        rules.add(this.computeDelimiterRule(")", "]", null));
        rules.add(this.computeDelimiterRule("}", "]", null));
        rules.add(this.computeDelimiterRule("template", "]", null));
        rules.add(this.computeDelimiterRule("template", "(", null));
        rules.add(this.computeDelimiterRule("overrides", "(", null));
        rules.add(this.computeDelimiterRule("?", "(", null));
        rules.add(this.computeDelimiterRule("post", "(", null));
        rules.add(this.computeDelimiterRule(null, ")", "overrides"));
        rules.add(this.computeDelimiterRule(null, ")", "?"));
        rules.add(this.computeDelimiterRule(null, ")", "post"));
        rules.add(this.computeDelimiterRule(null, ")", "{"));
        rules.add(this.computeDelimiterRule(null, ")", "]"));
        rules.add(this.computeDelimiterRule(")", "{", null));
        rules.add(this.computeDelimiterRule(null, "}", "]"));
        return rules;
    }

    private IRule computeDelimiterRule(String precedingText, String delimiter, String followingText) {
        return new KeywordSequenceRule(precedingText, delimiter, followingText, (IToken)this.createToken(AcceleoColor.TEMPLATE, null, 1));
    }

    private IRule computeTemplateNameRule() {
        return new BlockNameRule("template", (IToken)this.createToken(AcceleoColor.TEMPLATE_NAME, null, 0));
    }

    private IRule computeOverrideNameRule() {
        return new OverrideNameRule((IToken)this.createToken(AcceleoColor.TEMPLATE_NAME, null, 0));
    }

    private IRule computeVariableRule() {
        return new VariableRule(new String[0], (IToken)this.createToken(AcceleoColor.TEMPLATE_PARAMETER, null, 0));
    }

    private List<IRule> computeOCLKeywordRules() {
        ArrayList<IRule> rules = new ArrayList<IRule>();
        for (String keyword : AcceleoOCLReflection.getReservedKeywords()) {
            rules.add((IRule)new KeywordRule(keyword, true, false, (IToken)this.createToken(AcceleoColor.TEMPLATE_OCL_KEYWORD, null, 1)));
        }
        return rules;
    }

    @Override
    public String getConfiguredContentType() {
        return "__ACCELEO_template";
    }
}

