/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.common.internal.utils.compatibility;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Set;
import org.eclipse.acceleo.common.AcceleoCommonPlugin;
import org.eclipse.acceleo.common.internal.utils.compatibility.AcceleoCompatibilityHelper;
import org.eclipse.acceleo.common.internal.utils.compatibility.OCLVersion;
import org.eclipse.acceleo.common.utils.CompactHashSet;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.ocl.ecore.EcoreEnvironment;
import org.eclipse.ocl.types.OCLStandardLibrary;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AcceleoOCLReflection {
    private static Set<String> reservedKeywords;
    private EcoreEnvironment environment;
    private Object invalid;
    private EClassifier oclInvalid;

    public AcceleoOCLReflection(EcoreEnvironment env) {
        this.environment = env;
    }

    public Object getInvalid() {
        if (this.invalid == null) {
            OCLStandardLibrary stdLib = this.environment.getOCLStandardLibrary();
            String methodName = "getOclInvalid";
            if (AcceleoCompatibilityHelper.getCurrentVersion() == OCLVersion.HELIOS) {
                methodName = "getInvalid";
            }
            try {
                Method method = stdLib.getClass().getMethod(methodName, new Class[0]);
                this.invalid = method.invoke((Object)stdLib, new Object[0]);
            }
            catch (NoSuchMethodException e) {
                AcceleoCommonPlugin.log(e, true);
            }
            catch (InvocationTargetException e) {
                AcceleoCommonPlugin.log(e, true);
            }
            catch (IllegalAccessException e) {
                AcceleoCommonPlugin.log(e, true);
            }
        }
        return this.invalid;
    }

    public EClassifier getOCLInvalid() {
        if (this.oclInvalid == null) {
            OCLStandardLibrary stdLib = this.environment.getOCLStandardLibrary();
            String methodName = "getInvalid";
            if (AcceleoCompatibilityHelper.getCurrentVersion() == OCLVersion.HELIOS) {
                methodName = "getOclInvalid";
            }
            try {
                Method method = stdLib.getClass().getMethod(methodName, new Class[0]);
                this.oclInvalid = (EClassifier)method.invoke((Object)stdLib, new Object[0]);
            }
            catch (NoSuchMethodException e) {
                AcceleoCommonPlugin.log(e, true);
            }
            catch (InvocationTargetException e) {
                AcceleoCommonPlugin.log(e, true);
            }
            catch (IllegalAccessException e) {
                AcceleoCommonPlugin.log(e, true);
            }
        }
        return this.oclInvalid;
    }

    public static Set<String> getReservedKeywords() {
        if (reservedKeywords != null) {
            return reservedKeywords;
        }
        reservedKeywords = new CompactHashSet<String>();
        reservedKeywords.add("and");
        reservedKeywords.add("context");
        reservedKeywords.add("def");
        reservedKeywords.add("else");
        reservedKeywords.add("endif");
        reservedKeywords.add("endpackage");
        reservedKeywords.add("if");
        reservedKeywords.add("implies");
        reservedKeywords.add("in");
        reservedKeywords.add("inv");
        reservedKeywords.add("let");
        reservedKeywords.add("not");
        reservedKeywords.add("or");
        reservedKeywords.add("package");
        reservedKeywords.add("post");
        reservedKeywords.add("pre");
        reservedKeywords.add("then");
        reservedKeywords.add("xor");
        if (AcceleoCompatibilityHelper.getCurrentVersion() == OCLVersion.HELIOS) {
            reservedKeywords.add("body");
            reservedKeywords.add("derive");
            reservedKeywords.add("init");
            reservedKeywords.add("static");
            reservedKeywords.add("null");
            reservedKeywords.add("invalid");
        } else {
            reservedKeywords.add("attr");
            reservedKeywords.add("oper");
        }
        return reservedKeywords;
    }
}

