/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.common.internal.utils;

import java.util.LinkedHashSet;
import java.util.Set;
import org.eclipse.acceleo.common.AcceleoCommonMessages;
import org.eclipse.acceleo.common.AcceleoCommonPlugin;
import org.eclipse.acceleo.common.internal.utils.workspace.AcceleoWorkspaceUtil;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.util.URI;
import org.osgi.framework.Bundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class AcceleoServicesEclipseUtil {
    private static final Set<String> REGISTERED_SERVICES = new LinkedHashSet<String>();

    private AcceleoServicesEclipseUtil() {
    }

    public static void clearRegistry() {
        REGISTERED_SERVICES.clear();
    }

    public static Object getServiceInstance(Class<?> serviceClass) {
        return AcceleoWorkspaceUtil.INSTANCE.getServiceInstance(serviceClass);
    }

    public static Class<?> registerService(Bundle bundle, String qualifiedName) {
        Class clazz = null;
        try {
            clazz = bundle.loadClass(qualifiedName);
            if (clazz != null) {
                REGISTERED_SERVICES.add(qualifiedName);
            }
        }
        catch (ClassNotFoundException e) {
            AcceleoCommonPlugin.log(AcceleoCommonMessages.getString("BundleClassLookupFailure", qualifiedName, bundle.getSymbolicName()), e, false);
        }
        return clazz;
    }

    public static Class<?> registerService(IProject project, String qualifiedName) {
        Class<?> clazz = AcceleoWorkspaceUtil.INSTANCE.getClass(project, qualifiedName);
        if (clazz != null) {
            REGISTERED_SERVICES.add(qualifiedName);
        }
        return clazz;
    }

    public static Class<?> registerService(String bundleName, String qualifiedName) {
        Class<?> clazz = null;
        IProject project = AcceleoWorkspaceUtil.getProject(bundleName);
        clazz = project != null ? AcceleoServicesEclipseUtil.registerService(project, qualifiedName) : AcceleoServicesEclipseUtil.registerService(Platform.getBundle((String)bundleName), qualifiedName);
        return clazz;
    }

    public static Class<?> registerService(URI uri, String qualifiedName) {
        Class<?> clazz = null;
        if (uri.isPlatformPlugin()) {
            String bundleName = uri.segment(1);
            Bundle bundle = Platform.getBundle((String)bundleName);
            if (bundle != null) {
                clazz = AcceleoServicesEclipseUtil.registerService(bundle, qualifiedName);
            }
        } else {
            IProject project;
            IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
            String projectName = null;
            if (uri.isPlatformResource()) {
                projectName = uri.segment(1);
            } else {
                URI workspaceRootURI = URI.createURI((String)URI.decode((String)workspaceRoot.getLocationURI().toString()));
                URI workspaceRelative = uri.deresolve(workspaceRootURI);
                if (!workspaceRelative.equals((Object)uri)) {
                    projectName = workspaceRelative.segment(1);
                }
            }
            if (projectName != null && (project = workspaceRoot.getProject(projectName)) != null && project.exists()) {
                clazz = AcceleoServicesEclipseUtil.registerService(project, qualifiedName);
            }
            if (clazz == null) {
                clazz = AcceleoServicesEclipseUtil.workspaceSuffixWorkaround(uri, qualifiedName);
            }
        }
        if (clazz != null) {
            REGISTERED_SERVICES.add(qualifiedName);
        }
        return clazz;
    }

    private static Class<?> workspaceSuffixWorkaround(URI uri, String qualifiedName) {
        String bundleName;
        Bundle bundle;
        Class<?> clazz = null;
        String resolvedURI = AcceleoWorkspaceUtil.resolveAsPlatformPlugin(URI.decode((String)uri.toString()));
        URI platformURI = null;
        if (resolvedURI != null) {
            platformURI = URI.createURI((String)resolvedURI);
        }
        if (platformURI != null && (bundle = Platform.getBundle((String)(bundleName = platformURI.segment(1)))) != null) {
            clazz = AcceleoServicesEclipseUtil.registerService(bundle, qualifiedName);
        }
        return clazz;
    }
}

