/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.internal.ide.ui.editors.template;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.acceleo.internal.ide.ui.editors.template.AcceleoEditor;
import org.eclipse.acceleo.internal.ide.ui.editors.template.actions.references.ReferenceEntry;
import org.eclipse.acceleo.internal.ide.ui.editors.template.actions.references.ReferencesSearchQuery;
import org.eclipse.acceleo.internal.ide.ui.editors.template.actions.references.ReferencesSearchResult;
import org.eclipse.acceleo.internal.ide.ui.editors.template.utils.OpenDeclarationUtils;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ISynchronizable;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.search.ui.text.AbstractTextSearchResult;
import org.eclipse.search.ui.text.Match;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AcceleoOccurrencesFinderJob
extends Job {
    public static final String FIND_OCCURENCES_ANNOTATION_TYPE = "org.eclipse.jdt.ui.occurrences";
    private AcceleoEditor editor;
    private ReferencesSearchQuery query;

    public AcceleoOccurrencesFinderJob(AcceleoEditor editor, String name, ReferencesSearchQuery query) {
        super(name);
        this.editor = editor;
        this.query = query;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IStatus run(IProgressMonitor monitor) {
        IAnnotationModel annotationModel;
        ReferencesSearchResult result = (ReferencesSearchResult)this.query.getSearchResult();
        IStatus status = null;
        int origPriority = Thread.currentThread().getPriority();
        try {
            Thread.currentThread().setPriority(1);
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        try {
            status = this.query.run(monitor);
        }
        finally {
            try {
                Thread.currentThread().setPriority(origPriority);
            }
            catch (SecurityException securityException) {}
        }
        List<Match> matches = this.listOfTheOccurencesInTheCurrentFile(result);
        HashMap<Annotation, Position> annotationMap = new HashMap<Annotation, Position>(matches.size());
        for (Match match : matches) {
            ReferenceEntry ref = null;
            if (!(match.getElement() instanceof ReferenceEntry)) continue;
            ref = (ReferenceEntry)match.getElement();
            if (monitor.isCanceled()) {
                status = Status.CANCEL_STATUS;
            }
            if (this.editor.getDocumentProvider() == null || this.editor.getDocumentProvider().getAnnotationModel((Object)this.editor.getEditorInput()) == null) {
                status = Status.CANCEL_STATUS;
            }
            if (status == Status.CANCEL_STATUS) {
                return status;
            }
            String description = ref.getMatch().toString();
            IRegion region = ref.getRegion();
            Position position = new Position(region.getOffset(), region.getLength());
            annotationMap.put(new Annotation(FIND_OCCURENCES_ANNOTATION_TYPE, false, description), position);
        }
        if (this.editor.getDocumentProvider() != null && this.editor.getEditorInput() != null && (annotationModel = this.editor.getDocumentProvider().getAnnotationModel((Object)this.editor.getEditorInput())) != null) {
            Object object = this.getLockObject(annotationModel);
            synchronized (object) {
                for (Map.Entry entry : annotationMap.entrySet()) {
                    annotationModel.addAnnotation((Annotation)entry.getKey(), (Position)entry.getValue());
                }
            }
        }
        return status;
    }

    private Object getLockObject(IAnnotationModel annotationModel) {
        Object lock;
        if (annotationModel instanceof ISynchronizable && (lock = ((ISynchronizable)annotationModel).getLockObject()) != null) {
            return lock;
        }
        return annotationModel;
    }

    private List<Match> listOfTheOccurencesInTheCurrentFile(AbstractTextSearchResult result) {
        List<Match> list = new ArrayList<Match>();
        Object[] objectArray = result.getElements();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object object = objectArray[n2];
            if (object instanceof ReferenceEntry && ((ReferenceEntry)object).getRegion() != null) {
                ReferenceEntry ref = (ReferenceEntry)object;
                list.add(new Match((Object)ref, ref.getRegion().getOffset(), ref.getRegion().getLength()));
            }
            ++n2;
        }
        IFile file = this.editor.getFile();
        list = OpenDeclarationUtils.getMatchesFromTheFile(list, file);
        return list;
    }
}

