/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml.runtime.project;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.util.URI;
import org.eclipse.m2m.internal.qvt.oml.common.io.CFile;
import org.eclipse.m2m.internal.qvt.oml.common.io.CFolder;
import org.eclipse.m2m.internal.qvt.oml.common.io.eclipse.BundleFile;
import org.eclipse.m2m.internal.qvt.oml.common.io.eclipse.BundleModuleRegistry;
import org.eclipse.m2m.internal.qvt.oml.common.project.TransformationRegistry;
import org.eclipse.m2m.internal.qvt.oml.compiler.IImportResolver;
import org.eclipse.m2m.internal.qvt.oml.runtime.project.QvtTransformationRegistry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeployedImportResolver
implements IImportResolver {
    private static List<BundleModuleRegistry> bundleModules;

    public String getPackageName(CFolder folder) {
        if (folder == null) {
            return "";
        }
        return folder.getFullPath().replace('\\', '/').replace('/', '.');
    }

    public CFile resolveImport(String importedUnitName) {
        if (importedUnitName == null || importedUnitName.length() == 0) {
            return null;
        }
        if (bundleModules == null) {
            bundleModules = DeployedImportResolver.createModulesRegistry();
        }
        Path fullPath = new Path(String.valueOf(importedUnitName.replace('.', '/')) + ".qvto");
        for (BundleModuleRegistry nextRegistry : bundleModules) {
            if (importedUnitName.indexOf(nextRegistry.getBundleSymbolicName()) == 1) {
                fullPath = new Path(importedUnitName.substring(nextRegistry.getBundleSymbolicName().length() + 2));
            } else if (importedUnitName.startsWith("/")) {
                fullPath = new Path(String.valueOf(importedUnitName.substring(1).replace('.', '/')) + ".qvto");
            }
            if (!nextRegistry.fileExists((IPath)fullPath)) continue;
            return new BundleFile((IPath)fullPath, nextRegistry);
        }
        return this.resolveResourcePluginPath(importedUnitName);
    }

    private CFile resolveResourcePluginPath(String importedUnitName) {
        try {
            URI uri = URI.createURI((String)importedUnitName);
            String[] segments = uri.segments();
            if (segments.length > 0 && Platform.getBundle((String)segments[0]) != null && "qvto".equals(uri.fileExtension())) {
                URI pathUri = URI.createURI((String)"");
                int i = 1;
                while (i < segments.length) {
                    pathUri = pathUri.appendSegment(segments[i]);
                    ++i;
                }
                Path ipath = new Path(pathUri.toFileString());
                BundleModuleRegistry newBundle = new BundleModuleRegistry(segments[0], (Collection)Collections.singletonList(ipath));
                bundleModules.add(newBundle);
                return new BundleFile((IPath)ipath, newBundle);
            }
        }
        catch (Exception exception) {}
        return null;
    }

    private static List<BundleModuleRegistry> createModulesRegistry() {
        final HashMap allQvtFilesMap = new HashMap();
        QvtTransformationRegistry.getInstance().getTransformations(new TransformationRegistry.Filter(){

            public boolean accept(IConfigurationElement element) {
                String qvtFilePath;
                String namespaceID = element.getNamespaceIdentifier();
                ArrayList<Path> filesValue = (ArrayList<Path>)allQvtFilesMap.get(namespaceID);
                if (filesValue == null) {
                    filesValue = new ArrayList<Path>();
                    allQvtFilesMap.put(namespaceID, filesValue);
                }
                if ((qvtFilePath = element.getAttribute("file")) != null) {
                    filesValue.add(new Path(qvtFilePath));
                }
                return false;
            }
        });
        ArrayList<BundleModuleRegistry> registryEntries = new ArrayList<BundleModuleRegistry>();
        for (String nextID : allQvtFilesMap.keySet()) {
            List qvtFiles = (List)allQvtFilesMap.get(nextID);
            registryEntries.add(new BundleModuleRegistry(nextID, (Collection)qvtFiles));
        }
        return registryEntries;
    }
}

