/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml.editor.ui.completion;

import java.util.ArrayList;
import lpg.lpgjavaruntime.IToken;
import lpg.lpgjavaruntime.PrsStream;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.m2m.internal.qvt.oml.ast.env.QvtOperationalEnvFactory;
import org.eclipse.m2m.internal.qvt.oml.ast.env.QvtOperationalFileEnv;
import org.eclipse.m2m.internal.qvt.oml.ast.parser.QvtOperationalVisitorCS;
import org.eclipse.m2m.internal.qvt.oml.common.io.CFile;
import org.eclipse.m2m.internal.qvt.oml.compiler.QvtCompilerOptions;
import org.eclipse.m2m.internal.qvt.oml.cst.parser.AbstractQVTParser;
import org.eclipse.m2m.internal.qvt.oml.cst.parser.QvtOpLPGParsersym;
import org.eclipse.m2m.internal.qvt.oml.cst.parser.QvtOpLexer;
import org.eclipse.m2m.internal.qvt.oml.editor.ui.Activator;
import org.eclipse.m2m.internal.qvt.oml.editor.ui.completion.QvtCompletionData;
import org.eclipse.m2m.internal.qvt.oml.editor.ui.completion.cst.parser.LightweightParser;
import org.eclipse.m2m.internal.qvt.oml.editor.ui.completion.cst.parser.LightweightTypeParser;
import org.eclipse.ocl.Environment;
import org.eclipse.ocl.OCLInput;
import org.eclipse.ocl.ParserException;
import org.eclipse.ocl.cst.CSTNode;
import org.eclipse.ocl.cst.OCLExpressionCS;
import org.eclipse.ocl.expressions.OCLExpression;
import org.eclipse.ocl.lpg.BasicEnvironment;
import org.eclipse.ocl.parser.OCLLexer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LightweightParserUtil {
    public static final int[] IMPERATIVE_OPERATION_TOKENS = new int[]{104, 106, 105, 90};
    public static final int[] OCLEXPRESSION_START_TOKENS = new int[]{102, 132, 19, 25, 113, 21, 22, 23, 24, 47, 48, 49, 142, 54, 51, 52, 27, 28, 91, 123, 87, 84, 138, 70, 141, 133, 86, 108, 1, 92, 116, 99};
    public static final int[] OCLEXPRESSION_END_TOKENS = new int[]{91, 123, 87, 84, 138, 141, 133, 134, 85, 121, 4, 92};
    public static final int[] OCLEXPRESSION_MANDATORY_TERMINATION_TOKENS = LightweightParserUtil.uniteIntArrays(IMPERATIVE_OPERATION_TOKENS, new int[]{26, 126, 127, 117, 146, 115, 128, 114});
    public static final int[][] BRACING_PAIRS = new int[][]{{70, 134}, {1, 4}, {86, 85}, {108, 121}};
    public static final int[] RESOLVE_FAMILY_TERMINALS = new int[]{76, 77, 78, 79, 80, 81, 82, 83};
    public static final int[] RESOLVEIN_FAMILY_TERMINALS = new int[]{78, 79, 82, 83};
    public static final int[] ITERATOR_TERMINALS_WITH_IMPLICIT_ITERATOR = new int[]{39, 40, 38, 33, 34, 35, 37, 36, 41, 42, 43, 149, 150, 151, 152};
    public static final int[] ITERATOR_TERMINALS = LightweightParserUtil.uniteIntArrays(ITERATOR_TERMINALS_WITH_IMPLICIT_ITERATOR, new int[]{153, 154});
    public static final int[] MAPPING_CLAUSE_TOKENS = new int[]{116, 147};

    public static int[] uniteIntArrays(int[] array1, int[] array2) {
        int[] result = new int[array1.length + array2.length];
        System.arraycopy(array1, 0, result, 0, array1.length);
        System.arraycopy(array2, 0, result, array1.length, array2.length);
        return result;
    }

    public static final IToken getNextToken(IToken token) {
        PrsStream prsStream = token.getPrsStream();
        int nextTokenIndex = token.getTokenIndex() + 1;
        if (nextTokenIndex < prsStream.getSize()) {
            return prsStream.getTokenAt(nextTokenIndex);
        }
        return null;
    }

    public static final IToken getPreviousToken(IToken token) {
        PrsStream prsStream = token.getPrsStream();
        int nextTokenIndex = token.getTokenIndex() - 1;
        if (nextTokenIndex >= 0) {
            return prsStream.getTokenAt(nextTokenIndex);
        }
        return null;
    }

    public static final IToken getNextTokenByKind(IToken startToken, int kind) {
        return LightweightParserUtil.getNextTokenByKind(startToken, new int[]{kind});
    }

    public static final IToken getNextTokenByKind(IToken startToken, int[] kinds) {
        PrsStream prsStream = startToken.getPrsStream();
        int i = startToken.getTokenIndex();
        int n = prsStream.getSize();
        while (i < n) {
            IToken token = prsStream.getTokenAt(i);
            if (QvtCompletionData.isKindOf(token, kinds)) {
                return token;
            }
            ++i;
        }
        return null;
    }

    public static final IToken getPreviousTokenByKind(IToken startToken, int kind) {
        return LightweightParserUtil.getPreviousTokenByKind(startToken, new int[]{kind});
    }

    public static final IToken getPreviousTokenByKind(IToken startToken, int[] kinds) {
        IToken currentToken = startToken;
        while ((currentToken = LightweightParserUtil.getPreviousToken(currentToken)) != null) {
            if (!QvtCompletionData.isKindOf(currentToken, kinds)) continue;
            return currentToken;
        }
        return null;
    }

    public static final String getTokenText(int tokenKind) {
        return QvtOpLPGParsersym.orderedTerminalSymbols[tokenKind];
    }

    public static final OCLExpression<EClassifier> getOclExpression(IToken trailingToken, QvtCompletionData data, ParserTypeEnum parserType) {
        OCLExpressionCS oclExpressionCS = LightweightParserUtil.getOclExpressionCS(trailingToken, data, parserType);
        return LightweightParserUtil.getOclExpression(oclExpressionCS, data);
    }

    public static final OCLExpression<EClassifier> getOclExpression(IToken[] tokens, QvtCompletionData data, ParserTypeEnum parserType) {
        OCLExpressionCS oclExpressionCS = LightweightParserUtil.getOclExpressionCS(tokens, data, parserType);
        if (oclExpressionCS != null) {
            return LightweightParserUtil.getOclExpression(oclExpressionCS, data);
        }
        return null;
    }

    public static final OCLExpression<EClassifier> getOclExpression(OCLExpressionCS oclExpressionCS, QvtCompletionData data) {
        if (oclExpressionCS != null) {
            OCLLexer oclLexer = new OCLLexer((Environment)data.getEnvironment());
            try {
                oclLexer.initialize(new OCLInput("").getContent(), data.getCFile().getName());
                QvtCompilerOptions options = new QvtCompilerOptions();
                options.setReportErrors(false);
                options.setShowAnnotations(false);
                options.setSourceLineNumbersEnabled(false);
                QvtOperationalVisitorCS visitor = new QvtOperationalVisitorCS(oclLexer, (Environment)data.getEnvironment(), options);
                return visitor.analyzeExpressionCS(oclExpressionCS, data.getEnvironment());
            }
            catch (ParserException e) {
                Activator.log(e);
            }
        }
        return null;
    }

    public static final OCLExpressionCS getOclExpressionCS(IToken[] tokens, QvtCompletionData data, ParserTypeEnum parserType) {
        CSTNode cstNode;
        if (tokens != null && (cstNode = LightweightParserUtil.parse(tokens, (CFile)data.getCFile(), parserType)) instanceof OCLExpressionCS) {
            return (OCLExpressionCS)cstNode;
        }
        return null;
    }

    public static final String getText(IToken start, IToken end) {
        int startOffset = start.getStartOffset();
        int endOffset = end.getEndOffset();
        PrsStream prsStream = start.getPrsStream();
        return LightweightParserUtil.getText(startOffset, endOffset, prsStream);
    }

    public static final String getText(CSTNode cstNode, PrsStream prsStream) {
        int startOffset = cstNode.getStartOffset();
        int endOffset = cstNode.getEndOffset();
        return LightweightParserUtil.getText(startOffset, endOffset, prsStream);
    }

    private static String getText(int startOffset, int endOffset, PrsStream prsStream) {
        return new String(prsStream.getInputChars(), startOffset, endOffset - startOffset + 1);
    }

    public static final String getText(IToken[] tokens) {
        if (tokens.length == 0) {
            return "";
        }
        return LightweightParserUtil.getText(tokens[0], tokens[tokens.length - 1]);
    }

    public static final CSTNode parse(IToken[] tokens, CFile cFile, ParserTypeEnum parserType) {
        String script = LightweightParserUtil.getText(tokens);
        return LightweightParserUtil.parse(script, cFile, parserType);
    }

    public static final CSTNode parse(String script, CFile cFile, ParserTypeEnum parserType) {
        try {
            QvtOperationalFileEnv env = new QvtOperationalEnvFactory().createEnvironment(null, null, null);
            QvtOpLexer lexer = new QvtOpLexer((BasicEnvironment)env);
            lexer.initialize(new OCLInput(script).getContent(), cFile.getName());
            AbstractQVTParser parser = null;
            switch (parserType) {
                case LIGHTWEIGHT_PARSER: {
                    parser = new RunnableLightweightParser(lexer);
                    break;
                }
                case LIGHTWEIGHT_TYPE_PARSER: {
                    parser = new RunnableLightweightTypeParser(lexer);
                    break;
                }
                default: {
                    throw new RuntimeException("Unknown parserType: " + (Object)((Object)parserType));
                }
            }
            parser.resetTokenStream();
            lexer.lexer((PrsStream)parser);
            return (CSTNode)((ILightweightParser)parser).runParser();
        }
        catch (Exception ex) {
            Activator.log(ex);
            return null;
        }
    }

    private static final OCLExpressionCS getOclExpressionCS(IToken trailingToken, QvtCompletionData data, ParserTypeEnum parserType) {
        IToken[] tokens = LightweightParserUtil.extractOclExpressionCSTokens(trailingToken, data);
        return LightweightParserUtil.getOclExpressionCS(tokens, data, parserType);
    }

    public static final IToken[] extractOclExpressionCSTokens(IToken trailingToken, QvtCompletionData data) {
        ArrayList<IToken> tokens = new ArrayList<IToken>();
        PrsStream prsStream = data.getPrsStream();
        int mode = BRACING_PAIRS.length;
        int depth = 0;
        int i = trailingToken.getTokenIndex() - 1;
        while (i >= 0) {
            IToken token = prsStream.getTokenAt(i);
            if (QvtCompletionData.isKindOf(token, OCLEXPRESSION_MANDATORY_TERMINATION_TOKENS)) {
                return null;
            }
            if (depth == 0) {
                if (QvtCompletionData.isKindOf(token, OCLEXPRESSION_START_TOKENS) || QvtCompletionData.isKindOf(token, 4)) {
                    return tokens.toArray(new IToken[tokens.size()]);
                }
                int j = 0;
                while (j < BRACING_PAIRS.length) {
                    if (token.getKind() == BRACING_PAIRS[j][1]) {
                        mode = j;
                        ++depth;
                        break;
                    }
                    ++j;
                }
            } else if (token.getKind() == BRACING_PAIRS[mode][0]) {
                --depth;
            } else if (token.getKind() == BRACING_PAIRS[mode][1]) {
                ++depth;
            }
            tokens.add(0, token);
            --i;
        }
        return null;
    }

    public static final int getBracingPairKind(IToken token, boolean isStart) {
        int i = 0;
        while (i < BRACING_PAIRS.length) {
            int kind;
            int n = kind = isStart ? BRACING_PAIRS[i][0] : BRACING_PAIRS[i][1];
            if (QvtCompletionData.isKindOf(token, kind)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private static interface ILightweightParser {
        public EObject runParser() throws ParserException;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ParserTypeEnum {
        LIGHTWEIGHT_PARSER,
        LIGHTWEIGHT_TYPE_PARSER;

    }

    private static class RunnableLightweightParser
    extends LightweightParser
    implements ILightweightParser {
        public RunnableLightweightParser(QvtOpLexer lexStream) {
            super(lexStream);
        }

        public CSTNode runParser() throws ParserException {
            return this.parser(10);
        }
    }

    private static class RunnableLightweightTypeParser
    extends LightweightTypeParser
    implements ILightweightParser {
        public RunnableLightweightTypeParser(QvtOpLexer lexStream) {
            super(lexStream);
        }

        public CSTNode runParser() throws ParserException {
            return this.parser(10);
        }
    }
}

