/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml.common.ui.launch;

import org.eclipse.core.resources.IFile;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.m2m.internal.qvt.oml.common.launch.TargetUriData;
import org.eclipse.m2m.internal.qvt.oml.common.ui.IModelParameterInfo;
import org.eclipse.m2m.internal.qvt.oml.common.ui.launch.BaseUriGroup;
import org.eclipse.m2m.internal.qvt.oml.common.ui.launch.Messages;
import org.eclipse.m2m.internal.qvt.oml.common.ui.launch.ReferenceSelectionDialog;
import org.eclipse.m2m.internal.qvt.oml.common.ui.launch.TransformationControls;
import org.eclipse.m2m.internal.qvt.oml.common.ui.launch.UriChooserListener;
import org.eclipse.m2m.internal.qvt.oml.emf.util.EmfUtil;
import org.eclipse.m2m.internal.qvt.oml.emf.util.WorkspaceUtils;
import org.eclipse.m2m.internal.qvt.oml.emf.util.ui.choosers.IChooser;
import org.eclipse.m2m.internal.qvt.oml.emf.util.ui.choosers.IDestinationChooser;
import org.eclipse.m2m.internal.qvt.oml.emf.util.ui.choosers.IMetamodelHandler;
import org.eclipse.m2m.internal.qvt.oml.emf.util.ui.choosers.MetamodelHandlerManager;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class UriGroupOut
extends BaseUriGroup {
    private TargetUriData myData;
    private boolean myUpdating;
    private EObject myObject;
    private final ResourceSet myValidationRS;
    private final Text myUriText;
    private final Button myUriButton;
    private SelectionListener myActiveListener;
    private final Text myFeatureText;
    private final Button myFeatureButton;
    private final Button myClearContentsCheckbox;
    private final ModifyListener MODIFY_LISTENER = new ModifyListener(){

        public void modifyText(ModifyEvent e) {
            UriGroupOut.this.updateData();
        }
    };
    private ReferenceSelectionDialog.IRefFilter refFilter = ReferenceSelectionDialog.IRefFilter.DEFAULT;

    public UriGroupOut(Composite parent, String name, ResourceSet validationRS) {
        super(parent, 0);
        this.myValidationRS = validationRS;
        this.myData = new TargetUriData("");
        this.myUpdating = false;
        this.setLayout((Layout)new GridLayout(3, false));
        this.createLabel(name, 1);
        this.myUriText = TransformationControls.createText(this, 1);
        this.myUriText.addModifyListener(this.MODIFY_LISTENER);
        this.myUriButton = TransformationControls.createButton(this, Messages.TargetUriSelector_Browse);
        this.myUriButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (UriGroupOut.this.myActiveListener != null) {
                    UriGroupOut.this.myActiveListener.widgetSelected(e);
                }
            }
        });
        this.createLabel(Messages.TargetUriSelector_Feature, 1);
        this.myFeatureText = TransformationControls.createText(this, 1);
        this.myFeatureText.addModifyListener(this.MODIFY_LISTENER);
        this.myFeatureButton = TransformationControls.createButton(this, Messages.TargetUriSelector_Select);
        this.myFeatureButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (UriGroupOut.this.myObject == null) {
                    throw new RuntimeException("No object");
                }
                EStructuralFeature feature = UriGroupOut.this.myObject.eClass().getEStructuralFeature(UriGroupOut.this.myData.getFeature());
                EReference initRef = feature instanceof EReference ? (EReference)feature : null;
                ReferenceSelectionDialog dialog = new ReferenceSelectionDialog(UriGroupOut.this.myObject.eClass(), initRef, UriGroupOut.this.getShell(), UriGroupOut.this.refFilter);
                if (dialog.open() == 0) {
                    EReference ref = dialog.getReference();
                    UriGroupOut.this.myFeatureText.setText(ref.getName());
                }
            }
        });
        this.createLabel("", 1);
        this.myClearContentsCheckbox = new Button((Composite)this, 32);
        this.myClearContentsCheckbox.setText(Messages.TargetUriSelector_ClearContents);
        this.myClearContentsCheckbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                UriGroupOut.this.updateData();
            }
        });
        GridData gridData = new GridData();
        gridData.horizontalSpan = 1;
        this.myClearContentsCheckbox.setLayoutData((Object)gridData);
        this.initializeFrom(this.myData);
    }

    public void initializeFrom(TargetUriData targetData) {
        this.myUpdating = true;
        try {
            this.myUriText.setText(targetData.getUriString() == null ? "" : targetData.getUriString());
            this.myFeatureText.setText(targetData.getFeature() == null ? "" : targetData.getFeature());
            this.myClearContentsCheckbox.setSelection(targetData.isClearContents());
        }
        finally {
            this.myUpdating = false;
        }
        this.updateData();
    }

    public TargetUriData getUriData() {
        return new TargetUriData(this.myData.getFeature().trim().length() == 0 ? TargetUriData.TargetType.NEW_MODEL : this.myData.getTargetType(), this.myData.getUriString(), this.myData.getFeature(), this.myData.isClearContents());
    }

    public String getText() {
        return this.myUriText.getText();
    }

    public void update(String uri, String baseName, String extension, Shell shell) {
        if (uri == null) {
            this.myUriText.setEnabled(false);
            this.myUriButton.setEnabled(false);
            this.myActiveListener = null;
        } else {
            IMetamodelHandler handler = MetamodelHandlerManager.getInstance().getHandler(uri);
            if (handler == null) {
                throw new RuntimeException("No handler for URI " + uri);
            }
            IDestinationChooser chooser = handler.getSourceDestChooser(this.myValidationRS);
            chooser.initNewName(baseName, extension);
            this.myActiveListener = new UriChooserListener(this.myUriText, (IChooser)chooser, shell);
            this.myUriText.setEnabled(true);
            this.myUriButton.setEnabled(true);
        }
    }

    private void updateData() {
        if (this.myUpdating) {
            return;
        }
        try {
            TargetUriData oldData = new TargetUriData(this.myData);
            EObject oldObject = this.myObject;
            this.myObject = null;
            URI destUri = EmfUtil.makeUri((String)this.getText());
            IFile file = destUri != null ? WorkspaceUtils.getWorkspaceFile((URI)destUri) : null;
            TargetUriData.TargetType targetType = file != null && file.exists() ? TargetUriData.TargetType.EXISTING_CONTAINER : TargetUriData.TargetType.NEW_MODEL;
            this.myData = new TargetUriData(targetType, this.myUriText.getText().trim(), this.myFeatureText.getText(), this.myClearContentsCheckbox.getSelection());
            switch (this.myData.getTargetType()) {
                case NEW_MODEL: {
                    this.myFeatureText.setEnabled(false);
                    this.myFeatureButton.setEnabled(false);
                    this.myClearContentsCheckbox.setEnabled(false);
                    this.myUriText.setEnabled(true);
                    this.myUriButton.setEnabled(true);
                    break;
                }
                case EXISTING_CONTAINER: {
                    try {
                        this.myObject = this.getEObject(oldData.getUriString(), oldObject);
                    }
                    catch (Throwable throwable) {
                        this.myFeatureText.setEnabled(this.myObject != null);
                        this.myFeatureButton.setEnabled(this.myObject != null);
                        if (this.myObject != null) {
                            EStructuralFeature feature = this.myObject.eClass().getEStructuralFeature(this.myFeatureText.getText());
                            this.myClearContentsCheckbox.setEnabled(feature instanceof EReference);
                        } else {
                            this.myClearContentsCheckbox.setEnabled(false);
                        }
                        throw throwable;
                    }
                    this.myFeatureText.setEnabled(this.myObject != null);
                    this.myFeatureButton.setEnabled(this.myObject != null);
                    if (this.myObject != null) {
                        EStructuralFeature feature = this.myObject.eClass().getEStructuralFeature(this.myFeatureText.getText());
                        this.myClearContentsCheckbox.setEnabled(feature instanceof EReference);
                        break;
                    }
                    this.myClearContentsCheckbox.setEnabled(false);
                }
            }
        }
        finally {
            this.fireModified();
        }
    }

    private EObject getEObject(String oldUri, EObject oldObject) {
        EObject obj;
        boolean sameUri;
        boolean bl = oldUri == null ? this.myData.getUriString() == null : (sameUri = oldUri.equals(this.myData.getUriString()));
        if (sameUri && oldObject != null) {
            obj = oldObject;
        } else {
            URI uri = null;
            try {
                uri = URI.createURI((String)this.myData.getUriString());
            }
            catch (IllegalArgumentException illegalArgumentException) {}
            if (uri == null) {
                return null;
            }
            try {
                obj = EmfUtil.loadModel((URI)uri, (ResourceSet)this.myValidationRS);
            }
            catch (Exception exception) {
                obj = null;
            }
        }
        return obj;
    }

    public void update(String moduleName, IModelParameterInfo paramInfo, Shell shell) {
        EClassifier classifier = paramInfo.getEntryParamType();
        if (classifier == null) {
            classifier = paramInfo.getMetamodel().eClass();
        }
        String extension = paramInfo.getMetamodel().getName();
        this.update(EmfUtil.getRootPackageUri((EClassifier)classifier), moduleName, extension, shell);
        this.refFilter = new ReferenceSelectionDialog.IRefFilter(){

            public boolean accept(EReference ref) {
                return ref.isChangeable();
            }
        };
    }
}

