/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.atl.core.ui.vm.debug;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import org.eclipse.m2m.atl.common.ATLLogger;
import org.eclipse.m2m.atl.core.ui.vm.debug.NetworkDebugger;
import org.eclipse.m2m.atl.debug.core.adwp.BooleanValue;
import org.eclipse.m2m.atl.debug.core.adwp.IntegerValue;
import org.eclipse.m2m.atl.debug.core.adwp.NullValue;
import org.eclipse.m2m.atl.debug.core.adwp.ObjectReference;
import org.eclipse.m2m.atl.debug.core.adwp.RealValue;
import org.eclipse.m2m.atl.debug.core.adwp.StringValue;
import org.eclipse.m2m.atl.debug.core.adwp.Value;
import org.eclipse.m2m.atl.engine.vm.ExecEnv;
import org.eclipse.m2m.atl.engine.vm.Operation;
import org.eclipse.m2m.atl.engine.vm.StackFrame;
import org.eclipse.m2m.atl.engine.vm.nativelib.ASMBoolean;
import org.eclipse.m2m.atl.engine.vm.nativelib.ASMInteger;
import org.eclipse.m2m.atl.engine.vm.nativelib.ASMOclAny;
import org.eclipse.m2m.atl.engine.vm.nativelib.ASMReal;
import org.eclipse.m2m.atl.engine.vm.nativelib.ASMString;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LocalObjectReference
extends ObjectReference {
    private static Map<List<Object>, ObjectReference> values = new HashMap<List<Object>, ObjectReference>();
    private static Map<Integer, ObjectReference> valuesById = new HashMap<Integer, ObjectReference>();
    private static int idGenerator;
    protected Object object;
    protected NetworkDebugger debugger;

    protected LocalObjectReference(Object object, int id, NetworkDebugger debugger) {
        super(id);
        this.object = object;
        this.debugger = debugger;
    }

    public Object getObject() {
        return this.object;
    }

    public String toString() {
        return this.object.toString();
    }

    public static ObjectReference valueOf(int objectId) {
        Integer id = objectId;
        ObjectReference ret = valuesById.get(id);
        return ret;
    }

    public static ObjectReference valueOf(Object object, NetworkDebugger debugger) {
        ArrayList<Object> key = new ArrayList<Object>();
        key.add(object);
        key.add(debugger);
        ObjectReference ret = values.get(key);
        if (ret == null) {
            int id = idGenerator++;
            ret = new LocalObjectReference(object, id, debugger);
            values.put(key, ret);
            valuesById.put(id, ret);
        }
        return ret;
    }

    public Value get(String propName) {
        Value ret = null;
        ASMOclAny o = null;
        try {
            o = ((ASMOclAny)this.object).get(this.debugger.getExecEnv().peek(), propName);
        }
        catch (Exception e) {
            ATLLogger.log((Level)Level.SEVERE, (String)e.getLocalizedMessage(), (Throwable)e);
        }
        ret = this.asm2value(o);
        return ret;
    }

    public void set(String propName, Value value) {
        ASMOclAny realValue = this.value2asm(value);
        ((ASMOclAny)this.object).set(null, propName, realValue);
    }

    public Value call(String opName, List<Value> args) {
        Value ret = null;
        Operation op = this.debugger.getExecEnv().getOperation(((ASMOclAny)this.object).getType(), opName);
        if (op == null) {
            ATLLogger.severe((String)("Operation not found: " + opName + " on " + this.object + " : " + ((ASMOclAny)this.object).getType()));
        } else {
            ArrayList<ASMOclAny> realArgs = new ArrayList<ASMOclAny>();
            realArgs.add(this.value2asm((Value)this));
            for (Value v : args) {
                realArgs.add(this.value2asm(v));
            }
            ASMOclAny o = op.exec(new ADWPStackFrame(op, realArgs).enterFrame(op, realArgs));
            ret = this.asm2value(o);
        }
        return ret;
    }

    private ASMOclAny value2asm(Value value) {
        ASMOclAny ret = null;
        if (value instanceof LocalObjectReference) {
            ret = (ASMOclAny)((LocalObjectReference)value).object;
        } else if (value instanceof StringValue) {
            ret = new ASMString(((StringValue)value).getValue());
        } else if (value instanceof IntegerValue) {
            ret = new ASMInteger(((IntegerValue)value).getValue());
        } else if (value instanceof RealValue) {
            ret = new ASMReal(((RealValue)value).getValue());
        } else if (value instanceof BooleanValue) {
            ret = new ASMBoolean(((BooleanValue)value).getValue());
        }
        return ret;
    }

    private Value asm2value(ASMOclAny o) {
        return LocalObjectReference.asm2value(o, this.debugger);
    }

    public static Value asm2value(ASMOclAny o, NetworkDebugger debugger) {
        Object ret = null;
        ret = o instanceof ASMString ? StringValue.valueOf((String)((ASMString)o).getSymbol()) : (o instanceof ASMInteger ? IntegerValue.valueOf((int)((ASMInteger)o).getSymbol()) : (o instanceof ASMReal ? RealValue.valueOf((double)((ASMReal)o).getSymbol()) : (o instanceof ASMBoolean ? BooleanValue.valueOf((boolean)((ASMBoolean)o).getSymbol()) : (o == null ? new NullValue() : LocalObjectReference.valueOf(o, debugger)))));
        return ret;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class ADWPStackFrame
    extends StackFrame {
        public ADWPStackFrame(Operation op, List<ASMOclAny> args) {
            super(myType, new ExecEnv(null), op, args);
        }

        public void printStackTrace(String msg, Exception e) {
            ATLLogger.severe((String)msg);
        }
    }
}

