/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml.project.nature;

import java.util.Arrays;
import java.util.LinkedHashSet;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.m2m.internal.qvt.oml.project.QVTOProjectPlugin;
import org.eclipse.m2m.internal.qvt.oml.project.builder.QVTOBuilderConfig;
import org.eclipse.m2m.internal.qvt.oml.project.nature.BaseNature;
import org.eclipse.m2m.internal.qvt.oml.project.nature.NatureUtils;

public class QVTONature
extends BaseNature {
    public static final String DEFAULT_SOURCE_FOLDER_PATH = "transformations";
    private static final String LEGACY_BUILDER_ID = "org.eclipse.m2m.qvt.oml.QvtBuilder";

    public void configure() throws CoreException {
        IProject project = this.getProject();
        if (project != null) {
            IProjectDescription description = project.getDescription();
            boolean isMigrated = this.migrate(description);
            if (!isMigrated) {
                this.addQVTBuilder(description);
            }
            project.setDescription(description, null);
            if (!isMigrated) {
                this.setupDefaultSourceContainer();
            }
        }
    }

    private void addQVTBuilder(IProjectDescription projectDesc) {
        NatureUtils.addBuilders(projectDesc, new String[]{"org.eclipse.m2m.qvt.oml.project.QVTOBuilder"}, new String[0]);
    }

    private void setupDefaultSourceContainer() {
        assert (this.getProject() != null);
        IContainer container = null;
        IProject project = this.getProject();
        if (project != null) {
            try {
                QVTOBuilderConfig config = QVTOBuilderConfig.getConfig(this.getProject());
                container = config.getRawSourceContainer();
                if (container == null) {
                    IFolder folder = this.getProject().getFolder((IPath)new Path(DEFAULT_SOURCE_FOLDER_PATH));
                    container = folder;
                    if (!folder.exists()) {
                        folder.create(true, true, null);
                    }
                    config.setSourceContainer(container);
                }
            }
            catch (CoreException e) {
                QVTOProjectPlugin.log(e.getStatus());
            }
        }
    }

    private boolean migrate(IProjectDescription description) throws CoreException {
        ICommand[] commands;
        boolean migrated = false;
        ICommand[] iCommandArray = commands = description.getBuildSpec();
        int n = commands.length;
        int n2 = 0;
        while (n2 < n) {
            ICommand nextCommand = iCommandArray[n2];
            if (LEGACY_BUILDER_ID.equals(nextCommand.getBuilderName())) {
                nextCommand.setBuilderName("org.eclipse.m2m.qvt.oml.project.QVTOBuilder");
                description.setBuildSpec(commands);
                migrated = true;
                break;
            }
            ++n2;
        }
        LinkedHashSet<String> natures = new LinkedHashSet<String>(Arrays.asList(description.getNatureIds()));
        natures.remove("org.eclipse.m2m.qvt.oml.project.TransformationNature");
        description.setNatureIds(natures.toArray(new String[natures.size()]));
        return migrated;
    }
}

