/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.atl.adt.ui.text.atl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.m2m.atl.adt.ui.AtlUIPlugin;
import org.eclipse.m2m.atl.adt.ui.editor.AtlEditor;
import org.eclipse.m2m.atl.adt.ui.text.atl.AtlCompletionProposal;
import org.eclipse.swt.graphics.Image;

public class AtlCompletionDataSource {
    private static Map path2image = new HashMap();
    private AtlEditor fEditor;

    public AtlCompletionDataSource(AtlEditor editor) {
        this.fEditor = editor;
    }

    public List getURIProposals(String prefix, int offset) {
        return AtlCompletionDataSource.getProposalsFromList(offset, prefix, EPackage.Registry.INSTANCE.keySet().toArray());
    }

    public List getPathProposals(String prefix, int offset) {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IWorkspaceRoot root = workspace.getRoot();
        IProject[] projects = root.getProjects();
        ArrayList allFiles = new ArrayList();
        try {
            AtlCompletionDataSource.getWorkspaceEcoreFileNames((IResource[])projects, allFiles);
        }
        catch (CoreException coreException) {}
        return AtlCompletionDataSource.getProposalsFromList(offset, prefix, allFiles.toArray());
    }

    private static void getWorkspaceEcoreFileNames(IResource[] resources, List fileNames) throws CoreException {
        int i = 0;
        while (i < resources.length) {
            IResource resource = resources[i];
            if (resource.isAccessible()) {
                if (resource instanceof IFile) {
                    if ("ecore".equals(resource.getFileExtension())) {
                        fileNames.add(resource.getFullPath());
                    }
                } else if (resource instanceof IProject) {
                    AtlCompletionDataSource.getWorkspaceEcoreFileNames(((IProject)resource).members(), fileNames);
                } else if (resource instanceof IFolder) {
                    AtlCompletionDataSource.getWorkspaceEcoreFileNames(((IFolder)resource).members(), fileNames);
                }
            }
            ++i;
        }
    }

    public List getMetaElementsProposals(String prefix, int offset, int filter) {
        ArrayList res = new ArrayList();
        Set entries = this.fEditor.getSourceManager().getMetamodelPackages(filter).entrySet();
        for (Map.Entry entry : entries) {
            String metamodelName = entry.getKey().toString();
            List packages = (List)entry.getValue();
            if (packages == null) continue;
            for (EPackage metamodel : packages) {
                res.addAll(this.getMetaElementsProposals(metamodelName, metamodel, prefix, offset));
            }
        }
        return res;
    }

    public Collection getMetamodelsProposals(String prefix, int offset) {
        HashSet res = new HashSet();
        res.addAll(this.fEditor.getSourceManager().getInputModels().values());
        res.addAll(this.fEditor.getSourceManager().getOutputModels().values());
        return AtlCompletionDataSource.getProposalsFromList(offset, prefix, res.toArray());
    }

    private List getMetaElementsProposals(String metamodelName, EPackage metamodel, String prefix, int offset) {
        ArrayList<AtlCompletionProposal> res = new ArrayList<AtlCompletionProposal>();
        TreeSet classifiers = new TreeSet(new Comparator(){

            public int compare(Object arg0, Object arg1) {
                EClassifier c0 = (EClassifier)arg0;
                EClassifier c1 = (EClassifier)arg1;
                return AtlCompletionDataSource.getEClassifierShortPath(c0, false).compareTo(AtlCompletionDataSource.getEClassifierShortPath(c1, false));
            }
        });
        classifiers.addAll(AtlCompletionDataSource.computeAllClassifiersList(metamodel));
        for (EClassifier classifier : classifiers) {
            String replacementString = String.valueOf(metamodelName) + "!" + AtlCompletionDataSource.getEClassifierShortPath(classifier, false);
            if (!AtlCompletionDataSource.startsWithIgnoreCase(prefix, replacementString) || prefix.equals(replacementString)) continue;
            Image image = AtlCompletionDataSource.getImage("model_class.gif");
            StringBuffer additionalProposalInfo = new StringBuffer();
            if (classifier instanceof EClass) {
                EClass cl = (EClass)classifier;
                if (cl.isAbstract()) {
                    additionalProposalInfo.append("abstract ");
                }
                additionalProposalInfo.append("class ");
                additionalProposalInfo.append(cl.getName());
                boolean first = true;
                for (EClass st : cl.getESuperTypes()) {
                    if (first) {
                        additionalProposalInfo.append(" extends\n\t");
                        first = false;
                    } else {
                        additionalProposalInfo.append(",\n\t");
                    }
                    additionalProposalInfo.append(st.getName());
                }
            }
            AtlCompletionProposal proposal = new AtlCompletionProposal(replacementString, offset - prefix.length(), replacementString.length(), image, replacementString, 0, additionalProposalInfo.toString());
            res.add(proposal);
        }
        Collections.sort(res);
        return res;
    }

    private static List computeAllClassifiersList(EPackage ePackage) {
        BasicEList classifiers = new BasicEList();
        if (ePackage != null) {
            AtlCompletionDataSource.computeAllClassifiersList(ePackage, (List)classifiers);
        }
        return classifiers;
    }

    private static void computeAllClassifiersList(EPackage ePackage, List all) {
        for (EClassifier classifier : ePackage.getEClassifiers()) {
            if (!(classifier instanceof EClass) || ((EClass)classifier).isInterface()) continue;
            all.add(classifier);
        }
        Iterator packages = ePackage.getESubpackages().iterator();
        while (packages.hasNext()) {
            AtlCompletionDataSource.computeAllClassifiersList((EPackage)packages.next(), all);
        }
    }

    public List getMetaFeaturesProposals(List existing, EObject atlType, String prefix, int offset) {
        EClassifier res;
        if (atlType != null && (res = this.getEClassifierFromAtlType(atlType)) instanceof EClass) {
            return this.getMetaFeaturesProposals(existing, (EClass)res, prefix, offset);
        }
        return new ArrayList();
    }

    private List getMetaFeaturesProposals(List existing, EClass type, String prefix, int offset) {
        ArrayList<AtlCompletionProposal> res = new ArrayList<AtlCompletionProposal>();
        TreeSet features = new TreeSet(new Comparator(){

            public int compare(Object arg0, Object arg1) {
                EStructuralFeature f0 = (EStructuralFeature)arg0;
                EStructuralFeature f1 = (EStructuralFeature)arg1;
                return f0.getName().compareTo(f1.getName());
            }
        });
        features.addAll(type.getEAllStructuralFeatures());
        for (EStructuralFeature feature : features) {
            EReference opposite;
            String replacementString = feature.getName();
            if (existing.contains(replacementString) || !AtlCompletionDataSource.startsWithIgnoreCase(prefix, replacementString) || prefix.equals(replacementString)) continue;
            Image image = null;
            if (!feature.isChangeable()) continue;
            if (feature instanceof EAttribute) {
                image = AtlCompletionDataSource.getImage("model_attribute.gif");
            } else if (feature instanceof EReference) {
                image = AtlCompletionDataSource.getImage("model_reference.gif");
            }
            StringBuffer additionalProposalInfo = new StringBuffer();
            if (feature instanceof EAttribute) {
                additionalProposalInfo.append("attribute ");
            } else if (feature instanceof EReference) {
                additionalProposalInfo.append("reference ");
            }
            additionalProposalInfo.append(feature.getName());
            if (feature.getLowerBound() != 1 || feature.getUpperBound() != 1) {
                additionalProposalInfo.append('[');
                if (feature.getLowerBound() == 0 && feature.getUpperBound() == -1) {
                    additionalProposalInfo.append('*');
                } else {
                    additionalProposalInfo.append(feature.getLowerBound());
                    additionalProposalInfo.append('-');
                    additionalProposalInfo.append(feature.getUpperBound());
                }
                additionalProposalInfo.append(']');
            }
            if (feature.isOrdered()) {
                additionalProposalInfo.append(" ordered");
            }
            if (feature instanceof EReference && ((EReference)feature).isContainment()) {
                additionalProposalInfo.append(" container");
            }
            additionalProposalInfo.append(" :\n\t");
            additionalProposalInfo.append(feature.getEType().getName());
            if (feature instanceof EReference && (opposite = ((EReference)feature).getEOpposite()) != null) {
                additionalProposalInfo.append(" oppositeOf ");
                additionalProposalInfo.append(opposite.getName());
            }
            AtlCompletionProposal proposal = new AtlCompletionProposal(replacementString, offset - prefix.length(), replacementString.length(), image, replacementString, 0, additionalProposalInfo.toString());
            res.add(proposal);
        }
        Collections.sort(res);
        return res;
    }

    public List getHelperTypesProposals(String prefix, int offset) {
        ArrayList res = new ArrayList();
        res.addAll(this.getMetaElementsProposals(prefix, offset, 0));
        Object[] types = new String[]{"Boolean", "String", "Integer", "Sequence", "Set", "Bag", "OrderedSet", "Map"};
        res.addAll(AtlCompletionDataSource.getProposalsFromList(offset, prefix, types));
        return res;
    }

    private static boolean startsWithIgnoreCase(String prefix, String replacementString) {
        if (replacementString.length() >= prefix.length()) {
            String tmp = replacementString.substring(0, prefix.length());
            return tmp.equalsIgnoreCase(prefix);
        }
        return false;
    }

    private static String getEClassifierShortPath(EClassifier eClassifier, boolean mode) {
        String name = eClassifier.getName();
        if (eClassifier.getEPackage() != null && mode) {
            name = "\"" + eClassifier.getEPackage().getName() + "::" + name + "\"";
        }
        return name;
    }

    public static Image getImage(String path) {
        ImageDescriptor descriptor;
        Image result = (Image)path2image.get(path);
        if (result == null && !path2image.containsKey(path) && (descriptor = AtlUIPlugin.getImageDescriptor(path)) != null) {
            result = descriptor.createImage();
            path2image.put(path, result);
        }
        if (result != null && result.isDisposed()) {
            result = null;
        }
        return result;
    }

    public static Object eGet(EObject self, String featureName) {
        EStructuralFeature feature = self.eClass().getEStructuralFeature(featureName);
        if (feature != null) {
            return self.eGet(feature);
        }
        return null;
    }

    public EClassifier getEClassifierFromAtlType(EObject atlType) {
        EObject model;
        if (atlType != null && (model = (EObject)AtlCompletionDataSource.eGet(atlType, "model")) != null) {
            Iterator iterator;
            String metamodelId = AtlCompletionDataSource.eGet(model, "name").toString();
            List packages = this.fEditor.getSourceManager().getMetamodelPackages(metamodelId);
            if (packages != null && (iterator = packages.iterator()).hasNext()) {
                EPackage pack = (EPackage)iterator.next();
                EClassifier res = pack.getEClassifier(AtlCompletionDataSource.eGet(atlType, "name").toString());
                return res;
            }
        }
        return null;
    }

    public static Map getVariables(EObject rule) {
        HashMap<Object, Object> res = new HashMap<Object, Object>();
        res.put("thisModule", null);
        TreeIterator ruleContentsIterator = rule.eAllContents();
        while (ruleContentsIterator.hasNext()) {
            EObject content = (EObject)ruleContentsIterator.next();
            if (!content.eClass().getName().equals("SimpleInPatternElement")) continue;
            res.put(AtlCompletionDataSource.eGet(content, "varName"), AtlCompletionDataSource.eGet(content, "type"));
        }
        return res;
    }

    public List getVariablesProposals(EObject rule, String prefix, int offset) {
        ArrayList<AtlCompletionProposal> res = new ArrayList<AtlCompletionProposal>();
        Map variables = AtlCompletionDataSource.getVariables(rule);
        for (Map.Entry entry : variables.entrySet()) {
            String replacementString = entry.getKey().toString();
            StringBuffer additionalProposalInfo = new StringBuffer();
            EClassifier classifier = this.getEClassifierFromAtlType((EObject)entry.getValue());
            if (classifier != null) {
                additionalProposalInfo.append(AtlCompletionDataSource.getEClassifierShortPath(classifier, false));
            }
            if (!AtlCompletionDataSource.startsWithIgnoreCase(prefix, replacementString) || prefix.equals(replacementString)) continue;
            AtlCompletionProposal proposal = new AtlCompletionProposal(replacementString, offset - prefix.length(), replacementString.length(), null, replacementString, 0, additionalProposalInfo.toString());
            res.add(proposal);
        }
        return res;
    }

    public static List getProposalsFromList(int offset, String prefix, Object[] proposals) {
        ArrayList<AtlCompletionProposal> res = new ArrayList<AtlCompletionProposal>();
        int i = 0;
        while (i < proposals.length) {
            String replacementString = proposals[i].toString();
            if (AtlCompletionDataSource.startsWithIgnoreCase(prefix, replacementString)) {
                res.add(new AtlCompletionProposal(replacementString, offset - prefix.length(), replacementString.length(), null, replacementString, 0, null));
            }
            ++i;
        }
        Collections.sort(res);
        return res;
    }
}

