/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.atl.core.ui.vm.debug;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import org.eclipse.m2m.atl.common.ATLLogger;
import org.eclipse.m2m.atl.core.ui.vm.debug.ADWPDebuggee;
import org.eclipse.m2m.atl.core.ui.vm.debug.LocalObjectReference;
import org.eclipse.m2m.atl.debug.core.adwp.ADWPCommand;
import org.eclipse.m2m.atl.debug.core.adwp.IntegerValue;
import org.eclipse.m2m.atl.debug.core.adwp.StringValue;
import org.eclipse.m2m.atl.debug.core.adwp.Value;
import org.eclipse.m2m.atl.engine.vm.ASM;
import org.eclipse.m2m.atl.engine.vm.ASMExecEnv;
import org.eclipse.m2m.atl.engine.vm.ASMOperation;
import org.eclipse.m2m.atl.engine.vm.ASMParameter;
import org.eclipse.m2m.atl.engine.vm.ASMStackFrame;
import org.eclipse.m2m.atl.engine.vm.ASMXMLReader;
import org.eclipse.m2m.atl.engine.vm.Debugger;
import org.eclipse.m2m.atl.engine.vm.NativeStackFrame;
import org.eclipse.m2m.atl.engine.vm.SimpleDebugger;
import org.eclipse.m2m.atl.engine.vm.StackFrame;
import org.eclipse.m2m.atl.engine.vm.nativelib.ASMModel;
import org.eclipse.m2m.atl.engine.vm.nativelib.ASMModule;
import org.eclipse.m2m.atl.engine.vm.nativelib.ASMOclAny;

public class NetworkDebugger
implements Debugger {
    private ASMExecEnv execEnv;
    private NetworkDebugger thisDebugger = this;
    private Map<Integer, Command> commands = new HashMap<Integer, Command>();
    private boolean step;
    private boolean stepOver;
    private boolean finish;
    private boolean finished;
    private int depth;
    private Socket socket;
    private ADWPDebuggee debuggee;
    private List<String> breakpoints = new ArrayList<String>();

    public NetworkDebugger(final int port, boolean suspend) {
        new Command(10, "get a property from an object"){

            public boolean doIt(ADWPCommand cmd, StackFrame frame) {
                List args = cmd.getArgs();
                LocalObjectReference o = (LocalObjectReference)((Object)args.get(0));
                String propName = ((StringValue)args.get(1)).getValue();
                Value ret = o.get(propName);
                NetworkDebugger.this.debuggee.sendMessage(101, cmd.getAck(), Arrays.asList(ret));
                return false;
            }
        };
        new Command(11, "set a property to an object"){

            public boolean doIt(ADWPCommand cmd, StackFrame frame) {
                List args = cmd.getArgs();
                LocalObjectReference o = (LocalObjectReference)((Object)args.get(0));
                String propName = ((StringValue)args.get(1)).getValue();
                Value value = (Value)args.get(2);
                o.set(propName, value);
                return false;
            }
        };
        new Command(12, "call an operation on an object"){

            public boolean doIt(ADWPCommand cmd, StackFrame frame) {
                List args = cmd.getArgs();
                LocalObjectReference o = (LocalObjectReference)((Object)args.get(0));
                String opName = ((StringValue)args.get(1)).getValue();
                int nbArgs = ((IntegerValue)args.get(2)).getValue();
                ArrayList<Value> realArgs = nbArgs == 0 ? new ArrayList<Value>() : args.subList(3, args.size());
                Value ret = o.call(opName, realArgs);
                NetworkDebugger.this.debuggee.sendMessage(101, cmd.getAck(), Arrays.asList(ret));
                return false;
            }
        };
        new Command(21, "executes a query in the current context"){

            public boolean doIt(ADWPCommand cmd, StackFrame frame) {
                List args = cmd.getArgs();
                String query = ((StringValue)args.get(1)).getValue();
                ASMOclAny asmRet = null;
                try {
                    String pname;
                    ASM asm = new ASMXMLReader().read((InputStream)new ByteArrayInputStream(query.getBytes()));
                    SimpleDebugger debugger = new SimpleDebugger(false, new ArrayList(), new ArrayList(), new ArrayList(), new ArrayList(), true);
                    ASMOperation op = asm.getOperation("test");
                    ASMModule asmModule = new ASMModule(asm);
                    ArrayList<Object> arguments = new ArrayList<Object>();
                    arguments.add(0, asmModule);
                    ASMExecEnv env = new ASMExecEnv(asmModule, (Debugger)debugger);
                    Map models = NetworkDebugger.this.execEnv.getModels();
                    for (String mname : models.keySet()) {
                        env.addModel(mname, (ASMModel)models.get(mname));
                    }
                    env.registerOperations(asm);
                    HashMap<String, ASMOclAny> pvalues = new HashMap<String, ASMOclAny>();
                    ASMStackFrame asmFrame = (ASMStackFrame)frame;
                    for (String slot : asmFrame.getLocalVariables().keySet()) {
                        pname = slot.equals("_stack") ? slot : asmFrame.resolveVariableName(Integer.parseInt(slot));
                        pvalues.put(pname, asmFrame.getVariable(slot));
                    }
                    for (ASMParameter p : op.getParameters()) {
                        pname = op.resolveVariableName(Integer.parseInt(p.getName()), 0);
                        ASMOclAny value = (ASMOclAny)pvalues.get(pname);
                        arguments.add(value);
                    }
                    ASMStackFrame qframe = ASMStackFrame.rootFrame((ASMExecEnv)env, (ASMOperation)op, arguments);
                    asmRet = op.exec((StackFrame)qframe);
                }
                catch (Exception e) {
                    ATLLogger.log((Level)Level.SEVERE, (String)e.getLocalizedMessage(), (Throwable)e);
                }
                Value ret = LocalObjectReference.asm2value(asmRet, NetworkDebugger.this.thisDebugger);
                NetworkDebugger.this.debuggee.sendMessage(101, cmd.getAck(), Arrays.asList(ret));
                return false;
            }
        };
        new Command(0, "resume program execution"){

            public boolean doIt(ADWPCommand cmd, StackFrame frame) {
                return true;
            }
        };
        new Command(1, "execute a single instruction; stepping into method calls"){

            public boolean doIt(ADWPCommand cmd, StackFrame frame) {
                NetworkDebugger.this.step = true;
                return true;
            }
        };
        new Command(2, "execute a single instruction; stepping over method calls"){

            public boolean doIt(ADWPCommand cmd, StackFrame frame) {
                NetworkDebugger.this.stepOver = true;
                NetworkDebugger.this.depth = 0;
                return true;
            }
        };
        new Command(3, "run until after the execution of the current operation"){

            public boolean doIt(ADWPCommand cmd, StackFrame frame) {
                NetworkDebugger.this.finish = true;
                NetworkDebugger.this.depth = 0;
                return true;
            }
        };
        new Command(13, "set a breakpoint"){

            public boolean doIt(ADWPCommand cmd, StackFrame frame) {
                List args = cmd.getArgs();
                String location = ((StringValue)args.get(0)).getValue();
                NetworkDebugger.this.breakpoints.add(location);
                return false;
            }
        };
        new Command(14, "unset a breakpoint"){

            public boolean doIt(ADWPCommand cmd, StackFrame frame) {
                List args = cmd.getArgs();
                String location = ((StringValue)args.get(0)).getValue();
                NetworkDebugger.this.breakpoints.remove(location);
                return false;
            }
        };
        new Command(20, "disassemble current operation"){

            public boolean doIt(ADWPCommand cmd, StackFrame frame) {
                ASMOperation op = (ASMOperation)((StackFrame)((LocalObjectReference)((Object)cmd.getArgs().get(0))).getObject()).getOperation();
                List instr = op.getInstructions();
                ArrayList<StringValue> msgArgs = new ArrayList<StringValue>();
                int k = 0;
                Iterator i = instr.iterator();
                while (i.hasNext()) {
                    String inst = i.next().toString();
                    if (inst.startsWith("load ")) {
                        inst = "load " + op.resolveVariableName(Integer.parseInt(inst.substring(5)), k);
                    } else if (inst.startsWith("store ")) {
                        inst = "store " + op.resolveVariableName(Integer.parseInt(inst.substring(6)), k);
                    }
                    msgArgs.add(StringValue.valueOf((String)inst));
                    ++k;
                }
                NetworkDebugger.this.debuggee.sendMessage(102, cmd.getAck(), msgArgs);
                return false;
            }
        };
        if (suspend) {
            this.step = true;
        }
        Thread init = new Thread(){

            public void run() {
                try {
                    ServerSocket server = new ServerSocket(port);
                    NetworkDebugger.this.socket = server.accept();
                    server.close();
                    NetworkDebugger.this.debuggee = new ADWPDebuggee(NetworkDebugger.this.socket.getInputStream(), NetworkDebugger.this.socket.getOutputStream());
                }
                catch (IOException ioe) {
                    ATLLogger.log((Level)Level.SEVERE, (String)ioe.getLocalizedMessage(), (Throwable)ioe);
                }
            }
        };
        if (suspend) {
            init.run();
        } else {
            init.start();
        }
    }

    public ASMExecEnv getExecEnv() {
        return this.execEnv;
    }

    public void enter(StackFrame frame) {
        if (this.stepOver || this.finish) {
            ++this.depth;
        }
    }

    public void leave(StackFrame frame) {
        if (this.depth == 0 && this.finish) {
            this.step = true;
            this.finished = true;
        }
        if ((this.stepOver || this.finish) && this.depth > 0) {
            --this.depth;
        }
    }

    public void step(ASMStackFrame frame) {
        if (this.execEnv == null) {
            this.execEnv = (ASMExecEnv)frame.getExecEnv();
        }
        if (this.stepOver && this.depth == 0) {
            this.stepOver = false;
            this.step = true;
        }
        if (this.step) {
            if (this.finished) {
                this.dialog((StackFrame)frame, "after finishing");
            } else {
                this.dialog((StackFrame)frame, "for stepping");
            }
        } else {
            int location = frame.getLocation();
            ASMOperation operation = (ASMOperation)frame.getOperation();
            String sourceLocation = operation.resolveLineNumber(location);
            if (this.breakpoints.contains(sourceLocation)) {
                this.dialog((StackFrame)frame, "for breakpoint");
            }
        }
    }

    public void terminated() {
        try {
            this.debuggee.sendMessage(103, 0, Collections.emptyList());
            this.socket.close();
        }
        catch (IOException e) {
            ATLLogger.log((Level)Level.SEVERE, (String)e.getLocalizedMessage(), (Throwable)e);
        }
    }

    public void error(StackFrame stackFrame, String msg, Exception e) {
        this.dialog(stackFrame, "ERROR: " + msg);
        if (e != null) {
            ATLLogger.log((Level)Level.SEVERE, (String)e.getLocalizedMessage(), (Throwable)e);
        } else if (msg != null) {
            ATLLogger.severe((String)("Message: " + msg));
        }
    }

    private void dialog(StackFrame stFrame, String msg) {
        StackFrame frame = stFrame;
        while (frame instanceof NativeStackFrame) {
            frame = frame.getParent();
        }
        int location = ((ASMStackFrame)frame).getLocation();
        ASMOperation operation = (ASMOperation)frame.getOperation();
        String opName = operation.getName();
        String sourceLocation = operation.resolveLineNumber(location);
        this.debuggee.sendMessage(100, 0, Arrays.asList(StringValue.valueOf((String)msg), LocalObjectReference.valueOf(frame, this), StringValue.valueOf((String)opName), IntegerValue.valueOf((int)location), StringValue.valueOf((String)sourceLocation)));
        boolean resume = false;
        do {
            ADWPCommand acmd = this.debuggee.readCommand();
            resume = false;
            this.step = false;
            this.stepOver = false;
            this.finish = false;
            this.finished = false;
            Command cmd = this.commands.get(acmd.getCode());
            if (cmd == null) {
                ATLLogger.warning((String)("unsupported command: " + acmd.getCode()));
                continue;
            }
            resume = cmd.doIt(acmd, frame);
        } while (!resume);
    }

    protected abstract class Command {
        private String description;

        public Command(int cmd, String description) {
            this.description = description;
            NetworkDebugger.this.commands.put(cmd, this);
        }

        public abstract boolean doIt(ADWPCommand var1, StackFrame var2);

        public String getDescription() {
            return this.description;
        }
    }
}

