/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.internal.xpand.ast;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.eclipse.gmf.internal.xpand.ast.AstVisitor;
import org.eclipse.gmf.internal.xpand.ast.ErrorStatement;
import org.eclipse.gmf.internal.xpand.ast.ExpandStatement;
import org.eclipse.gmf.internal.xpand.ast.ExpressionStatement;
import org.eclipse.gmf.internal.xpand.ast.FileStatement;
import org.eclipse.gmf.internal.xpand.ast.ForEachStatement;
import org.eclipse.gmf.internal.xpand.ast.IfStatement;
import org.eclipse.gmf.internal.xpand.ast.LetStatement;
import org.eclipse.gmf.internal.xpand.ast.ProtectStatement;
import org.eclipse.gmf.internal.xpand.ast.Statement;
import org.eclipse.gmf.internal.xpand.ast.Template;
import org.eclipse.gmf.internal.xpand.ast.TextStatement;
import org.eclipse.gmf.internal.xpand.model.XpandAdvice;
import org.eclipse.gmf.internal.xpand.model.XpandDefinition;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompositeAstVisitor
implements AstVisitor {
    private AstVisitor[] myVisitors;

    public CompositeAstVisitor(AstVisitor ... visitors) {
        this.myVisitors = visitors;
    }

    @Override
    public boolean visit(Template template) {
        return this.visitAll(template, Template.class);
    }

    @Override
    public boolean visit(XpandAdvice advice) {
        return this.visitAll(advice, XpandAdvice.class);
    }

    @Override
    public boolean visit(XpandDefinition definition) {
        return this.visitAll(definition, XpandDefinition.class);
    }

    @Override
    public boolean visit(ErrorStatement statement) {
        return this.visitAll(statement, ErrorStatement.class);
    }

    @Override
    public boolean visit(ExpandStatement statement) {
        return this.visitAll(statement, ExpandStatement.class);
    }

    @Override
    public boolean visit(ExpressionStatement statement) {
        return this.visitAll(statement, ExpressionStatement.class);
    }

    @Override
    public boolean visit(FileStatement statement) {
        return this.visitAll(statement, FileStatement.class);
    }

    @Override
    public boolean visit(ForEachStatement statement) {
        return this.visitAll(statement, ForEachStatement.class);
    }

    @Override
    public boolean visit(IfStatement statement) {
        return this.visitAll(statement, IfStatement.class);
    }

    @Override
    public boolean visit(LetStatement statement) {
        return this.visitAll(statement, LetStatement.class);
    }

    @Override
    public boolean visit(ProtectStatement statement) {
        return this.visitAll(statement, ProtectStatement.class);
    }

    @Override
    public boolean visit(TextStatement statement) {
        return this.visitAll(statement, TextStatement.class);
    }

    @Override
    public boolean visit(Statement statement) {
        return this.visitAll(statement, Statement.class);
    }

    private boolean visitAll(Object astElement, Class<?> parameterType) {
        try {
            Method visitMethod = AstVisitor.class.getMethod("visit", parameterType);
            boolean breakIteration = true;
            AstVisitor[] astVisitorArray = this.myVisitors;
            int n = this.myVisitors.length;
            int n2 = 0;
            while (n2 < n) {
                AstVisitor visitor = astVisitorArray[n2];
                Object result = visitMethod.invoke((Object)visitor, astElement);
                assert (result instanceof Boolean);
                breakIteration = breakIteration && (Boolean)result == false;
                ++n2;
            }
            return !breakIteration;
        }
        catch (SecurityException securityException) {
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (InvocationTargetException invocationTargetException) {}
        assert (false) : "incorrect parameter type passed";
        return false;
    }
}

