/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.internal.xpand;

import java.util.Collections;
import java.util.Map;
import java.util.Stack;
import org.eclipse.gmf.internal.xpand.AbstractOutput;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BufferOutput
extends AbstractOutput {
    private final Stack<StringBuilder> outletStack;
    private final Map<String, StringBuilder> namedSlots;

    public BufferOutput(StringBuilder buffer) {
        this(buffer, null);
    }

    public BufferOutput(StringBuilder buffer, Map<String, StringBuilder> namedSlots) {
        assert (buffer != null);
        this.outletStack = new Stack();
        this.outletStack.push(buffer);
        this.namedSlots = namedSlots != null ? namedSlots : Collections.emptyMap();
    }

    @Override
    public void closeFile() {
        if (this.outletStack.size() == 1) {
            String msg = "CLOSE FILE without previous openFile";
            System.err.println("<<<" + msg);
            throw new UnsupportedOperationException(msg);
        }
        this.outletStack.pop();
    }

    @Override
    public void openFile(String path, String outletName) {
        if (!this.namedSlots.containsKey(outletName)) {
            String msg = "OPEN FILE ('" + path + "', " + outletName + ")";
            System.err.println(">>>" + msg);
            throw new UnsupportedOperationException(msg);
        }
        this.outletStack.push(this.namedSlots.get(outletName));
        assert (this.outletStack.peek() != null);
    }

    @Override
    protected void doAppend(String text) {
        this.outletStack.peek().append(text);
    }
}

