/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.internal.xpand.migration;

import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.gmf.internal.xpand.ResourceManager;
import org.eclipse.gmf.internal.xpand.ast.AbstractDefinition;
import org.eclipse.gmf.internal.xpand.ast.Advice;
import org.eclipse.gmf.internal.xpand.ast.Definition;
import org.eclipse.gmf.internal.xpand.ast.ErrorStatement;
import org.eclipse.gmf.internal.xpand.ast.ExpandStatement;
import org.eclipse.gmf.internal.xpand.ast.ExpressionStatement;
import org.eclipse.gmf.internal.xpand.ast.FileStatement;
import org.eclipse.gmf.internal.xpand.ast.ForEachStatement;
import org.eclipse.gmf.internal.xpand.ast.IfStatement;
import org.eclipse.gmf.internal.xpand.ast.ImportDeclaration;
import org.eclipse.gmf.internal.xpand.ast.LetStatement;
import org.eclipse.gmf.internal.xpand.ast.NamespaceImport;
import org.eclipse.gmf.internal.xpand.ast.Statement;
import org.eclipse.gmf.internal.xpand.ast.Template;
import org.eclipse.gmf.internal.xpand.expression.AnalysationIssue;
import org.eclipse.gmf.internal.xpand.expression.ast.DeclaredParameter;
import org.eclipse.gmf.internal.xpand.expression.ast.Expression;
import org.eclipse.gmf.internal.xpand.expression.ast.Identifier;
import org.eclipse.gmf.internal.xpand.expression.ast.SyntaxElement;
import org.eclipse.gmf.internal.xpand.migration.ExpandAnalyzeTrace;
import org.eclipse.gmf.internal.xpand.migration.ExpressionAnalyzeTrace;
import org.eclipse.gmf.internal.xpand.migration.ExpressionMigrationFacade;
import org.eclipse.gmf.internal.xpand.migration.ForEachAnalyzeTrace;
import org.eclipse.gmf.internal.xpand.migration.MigrationException;
import org.eclipse.gmf.internal.xpand.migration.MigrationExecutionContext;
import org.eclipse.gmf.internal.xpand.migration.MigrationExecutionContextImpl;
import org.eclipse.gmf.internal.xpand.migration.ModelManager;
import org.eclipse.gmf.internal.xpand.migration.OclKeywordManager;
import org.eclipse.gmf.internal.xpand.migration.StandardLibraryImports;
import org.eclipse.gmf.internal.xpand.migration.TypeManager;
import org.eclipse.gmf.internal.xpand.migration.VariableNameDispatcher;
import org.eclipse.gmf.internal.xpand.model.XpandResource;
import org.eclipse.gmf.internal.xpand.util.CompositeXpandResource;
import org.eclipse.gmf.internal.xpand.xtend.ast.XtendResource;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.text.edits.InsertEdit;
import org.eclipse.text.edits.MalformedTreeException;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XpandMigrationFacade {
    private ResourceManager resourceManager;
    private String resourceName;
    private Document document;
    private MigrationExecutionContext ctx;
    private MultiTextEdit edit;
    private ModelManager modelManager;
    private TypeManager typeManager;
    private OclKeywordManager oclKeywordManager;
    private MigrationExecutionContext rootExecutionContext;

    public XpandMigrationFacade(ResourceManager resourceManager, String xtendResourceName, MigrationExecutionContext executionContext) {
        this(resourceManager, xtendResourceName);
        this.rootExecutionContext = executionContext;
    }

    public XpandMigrationFacade(ResourceManager resourceManager, String xtendResourceName) {
        this.resourceManager = resourceManager;
        this.resourceName = xtendResourceName;
    }

    public String migrateXpandResource() throws MigrationException {
        StringBuilder originalContent = new StringBuilder();
        try {
            Reader[] readers = this.resourceManager.resolveMultiple(this.resourceName, "xpt");
            assert (readers.length > 0);
            Reader mainReader = readers[0];
            int ch = mainReader.read();
            while (ch != -1) {
                originalContent.append((char)ch);
                ch = mainReader.read();
            }
        }
        catch (IOException iOException) {
            throw new MigrationException(MigrationException.Type.RESOURCE_NOT_FOUND, this.resourceName, "Unable to load resource: " + this.resourceName);
        }
        XpandResource xpandResource = this.resourceManager.loadXpandResource(this.resourceName);
        if (xpandResource == null) {
            throw new MigrationException(MigrationException.Type.RESOURCE_NOT_FOUND, this.resourceName, "Unable to load resource: " + this.resourceName);
        }
        this.ctx = this.rootExecutionContext != null ? this.rootExecutionContext : (MigrationExecutionContext)new MigrationExecutionContextImpl(this.resourceManager, new EPackage[0]).cloneWithResource(xpandResource);
        HashSet<AnalysationIssue> issues = new HashSet<AnalysationIssue>();
        xpandResource.analyze(this.ctx, issues);
        if (MigrationException.hasErrors(issues)) {
            throw new MigrationException(issues, this.resourceName);
        }
        Template xpandTemplate = this.getFirstTemplate(xpandResource);
        this.document = new Document(originalContent.toString());
        this.edit = new MultiTextEdit();
        this.migrate(xpandTemplate);
        try {
            this.edit.apply((IDocument)this.document);
        }
        catch (MalformedTreeException e) {
            throw new MigrationException(MigrationException.Type.UNABLE_TO_APPLY_EDIT, this.resourceName, e.getMessage());
        }
        catch (BadLocationException e) {
            throw new MigrationException(MigrationException.Type.UNABLE_TO_APPLY_EDIT, this.resourceName, e.getMessage());
        }
        return this.document.get();
    }

    private Template getFirstTemplate(XpandResource xpandResource) throws MigrationException {
        while (xpandResource instanceof CompositeXpandResource) {
            xpandResource = ((CompositeXpandResource)xpandResource).getFirstDefinition();
        }
        if (!(xpandResource instanceof Template)) {
            throw new MigrationException(MigrationException.Type.UNSUPPORTED_XPAND_RESOURCE, this.resourceName, "Only Template instances are supported, but loaded: " + xpandResource);
        }
        return (Template)xpandResource;
    }

    private void migrate(Template xpandTemplate) throws MigrationException {
        StandardLibraryImports stdLibImportsManager = new StandardLibraryImports(this.getStdLibImportsPosition(xpandTemplate));
        this.oclKeywordManager = new OclKeywordManager();
        this.modelManager = new ModelManager(stdLibImportsManager, this.oclKeywordManager);
        this.modelManager.registerSelfAlias("this");
        this.typeManager = new TypeManager(this.oclKeywordManager);
        Object[] objectArray = xpandTemplate.getImports();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            NamespaceImport namespaceImport = objectArray[n2];
            this.migrateExpression(namespaceImport.getStringLiteral(), (EClassifier)EcorePackage.eINSTANCE.getEString(), Collections.<String, EClassifier>emptyMap(), new VariableNameDispatcher());
            ++n2;
        }
        objectArray = xpandTemplate.getDefinitions();
        n = objectArray.length;
        n2 = 0;
        while (n2 < n) {
            Object definition = objectArray[n2];
            assert (definition instanceof AbstractDefinition);
            this.migrateDefinition((AbstractDefinition)definition);
            ++n2;
        }
        objectArray = xpandTemplate.getAdvices();
        n = objectArray.length;
        n2 = 0;
        while (n2 < n) {
            Object advice = objectArray[n2];
            assert (advice instanceof Advice);
            this.migrateDefinition((Advice)advice);
            ++n2;
        }
        this.injectStdlibImports(stdLibImportsManager, this.getAdditionalLibraries(xpandTemplate));
    }

    private int getStdLibImportsPosition(Template xpandTemplate) {
        int offset = 0;
        if (xpandTemplate.getExtensions().length > 0) {
            ImportDeclaration[] extensions = xpandTemplate.getExtensions();
            offset = extensions[extensions.length - 1].getEndOffset();
        } else if (xpandTemplate.getImports().length > 0) {
            NamespaceImport[] imports = xpandTemplate.getImports();
            offset = imports[imports.length - 1].getEndOffset();
        }
        if (offset > 0) {
            try {
                while (!"\u00bb".equals(this.document.get(offset, 1))) {
                    ++offset;
                }
                ++offset;
            }
            catch (BadLocationException badLocationException) {
                offset = 0;
            }
        }
        return offset;
    }

    private List<String> getAdditionalLibraries(Template xpandTemplate) {
        ArrayList<String> result = new ArrayList<String>();
        ImportDeclaration[] importDeclarationArray = xpandTemplate.getExtensions();
        int n = importDeclarationArray.length;
        int n2 = 0;
        while (n2 < n) {
            ImportDeclaration extension = importDeclarationArray[n2];
            XtendResource xtendResource = this.resourceManager.loadXtendResource(extension.getImportString().getValue());
            if (xtendResource != null) {
                result.addAll(this.getReexportedExtensions(xtendResource));
            }
            ++n2;
        }
        return result;
    }

    private List<String> getReexportedExtensions(XtendResource xtendResource) {
        ArrayList<String> result = new ArrayList<String>();
        String[] stringArray = xtendResource.getImportedExtensions();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String extension = stringArray[n2];
            if (xtendResource.isReexported(extension)) {
                result.add(extension);
                XtendResource extensionResource = this.resourceManager.loadXtendResource(extension);
                result.addAll(this.getReexportedExtensions(extensionResource));
            }
            ++n2;
        }
        return result;
    }

    private void injectStdlibImports(StandardLibraryImports stdLibImportsManager, List<String> list) {
        list.addAll(Arrays.asList(stdLibImportsManager.getLibraries()));
        if (list.isEmpty()) {
            return;
        }
        StringBuilder sb = new StringBuilder();
        if (stdLibImportsManager.getPlaceholderIndex() > 0) {
            sb.append(ExpressionMigrationFacade.LF);
        }
        int i = 0;
        while (i < list.size()) {
            if (i > 0) {
                sb.append(ExpressionMigrationFacade.LF);
            }
            sb.append("\u00abEXTENSION ");
            sb.append(list.get(i));
            sb.append("\u00bb");
            ++i;
        }
        if (stdLibImportsManager.getPlaceholderIndex() == 0) {
            sb.append(ExpressionMigrationFacade.LF);
        }
        this.insert(stdLibImportsManager.getPlaceholderIndex(), sb);
    }

    private void migrateDefinition(AbstractDefinition definition) throws MigrationException {
        assert (definition instanceof Definition || definition instanceof Advice);
        this.migrateIdentifier(definition instanceof Definition ? ((Definition)definition).getDefName() : ((Advice)definition).getPointCut());
        HashMap<String, EClassifier> envVariables = new HashMap<String, EClassifier>();
        DeclaredParameter[] declaredParameterArray = definition.getParams();
        int n = declaredParameterArray.length;
        int n2 = 0;
        while (n2 < n) {
            DeclaredParameter parameter = declaredParameterArray[n2];
            envVariables.put(parameter.getName().getValue(), this.migrateParameter(parameter));
            ++n2;
        }
        Identifier targetType = definition.getType();
        EClassifier qvtType = this.ctx.getTypeForName(targetType.getValue());
        this.replace(targetType, this.typeManager.getQvtFQName(qvtType));
        envVariables.put("this", qvtType);
        VariableNameDispatcher variableNameDispatcher = new VariableNameDispatcher(definition);
        Statement[] statementArray = definition.getBody();
        int n3 = statementArray.length;
        int n4 = 0;
        while (n4 < n3) {
            Statement statement = statementArray[n4];
            this.migrateStatement(statement, variableNameDispatcher, envVariables);
            ++n4;
        }
    }

    private void migrateIdentifier(Identifier definitionName) {
        if (this.oclKeywordManager.isOclKeyword(definitionName)) {
            this.replace(definitionName, this.oclKeywordManager.getValidIdentifierValue(definitionName));
        }
    }

    private void migrateStatement(Statement statement, VariableNameDispatcher variableNameDispatcher, Map<String, EClassifier> envVariables) throws MigrationException {
        block15: {
            block20: {
                block19: {
                    block18: {
                        block17: {
                            block16: {
                                block14: {
                                    if (!(statement instanceof ExpressionStatement)) break block14;
                                    ExpressionStatement expressionStatement = (ExpressionStatement)statement;
                                    this.migrateExpression(expressionStatement.getExpression(), (EClassifier)EcorePackage.eINSTANCE.getEString(), envVariables, variableNameDispatcher);
                                    break block15;
                                }
                                if (!(statement instanceof ErrorStatement)) break block16;
                                ErrorStatement errorStatement = (ErrorStatement)statement;
                                this.migrateExpression(errorStatement.getMessage(), (EClassifier)EcorePackage.eINSTANCE.getEString(), envVariables, variableNameDispatcher);
                                break block15;
                            }
                            if (!(statement instanceof ExpandStatement)) break block17;
                            ExpandStatement expandStatement = (ExpandStatement)statement;
                            this.migrateExpandStatementDefinition(expandStatement);
                            ExpressionAnalyzeTrace trace = this.ctx.getTraces().get(expandStatement);
                            assert (trace instanceof ExpandAnalyzeTrace);
                            ExpandAnalyzeTrace expTrace = (ExpandAnalyzeTrace)trace;
                            Expression[] expressionArray = expandStatement.getParameters();
                            int n = expressionArray.length;
                            int n2 = 0;
                            while (n2 < n) {
                                Expression parameter = expressionArray[n2];
                                this.migrateExpression(parameter, expTrace.getParameterType(parameter), envVariables, variableNameDispatcher);
                                ++n2;
                            }
                            if (expandStatement.getTarget() != null) {
                                this.migrateExpression(expandStatement.getTarget(), expTrace.getResultType(), envVariables, variableNameDispatcher);
                            }
                            if (expandStatement.getSeparator() == null) break block15;
                            this.migrateExpression(expandStatement.getSeparator(), expTrace.getSeparatorType(), envVariables, variableNameDispatcher);
                            break block15;
                        }
                        if (!(statement instanceof FileStatement)) break block18;
                        FileStatement fileStatement = (FileStatement)statement;
                        this.migrateExpression(fileStatement.getTargetFileName(), (EClassifier)EcorePackage.eINSTANCE.getEString(), envVariables, variableNameDispatcher);
                        Statement[] statementArray = fileStatement.getBody();
                        int parameter = statementArray.length;
                        int expTrace = 0;
                        while (expTrace < parameter) {
                            Statement bodyStatement = statementArray[expTrace];
                            this.migrateStatement(bodyStatement, variableNameDispatcher, envVariables);
                            ++expTrace;
                        }
                        break block15;
                    }
                    if (!(statement instanceof ForEachStatement)) break block19;
                    ForEachStatement forEach = (ForEachStatement)statement;
                    ExpressionAnalyzeTrace trace = this.ctx.getTraces().get(forEach);
                    assert (trace instanceof ForEachAnalyzeTrace);
                    ForEachAnalyzeTrace forEachTrace = (ForEachAnalyzeTrace)trace;
                    this.migrateExpression(forEach.getTarget(), forEachTrace.getResultType(), envVariables, variableNameDispatcher);
                    if (forEach.getSeparator() != null) {
                        this.migrateExpression(forEach.getSeparator(), forEachTrace.getSeparatorType(), envVariables, variableNameDispatcher);
                    }
                    Statement[] statementArray = forEach.getBody();
                    int n = statementArray.length;
                    int n3 = 0;
                    while (n3 < n) {
                        Statement bodyStatement = statementArray[n3];
                        this.migrateStatement(bodyStatement, variableNameDispatcher, envVariables);
                        ++n3;
                    }
                    break block15;
                }
                if (!(statement instanceof IfStatement)) break block20;
                IfStatement ifStatement = (IfStatement)statement;
                if (ifStatement.getCondition() != null) {
                    ExpressionAnalyzeTrace trace = this.ctx.getTraces().get(ifStatement);
                    this.migrateExpression(ifStatement.getCondition(), trace.getResultType(), envVariables, variableNameDispatcher);
                }
                Statement[] statementArray = ifStatement.getThenPart();
                int n = statementArray.length;
                int forEachTrace = 0;
                while (forEachTrace < n) {
                    Statement thenStatement = statementArray[forEachTrace];
                    this.migrateStatement(thenStatement, variableNameDispatcher, envVariables);
                    ++forEachTrace;
                }
                if (ifStatement.getElseIf() == null) break block15;
                this.migrateStatement(ifStatement.getElseIf(), variableNameDispatcher, envVariables);
                break block15;
            }
            if (statement instanceof LetStatement) {
                LetStatement letStatement = (LetStatement)statement;
                this.migrateIdentifier(letStatement.getVarName());
                ExpressionAnalyzeTrace trace = this.ctx.getTraces().get(letStatement);
                this.migrateExpression(letStatement.getVarValue(), trace.getResultType(), envVariables, variableNameDispatcher);
                envVariables.put(letStatement.getVarName().getValue(), trace.getResultType());
                try {
                    Statement[] statementArray = letStatement.getBody();
                    int n = statementArray.length;
                    int n4 = 0;
                    while (n4 < n) {
                        Statement bodyStatement = statementArray[n4];
                        this.migrateStatement(bodyStatement, variableNameDispatcher, envVariables);
                        ++n4;
                    }
                }
                finally {
                    envVariables.remove(letStatement.getVarName().getValue());
                }
            }
        }
    }

    private void migrateExpandStatementDefinition(ExpandStatement expandStatement) {
        Identifier definition = expandStatement.getDefinition();
        String fullQualifiedDefinitionName = definition.getValue();
        int lastSeparatorIndex = fullQualifiedDefinitionName.lastIndexOf("::");
        if (lastSeparatorIndex == -1) {
            this.migrateIdentifier(definition);
            return;
        }
        String namePrefix = fullQualifiedDefinitionName.substring(0, lastSeparatorIndex);
        String shortName = fullQualifiedDefinitionName.substring(lastSeparatorIndex + "::".length());
        if (this.oclKeywordManager.isOclKeyword(shortName)) {
            this.replace(definition, String.valueOf(namePrefix) + "::" + this.oclKeywordManager.getValidIdentifierValue(shortName));
        }
    }

    private EClassifier migrateParameter(DeclaredParameter parameter) throws MigrationException {
        EClassifier parameterType = this.ctx.getTypeForName(parameter.getType().getValue());
        this.replace(parameter, String.valueOf(this.oclKeywordManager.getValidIdentifierValue(parameter.getName())) + " : " + this.typeManager.getQvtFQName(parameterType));
        return parameterType;
    }

    private void migrateExpression(Expression expression, EClassifier expectedExpressionType, Map<String, EClassifier> envVariables, VariableNameDispatcher variableNameDispatcher) throws MigrationException {
        ExpressionMigrationFacade expressionMF = new ExpressionMigrationFacade(expression, expectedExpressionType, envVariables, this.typeManager, this.modelManager, variableNameDispatcher, this.ctx, this.resourceName);
        StringBuilder result = expressionMF.migrate();
        this.replace(expression, result.toString());
    }

    private void replace(SyntaxElement syntaxElement, CharSequence replacement) {
        ReplaceEdit replaceEdit = new ReplaceEdit(syntaxElement.getStartOffset(), syntaxElement.getEndOffset() + 1 - syntaxElement.getStartOffset(), replacement.toString());
        this.edit.addChild((TextEdit)replaceEdit);
    }

    private void insert(int position, CharSequence text) {
        InsertEdit insertEdit = new InsertEdit(position, text.toString());
        this.edit.addChild((TextEdit)insertEdit);
    }
}

