/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.internal.xpand.xtend.ast;

import java.util.List;
import java.util.Set;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.gmf.internal.xpand.expression.AnalysationIssue;
import org.eclipse.gmf.internal.xpand.expression.ExecutionContext;
import org.eclipse.gmf.internal.xpand.expression.Variable;
import org.eclipse.gmf.internal.xpand.expression.ast.DeclaredParameter;
import org.eclipse.gmf.internal.xpand.expression.ast.Identifier;
import org.eclipse.gmf.internal.xpand.migration.ExpressionAnalyzeTrace;
import org.eclipse.gmf.internal.xpand.xtend.ast.Extension;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WorkflowSlotExtensionStatement
extends Extension {
    private final Identifier slotName;

    public WorkflowSlotExtensionStatement(int start, int end, int line, int startOffset, int endOffset, Identifier name, List<DeclaredParameter> formalParameters, Identifier returnType, Identifier slotName, boolean cached, boolean isPrivate) {
        super(start, end, line, startOffset, endOffset, name, returnType, formalParameters, cached, isPrivate);
        this.slotName = slotName;
    }

    @Override
    public Object evaluateInternal(Object[] parameters, ExecutionContext ctx) {
        Variable result = ctx.getGlobalVariable(this.slotName.getValue());
        if (result == null) {
            return null;
        }
        return result.getValue();
    }

    @Override
    public void analyzeInternal(ExecutionContext ctx, Set<AnalysationIssue> issues) {
        if (this.returnType == null) {
            issues.add(new AnalysationIssue(AnalysationIssue.Type.SYNTAX_ERROR, "A return type must be specified for workflow slot extensions!", this));
        } else {
            this.createAnalyzeTrace(ctx, new ExpressionAnalyzeTrace(ctx.getTypeForName(this.getReturnTypeIdentifier().getValue())));
        }
    }

    @Override
    protected EClassifier internalGetReturnType(EClassifier[] parameters, ExecutionContext ctx, Set<AnalysationIssue> issues) {
        if (this.returnType == null) {
            issues.add(new AnalysationIssue(AnalysationIssue.Type.SYNTAX_ERROR, "A return type must be specified for workflow slot extensions!", this));
            return null;
        }
        return ctx.getTypeForName(this.returnType.getValue());
    }

    public Identifier getSlotName() {
        return this.slotName;
    }
}

