/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.tests.setup.figures;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Iterator;
import java.util.List;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.LineBorder;
import org.eclipse.draw2d.MarginBorder;
import org.eclipse.draw2d.Polyline;
import org.eclipse.draw2d.Shape;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.Transform;
import org.eclipse.emf.codegen.util.CodeGenUtil;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gmf.gmfgraph.BasicFont;
import org.eclipse.gmf.gmfgraph.CompoundBorder;
import org.eclipse.gmf.gmfgraph.ConstantColor;
import org.eclipse.gmf.gmfgraph.CustomAttribute;
import org.eclipse.gmf.gmfgraph.CustomBorder;
import org.eclipse.gmf.gmfgraph.Figure;
import org.eclipse.gmf.gmfgraph.Font;
import org.eclipse.gmf.gmfgraph.FontStyle;
import org.eclipse.gmf.gmfgraph.GMFGraphFactory;
import org.eclipse.gmf.gmfgraph.GMFGraphPackage;
import org.eclipse.gmf.gmfgraph.Insets;
import org.eclipse.gmf.gmfgraph.LineKind;
import org.eclipse.gmf.gmfgraph.Point;
import org.eclipse.gmf.gmfgraph.PolygonDecoration;
import org.eclipse.gmf.gmfgraph.PolylineDecoration;
import org.eclipse.gmf.gmfgraph.RGBColor;
import org.eclipse.gmf.gmfgraph.RealFigure;
import org.eclipse.gmf.gmfgraph.ScalablePolygon;
import org.eclipse.gmf.runtime.draw2d.ui.figures.WrappingLabel;
import org.eclipse.gmf.tests.setup.figures.FigureCheck;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericFigureCheck
extends FigureCheck {
    private final Figure myGMFRootFigure;
    private static final ColorTransformer ourColorConstantTransformer = new ColorTransformer();

    public GenericFigureCheck(Figure eFigure) {
        this.myGMFRootFigure = eFigure;
    }

    @Override
    protected void checkFigure(IFigure figure) {
        GenericFigureCheck.assertNotNull((Object)figure);
        this.checkFigure(this.myGMFRootFigure, figure);
    }

    protected void checkFigure(Figure gmfFigure, IFigure d2dFigure) {
        this.checkFigureItself(gmfFigure, d2dFigure);
        this.checkFigureChildren(gmfFigure, d2dFigure);
    }

    protected void checkFigureChildren(Figure gmfFigure, IFigure d2dFigure) {
        if (!(gmfFigure instanceof RealFigure)) {
            return;
        }
        EList gmfChildren = ((RealFigure)gmfFigure).getChildren();
        List d2dChildren = d2dFigure.getChildren();
        GenericFigureCheck.assertNotNull((Object)gmfChildren);
        GenericFigureCheck.assertNotNull((Object)d2dChildren);
        GenericFigureCheck.assertTrue((gmfChildren.size() <= d2dChildren.size() ? 1 : 0) != 0);
        Iterator gmfIter = gmfChildren.iterator();
        Iterator d2dIter = d2dChildren.iterator();
        while (gmfIter.hasNext()) {
            Figure nextGMF = (Figure)gmfIter.next();
            IFigure nextD2D = (IFigure)d2dIter.next();
            this.checkFigure(nextGMF, nextD2D);
        }
    }

    protected void checkFigureItself(Figure gmfFigure, IFigure d2dFigure) {
        this.checkSize(gmfFigure, d2dFigure);
        this.checkMaximumSize(gmfFigure, d2dFigure);
        this.checkMinimumSize(gmfFigure, d2dFigure);
        this.checkPreferredSize(gmfFigure, d2dFigure);
        this.checkFont(gmfFigure, d2dFigure);
        this.checkForeground(gmfFigure, d2dFigure);
        this.checkBackgroud(gmfFigure, d2dFigure);
        this.checkInsets(gmfFigure, d2dFigure);
        this.checkBorder(gmfFigure, d2dFigure);
        this.checkShapeProperties(gmfFigure, d2dFigure);
        this.checkLabelText(gmfFigure, d2dFigure);
        this.checkPolylinePoints(gmfFigure, d2dFigure);
    }

    private void checkShapeProperties(Figure gmfFigure, IFigure figure) {
        if (gmfFigure instanceof org.eclipse.gmf.gmfgraph.Shape) {
            org.eclipse.gmf.gmfgraph.Shape eShape = (org.eclipse.gmf.gmfgraph.Shape)gmfFigure;
            GenericFigureCheck.assertTrue((boolean)(figure instanceof Shape));
            Shape d2dShape = (Shape)figure;
            this.checkLineKind(eShape, d2dShape);
            this.checkLineWidth(eShape, d2dShape);
        }
    }

    protected void checkLineWidth(org.eclipse.gmf.gmfgraph.Shape eShape, Shape d2dShape) {
        if (eShape.eIsSet((EStructuralFeature)GMFGraphPackage.eINSTANCE.getShape_LineWidth())) {
            int expected = eShape.getLineWidth();
            GenericFigureCheck.assertEquals((int)expected, (int)d2dShape.getLineWidth());
        }
    }

    protected void checkLineKind(org.eclipse.gmf.gmfgraph.Shape eShape, Shape d2dShape) {
        if (eShape.eIsSet((EStructuralFeature)GMFGraphPackage.eINSTANCE.getShape_LineKind())) {
            LineKind expected = eShape.getLineKind();
            GenericFigureCheck.assertEquals((int)this.transformLineKind(expected), (int)d2dShape.getLineStyle());
        }
    }

    private int transformLineKind(LineKind kind) {
        Object d2dValue = GenericFigureCheck.getStaticFieldValue("Unknown LineKind: " + kind, Graphics.class, kind.getName());
        GenericFigureCheck.assertTrue((boolean)(d2dValue instanceof Integer));
        return (Integer)d2dValue;
    }

    protected final void checkDimension(org.eclipse.gmf.gmfgraph.Dimension eDimension, Dimension d2dDimension) {
        GenericFigureCheck.assertEquals((Object)new Dimension(eDimension.getDx(), eDimension.getDy()), (Object)d2dDimension);
    }

    protected void checkPolylinePoints(Figure gmfFigure, IFigure d2dFigure) {
        if (gmfFigure instanceof ScalablePolygon) {
            this.checkScalablePolygon((ScalablePolygon)gmfFigure, d2dFigure);
            return;
        }
        if (gmfFigure instanceof org.eclipse.gmf.gmfgraph.Polyline && gmfFigure.eIsSet((EStructuralFeature)GMFGraphPackage.eINSTANCE.getPolyline_Template())) {
            org.eclipse.gmf.gmfgraph.Polyline gmfPolyline = (org.eclipse.gmf.gmfgraph.Polyline)gmfFigure;
            GenericFigureCheck.assertTrue((boolean)(d2dFigure instanceof Polyline));
            Polyline d2dPolyline = (Polyline)d2dFigure;
            PointList d2dPoints = d2dPolyline.getPoints();
            EList gmfPoints = gmfPolyline.getTemplate();
            Transform transform = new Transform();
            if (gmfFigure instanceof PolylineDecoration || gmfFigure instanceof PolygonDecoration) {
                transform.setScale(7.0, 3.0);
            }
            GenericFigureCheck.assertEquals((int)gmfPoints.size(), (int)d2dPoints.size());
            int i = 0;
            while (i < d2dPoints.size()) {
                Point ePoint = (Point)gmfPoints.get(i);
                org.eclipse.draw2d.geometry.Point d2dPoint = d2dPoints.getPoint(i);
                this.checkPoint(transform, ePoint, d2dPoint);
                ++i;
            }
        }
    }

    protected void checkScalablePolygon(ScalablePolygon gmfFigure, IFigure figure) {
        GenericFigureCheck.assertNotNull((Object)figure);
    }

    private void checkPoint(Transform tr, Point ePoint, org.eclipse.draw2d.geometry.Point d2dPoint) {
        GenericFigureCheck.assertEquals((Object)tr.getTransformed(new org.eclipse.draw2d.geometry.Point(ePoint.getX(), ePoint.getY())), (Object)d2dPoint);
    }

    protected final void checkPoint(Point ePoint, org.eclipse.draw2d.geometry.Point d2dPoint) {
        if (ePoint == null) {
            ePoint = GMFGraphFactory.eINSTANCE.createPoint();
        }
        GenericFigureCheck.assertEquals((Object)new org.eclipse.draw2d.geometry.Point(ePoint.getX(), ePoint.getY()), (Object)d2dPoint);
    }

    protected void checkLabelText(Figure gmfFigure, IFigure d2dFigure) {
        if (gmfFigure instanceof org.eclipse.gmf.gmfgraph.Label && gmfFigure.eIsSet((EStructuralFeature)GMFGraphPackage.eINSTANCE.getLabel_Text())) {
            if (d2dFigure instanceof Label) {
                Label d2dLabel = (Label)d2dFigure;
                org.eclipse.gmf.gmfgraph.Label gmfLabel = (org.eclipse.gmf.gmfgraph.Label)gmfFigure;
                GenericFigureCheck.assertEquals((String)gmfLabel.getText(), (String)d2dLabel.getText());
            } else if (d2dFigure instanceof WrappingLabel) {
                WrappingLabel d2dLabel = (WrappingLabel)d2dFigure;
                org.eclipse.gmf.gmfgraph.Label gmfLabel = (org.eclipse.gmf.gmfgraph.Label)gmfFigure;
                GenericFigureCheck.assertEquals((String)gmfLabel.getText(), (String)d2dLabel.getText());
            } else {
                GenericFigureCheck.fail((String)"draw2d.IFigure for gmfgraph.Label is not either WrappingLabel or draw2d.Label");
            }
        }
    }

    protected void checkBackgroud(Figure gmfFigure, IFigure figure) {
        if (gmfFigure.eIsSet((EStructuralFeature)GMFGraphPackage.eINSTANCE.getFigure_BackgroundColor())) {
            this.checkColor(gmfFigure.getBackgroundColor(), figure.getBackgroundColor());
        }
    }

    protected void checkForeground(Figure gmfFigure, IFigure figure) {
        if (gmfFigure.eIsSet((EStructuralFeature)GMFGraphPackage.eINSTANCE.getFigure_ForegroundColor())) {
            this.checkColor(gmfFigure.getForegroundColor(), figure.getForegroundColor());
        }
    }

    protected final void checkColor(org.eclipse.gmf.gmfgraph.Color eColor, Color swtColor) {
        GenericFigureCheck.assertNotNull((Object)swtColor);
        GenericFigureCheck.assertNotNull((Object)eColor);
        ourColorConstantTransformer.gmf2swt(eColor);
    }

    protected void checkFont(Figure gmfFigure, IFigure figure) {
        if (gmfFigure.eIsSet((EStructuralFeature)GMFGraphPackage.eINSTANCE.getFigure_Font())) {
            Font eFont = gmfFigure.getFont();
            this.checkFont(eFont, figure.getFont());
        }
    }

    protected final void checkFont(Font gmfFont, org.eclipse.swt.graphics.Font actual) {
        GenericFigureCheck.assertNotNull((Object)actual);
        if (gmfFont instanceof BasicFont && actual.getFontData().length == 1) {
            BasicFont expected = (BasicFont)gmfFont;
            FontData theOnly = actual.getFontData()[0];
            String expectedName = expected.getFaceName();
            if (expectedName == null || expectedName.trim().length() == 0) {
                expectedName = Display.getDefault().getSystemFont().getFontData()[0].getName();
            }
            String actualName = theOnly.getName();
            GenericFigureCheck.assertEquals((String)expectedName, (String)actualName);
            GenericFigureCheck.assertEquals((int)expected.getHeight(), (int)theOnly.getHeight());
            int expectedStyle = this.gmfStyle2swtStyle(expected.getStyle());
            GenericFigureCheck.assertEquals((int)expectedStyle, (int)theOnly.getStyle());
        }
    }

    private int gmfStyle2swtStyle(FontStyle gmfStyle) {
        switch (gmfStyle.getValue()) {
            case 1: {
                return 1;
            }
            case 2: {
                return 2;
            }
            case 0: {
                return 0;
            }
        }
        throw new IllegalStateException("Unknown font style: " + gmfStyle);
    }

    private static Object getStaticFieldValue(String failureMessage, Class<?> clazz, String fieldName) {
        try {
            Field constant = clazz.getField(fieldName);
            GenericFigureCheck.assertNotNull((String)failureMessage, (Object)constant);
            Object value = constant.get(null);
            GenericFigureCheck.assertNotNull((String)failureMessage, (Object)value);
            return value;
        }
        catch (Exception e) {
            GenericFigureCheck.fail((String)(String.valueOf(failureMessage) + "\n" + e.toString()));
            throw new InternalError("Unreachable");
        }
    }

    protected void checkPreferredSize(Figure gmfFigure, IFigure figure) {
        if (gmfFigure.eIsSet((EStructuralFeature)GMFGraphPackage.eINSTANCE.getFigure_PreferredSize())) {
            org.eclipse.gmf.gmfgraph.Dimension ePreferredSize = gmfFigure.getPreferredSize();
            this.checkDimension(ePreferredSize, figure.getPreferredSize());
        }
    }

    protected void checkSize(Figure gmfFigure, IFigure figure) {
        if (gmfFigure.eIsSet((EStructuralFeature)GMFGraphPackage.eINSTANCE.getFigure_Size())) {
            Point eSize = gmfFigure.getSize();
            GenericFigureCheck.assertEquals((Object)new Dimension(eSize.getX(), eSize.getY()), (Object)figure.getSize());
        }
    }

    protected void checkMaximumSize(Figure gmfFigure, IFigure figure) {
        if (gmfFigure.eIsSet((EStructuralFeature)GMFGraphPackage.eINSTANCE.getFigure_MaximumSize())) {
            org.eclipse.gmf.gmfgraph.Dimension eSize = gmfFigure.getMaximumSize();
            this.checkDimension(eSize, figure.getMaximumSize());
        }
    }

    protected void checkMinimumSize(Figure gmfFigure, IFigure figure) {
        if (gmfFigure.eIsSet((EStructuralFeature)GMFGraphPackage.eINSTANCE.getFigure_MinimumSize())) {
            org.eclipse.gmf.gmfgraph.Dimension eSize = gmfFigure.getMinimumSize();
            this.checkDimension(eSize, figure.getMinimumSize());
        }
    }

    protected void checkBorder(Figure gmfFigure, IFigure figure) {
        if (gmfFigure.eIsSet((EStructuralFeature)GMFGraphPackage.eINSTANCE.getFigure_Border())) {
            org.eclipse.gmf.gmfgraph.Border eBorder = gmfFigure.getBorder();
            this.checkBorder(eBorder, figure.getBorder(), figure);
        }
    }

    protected final void checkBorder(org.eclipse.gmf.gmfgraph.Border eBorder, Border d2dBorder, IFigure mainD2DFigure) {
        GenericFigureCheck.assertNotNull((Object)eBorder);
        GenericFigureCheck.assertNotNull((Object)d2dBorder);
        if (eBorder instanceof org.eclipse.gmf.gmfgraph.LineBorder) {
            this.checkLineBorder((org.eclipse.gmf.gmfgraph.LineBorder)eBorder, d2dBorder);
        } else if (eBorder instanceof CompoundBorder) {
            this.checkCompoundBorder((CompoundBorder)eBorder, d2dBorder, mainD2DFigure);
        } else if (eBorder instanceof org.eclipse.gmf.gmfgraph.MarginBorder) {
            this.checkMarginBorder((org.eclipse.gmf.gmfgraph.MarginBorder)eBorder, d2dBorder, mainD2DFigure);
        } else if (eBorder instanceof CustomBorder) {
            this.checkCustomBorder((CustomBorder)eBorder, d2dBorder, mainD2DFigure);
        }
    }

    protected final void checkCustomBorder(CustomBorder eBorder, Border d2dBorder, IFigure mainD2DFigure) {
        GenericFigureCheck.assertEquals((String)eBorder.getQualifiedClassName(), (String)d2dBorder.getClass().getName());
        for (CustomAttribute next : eBorder.getAttributes()) {
            this.checkCustomAttribute(next, d2dBorder);
        }
    }

    protected final void checkCustomAttribute(CustomAttribute eAttribute, Object instance) {
        Object result;
        GenericFigureCheck.assertNotNull((Object)eAttribute.getValue());
        GenericFigureCheck.assertNotNull((Object)eAttribute.getName());
        String expectedValue = eAttribute.getValue().trim();
        String getterName = "get" + CodeGenUtil.capName((String)eAttribute.getName());
        try {
            Method getter = instance.getClass().getMethod(getterName, new Class[0]);
            if (!getter.getReturnType().equals(String.class) && !getter.getReturnType().isPrimitive()) {
                return;
            }
            if (getter.getReturnType().equals(String.class)) {
                if (expectedValue.startsWith("\"")) {
                    expectedValue = expectedValue.substring(1);
                }
                if (expectedValue.endsWith("\"")) {
                    expectedValue = expectedValue.substring(0, expectedValue.length() - 1);
                }
            }
            getter.setAccessible(true);
            result = getter.invoke(instance, new Object[0]);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return;
        }
        catch (Exception e) {
            throw new RuntimeException(String.valueOf(e.getClass().getSimpleName()) + "; getter: " + getterName + ", instance: " + instance, e);
        }
        GenericFigureCheck.assertEquals((String)("Attribute '" + eAttribute.getName() + "', "), (String)expectedValue, (String)String.valueOf(result));
    }

    protected final void checkMarginBorder(org.eclipse.gmf.gmfgraph.MarginBorder eBorder, Border d2dBorder, IFigure mainD2DFigure) {
        GenericFigureCheck.assertTrue((boolean)(d2dBorder instanceof MarginBorder));
        MarginBorder actual = (MarginBorder)d2dBorder;
        if (eBorder.eIsSet((EStructuralFeature)GMFGraphPackage.eINSTANCE.getMarginBorder_Insets())) {
            Insets eInsets = eBorder.getInsets();
            this.checkInsets(eInsets, actual.getInsets(mainD2DFigure));
        }
    }

    protected final void checkCompoundBorder(CompoundBorder eBorder, Border d2dBorder, IFigure mainD2DFigure) {
        GenericFigureCheck.assertTrue((boolean)(d2dBorder instanceof org.eclipse.draw2d.CompoundBorder));
        org.eclipse.draw2d.CompoundBorder actual = (org.eclipse.draw2d.CompoundBorder)d2dBorder;
        if (eBorder.eIsSet((EStructuralFeature)GMFGraphPackage.eINSTANCE.getCompoundBorder_Inner())) {
            this.checkBorder(eBorder.getInner(), actual.getInnerBorder(), mainD2DFigure);
        }
        if (eBorder.eIsSet((EStructuralFeature)GMFGraphPackage.eINSTANCE.getCompoundBorder_Outer())) {
            this.checkBorder(eBorder.getOuter(), actual.getOuterBorder(), mainD2DFigure);
        }
    }

    protected final void checkLineBorder(org.eclipse.gmf.gmfgraph.LineBorder eBorder, Border d2dBorder) {
        GenericFigureCheck.assertTrue((boolean)(d2dBorder instanceof LineBorder));
        LineBorder actual = (LineBorder)d2dBorder;
        GenericFigureCheck.assertEquals((int)eBorder.getWidth(), (int)actual.getWidth());
        if (eBorder.eIsSet((EStructuralFeature)GMFGraphPackage.eINSTANCE.getLineBorder_Color())) {
            this.checkColor(eBorder.getColor(), actual.getColor());
        }
    }

    protected void checkInsets(Figure gmfFigure, IFigure figure) {
        if (gmfFigure.eIsSet((EStructuralFeature)GMFGraphPackage.eINSTANCE.getFigure_Insets())) {
            this.checkInsets(gmfFigure.getInsets(), figure.getInsets());
        }
    }

    protected final void checkInsets(Insets eInsets, org.eclipse.draw2d.geometry.Insets d2dInsets) {
        GenericFigureCheck.assertNotNull((Object)d2dInsets);
        GenericFigureCheck.assertNotNull((Object)eInsets);
        GenericFigureCheck.assertEquals((Object)new org.eclipse.draw2d.geometry.Insets(eInsets.getTop(), eInsets.getLeft(), eInsets.getBottom(), eInsets.getRight()), (Object)d2dInsets);
    }

    public static class ColorTransformer {
        public RGB gmf2swt(org.eclipse.gmf.gmfgraph.Color color) {
            if (color instanceof ConstantColor) {
                return this.gmfConstant2swt((ConstantColor)color);
            }
            if (color instanceof RGBColor) {
                return this.gmfRGB2swt((RGBColor)color);
            }
            throw new IllegalArgumentException("Unknown color:" + color);
        }

        public RGB gmfConstant2swt(ConstantColor gmfColor) {
            Class<ColorConstants> d2dClass = ColorConstants.class;
            Object d2dValue = GenericFigureCheck.getStaticFieldValue("Unknown color: " + gmfColor, d2dClass, gmfColor.getValue().getLiteral());
            GenericFigureCheck.assertTrue((boolean)(d2dValue instanceof Color));
            return ((Color)d2dValue).getRGB();
        }

        public RGB gmfRGB2swt(RGBColor gmfColor) {
            return new RGB(gmfColor.getRed(), gmfColor.getGreen(), gmfColor.getBlue());
        }
    }
}

