/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.tests.migration;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import junit.framework.TestCase;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreValidator;
import org.eclipse.gmf.internal.common.migrate.MigrationDelegate;
import org.eclipse.gmf.internal.common.migrate.MigrationDelegateImpl;
import org.eclipse.gmf.internal.common.migrate.MigrationResource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericMigrationTest
extends TestCase {
    private EAttribute myAttrToRemove;
    private EAttribute myAttrToRename;
    private EReference myWidenedRef1;
    private EReference myWidenedRef2;
    private EAttribute myAttrNarrow;
    private EAttribute myAttrNarrowChild;

    public GenericMigrationTest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.createMetaModel();
    }

    private EPackage createMetaModel() {
        EPackage mmPackage = EcoreFactory.eINSTANCE.createEPackage();
        EClass mClass = EcoreFactory.eINSTANCE.createEClass();
        this.myAttrToRemove = EcoreFactory.eINSTANCE.createEAttribute();
        this.myAttrToRename = EcoreFactory.eINSTANCE.createEAttribute();
        this.myWidenedRef1 = EcoreFactory.eINSTANCE.createEReference();
        this.myWidenedRef2 = EcoreFactory.eINSTANCE.createEReference();
        this.myAttrNarrow = EcoreFactory.eINSTANCE.createEAttribute();
        this.myAttrNarrowChild = EcoreFactory.eINSTANCE.createEAttribute();
        EClass mNarrowClass = EcoreFactory.eINSTANCE.createEClass();
        EClass mNarrowClassChild = EcoreFactory.eINSTANCE.createEClass();
        mNarrowClassChild.getESuperTypes().add((Object)mNarrowClass);
        mmPackage.getEClassifiers().add((Object)mClass);
        mmPackage.getEClassifiers().add((Object)mNarrowClass);
        mmPackage.getEClassifiers().add((Object)mNarrowClassChild);
        mClass.getEStructuralFeatures().add((Object)this.myAttrToRemove);
        mClass.getEStructuralFeatures().add((Object)this.myAttrToRename);
        mClass.getEStructuralFeatures().add((Object)this.myWidenedRef1);
        mClass.getEStructuralFeatures().add((Object)this.myWidenedRef2);
        mNarrowClass.getEStructuralFeatures().add((Object)this.myAttrNarrow);
        mNarrowClassChild.getEStructuralFeatures().add((Object)this.myAttrNarrowChild);
        mmPackage.setName("MM1");
        mmPackage.setNsPrefix("mm");
        mmPackage.setNsURI("uri:/mm/1");
        mClass.setName("MClass");
        mNarrowClass.setName("NarrowClass");
        mNarrowClassChild.setName("NarrowClassChild");
        this.myAttrToRemove.setName("myRemovedAttr");
        this.myAttrToRemove.setEType((EClassifier)EcorePackage.eINSTANCE.getEString());
        this.myAttrToRename.setName("myRenamedAttr");
        this.myAttrToRename.setEType((EClassifier)EcorePackage.eINSTANCE.getEString());
        this.myWidenedRef1.setName("myWidenedRef1");
        this.myWidenedRef1.setUpperBound(-1);
        this.myWidenedRef1.setContainment(true);
        this.myWidenedRef1.setEType((EClassifier)mNarrowClass);
        this.myWidenedRef2.setName("myWidenedRef2");
        this.myWidenedRef2.setUpperBound(-1);
        this.myWidenedRef2.setContainment(true);
        this.myWidenedRef2.setEType((EClassifier)mNarrowClass);
        this.myAttrNarrow.setName("myNarrowAttr");
        this.myAttrNarrow.setEType((EClassifier)EcorePackage.eINSTANCE.getEString());
        this.myAttrNarrowChild.setName("myNarrowChildAttr");
        this.myAttrNarrowChild.setLowerBound(1);
        this.myAttrNarrowChild.setEType((EClassifier)EcorePackage.eINSTANCE.getEString());
        return mmPackage;
    }

    private EObject newInstance() {
        return this.getMetaModel().getEFactoryInstance().create(this.myAttrToRemove.getEContainingClass());
    }

    private EObject newNarrowInstance() {
        return this.getMetaModel().getEFactoryInstance().create(this.myAttrNarrow.getEContainingClass());
    }

    private EObject newNarrowChildInstance() {
        return this.getMetaModel().getEFactoryInstance().create(this.myAttrNarrowChild.getEContainingClass());
    }

    private EPackage getMetaModel() {
        return this.myWidenedRef1.getEContainingClass().getEPackage();
    }

    private boolean checkResourceHasNoProblems(Resource migratedResource) {
        GenericMigrationTest.assertNotNull((Object)migratedResource);
        GenericMigrationTest.assertTrue((boolean)migratedResource.getErrors().isEmpty());
        if (migratedResource instanceof MigrationResource) {
            GenericMigrationTest.assertFalse((boolean)migratedResource.getWarnings().isEmpty());
            GenericMigrationTest.assertEquals((int)1, (int)migratedResource.getWarnings().size());
            GenericMigrationTest.assertTrue((boolean)(migratedResource.getWarnings().get(0) instanceof MigrationResource.Diagnostic));
        } else {
            GenericMigrationTest.assertTrue((boolean)migratedResource.getWarnings().isEmpty());
        }
        boolean validate = true;
        TreeIterator it = migratedResource.getAllContents();
        while (it.hasNext() && validate) {
            validate = EcoreValidator.INSTANCE.validate((EObject)it.next(), null, null);
        }
        return validate;
    }

    private String assertLoadingProblemsAfterMetamodelChanges(EPackage metamodel, URI modelResource) {
        String errorMessage = null;
        try {
            ResourceSetImpl rset = new ResourceSetImpl();
            rset.getPackageRegistry().put((Object)metamodel.getNsURI(), (Object)metamodel);
            Resource resource = rset.createResource(modelResource);
            resource.load(null);
            GenericMigrationTest.fail((String)"Load should fail because of metamodel changes");
        }
        catch (RuntimeException ex) {
            GenericMigrationTest.assertNotNull((Object)ex.getMessage());
            errorMessage = ex.getMessage();
        }
        catch (IOException ex) {
            GenericMigrationTest.assertNotNull((Object)ex.getMessage());
            errorMessage = ex.getMessage();
        }
        return errorMessage;
    }

    private URI saveToResource(EPackage metamodel, String filenameStart, String fileextension, EObject ... rootObjects) {
        URI uri = null;
        Collection roots = Arrays.asList(rootObjects);
        try {
            uri = URI.createFileURI((String)File.createTempFile(filenameStart, fileextension.startsWith(".") ? fileextension : "." + fileextension).getAbsolutePath());
            ResourceSetImpl resourceSetImpl = new ResourceSetImpl();
            resourceSetImpl.getPackageRegistry().put((Object)metamodel.getNsURI(), (Object)metamodel);
            Resource res = resourceSetImpl.createResource(uri);
            res.getContents().addAll(roots);
            res.save(null);
            resourceSetImpl.getResources().removeAll(roots);
        }
        catch (IOException ex) {
            GenericMigrationTest.fail((String)ex.toString());
        }
        return uri;
    }

    protected void checkNarrowedInstanceAttribute(EObject narrowInstance, EAttribute attribute, String attrValue) {
        GenericMigrationTest.assertEquals((Object)narrowInstance.eClass(), (Object)attribute.getEContainingClass());
        GenericMigrationTest.assertTrue((boolean)narrowInstance.eIsSet((EStructuralFeature)attribute));
        Object haveValue = narrowInstance.eGet((EStructuralFeature)attribute, true);
        GenericMigrationTest.assertEquals((Object)attrValue, (Object)haveValue);
    }

    protected List<EObject> checkReferenceIsNarrowed(EObject migratedObj, EReference widenedRef) {
        ArrayList<EObject> result = null;
        GenericMigrationTest.assertTrue((boolean)migratedObj.eIsSet((EStructuralFeature)widenedRef));
        Object narrowRef = migratedObj.eGet((EStructuralFeature)widenedRef, true);
        if (widenedRef.isMany()) {
            result = new ArrayList();
            GenericMigrationTest.assertTrue((boolean)(narrowRef instanceof EList));
            EList narrowRefs = (EList)narrowRef;
            GenericMigrationTest.assertFalse((boolean)narrowRefs.isEmpty());
            int i = 0;
            while (i < narrowRefs.size()) {
                Object migratedNarrowRefs = narrowRefs.get(i);
                GenericMigrationTest.assertTrue((boolean)(migratedNarrowRefs instanceof EObject));
                EObject narrowInstance = (EObject)migratedNarrowRefs;
                result.add(narrowInstance);
                ++i;
            }
        } else {
            GenericMigrationTest.assertTrue((boolean)(narrowRef instanceof EObject));
            EObject narrowInstance = (EObject)narrowRef;
            result = Collections.singletonList(narrowInstance);
        }
        return result;
    }

    private void checkInstanceClassChanged(EObject narrowInstance, EReference widenedReference) {
        GenericMigrationTest.assertFalse((boolean)narrowInstance.eClass().isAbstract());
        GenericMigrationTest.assertFalse((boolean)narrowInstance.eClass().equals(widenedReference.getEType()));
    }

    private void widenReferenceTypeFrom(EReference refToBeWiden, EClass containingClass, EPackage metamodel) {
        EClass mWideClass = EcoreFactory.eINSTANCE.createEClass();
        refToBeWiden.getEContainingClass().getEPackage().getEClassifiers().add((Object)mWideClass);
        mWideClass.setName("WideClass");
        mWideClass.setAbstract(true);
        refToBeWiden.setEType((EClassifier)mWideClass);
        EList supertypes = containingClass.getESuperTypes();
        if (!supertypes.contains((Object)mWideClass)) {
            supertypes.add((Object)mWideClass);
        }
    }

    private EList<EObject> create2DifferentReferences(String attrValue, String attrChildValue) {
        BasicEList narrowInstances = new BasicEList();
        if (attrValue != null) {
            EObject narrowInstance = this.newNarrowInstance();
            narrowInstance.eSet((EStructuralFeature)this.myAttrNarrow, (Object)attrValue);
            narrowInstances.add((Object)narrowInstance);
        }
        if (attrChildValue != null) {
            EObject narrowChildInstance = this.newNarrowChildInstance();
            narrowChildInstance.eSet((EStructuralFeature)this.myAttrNarrowChild, (Object)attrChildValue);
            narrowInstances.add((Object)narrowChildInstance);
        }
        return narrowInstances;
    }

    private EList<EObject> createNarrowReferences(String attrValue) {
        BasicEList narrowInstances = new BasicEList();
        if (attrValue != null) {
            EObject narrowInstance = this.newNarrowInstance();
            narrowInstance.eSet((EStructuralFeature)this.myAttrNarrow, (Object)attrValue);
            narrowInstances.add((Object)narrowInstance);
        }
        return narrowInstances;
    }

    private EObject createRootWithReferences(EReference reference, EList<EObject> referenceValues) {
        EObject testObject1 = this.newInstance();
        testObject1.eSet((EStructuralFeature)reference, referenceValues);
        return testObject1;
    }

    public void testRemovedAttribute() {
        EObject testObject = this.newInstance();
        testObject.eSet((EStructuralFeature)this.myAttrToRemove, (Object)"value");
        EPackage metamodel = this.getMetaModel();
        URI uri = this.saveToResource(metamodel, "removed", "tests", testObject);
        this.myAttrToRemove.getEContainingClass().getEStructuralFeatures().remove((Object)this.myAttrToRemove);
        String errorMessage = this.assertLoadingProblemsAfterMetamodelChanges(metamodel, uri);
        GenericMigrationTest.assertTrue((boolean)errorMessage.contains(this.myAttrToRemove.getName()));
        MigrationDelegateImpl delegate = new MigrationDelegateImpl();
        delegate.registerDeletedAttributes((EClassifier)testObject.eClass(), new String[]{this.myAttrToRemove.getName()});
        Resource migrated = this.loadMigrationResource(metamodel, (MigrationDelegate)delegate, uri);
        this.checkResourceHasNoProblems(migrated);
        GenericMigrationTest.assertEquals((int)1, (int)migrated.getContents().size());
        EObject migratedObj = (EObject)migrated.getContents().get(0);
        GenericMigrationTest.assertEquals((Object)testObject.eClass(), (Object)migratedObj.eClass());
    }

    public void testWidenedReference() {
        EList<EObject> narrowValues = this.createNarrowReferences("narrow value");
        EObject testObject = this.createRootWithReferences(this.myWidenedRef1, narrowValues);
        EPackage metamodel = this.getMetaModel();
        URI uri = this.saveToResource(metamodel, "widened", "tests", testObject);
        this.widenReferenceTypeFrom(this.myWidenedRef1, this.myAttrNarrow.getEContainingClass(), metamodel);
        this.assertLoadingProblemsAfterMetamodelChanges(this.getMetaModel(), uri);
        MigrationDelegateImpl delegate = new MigrationDelegateImpl();
        delegate.registerNarrowedAbstractType(this.myWidenedRef1.getEType().getName(), this.myAttrNarrow.getEContainingClass());
        Resource migrated = this.loadMigrationResource(metamodel, (MigrationDelegate)delegate, uri);
        this.checkResourceHasNoProblems(migrated);
        GenericMigrationTest.assertEquals((int)1, (int)migrated.getContents().size());
        EObject migratedObj = (EObject)migrated.getContents().get(0);
        GenericMigrationTest.assertEquals((Object)testObject.eClass(), (Object)migratedObj.eClass());
        List<EObject> narrowed = this.checkReferenceIsNarrowed(migratedObj, this.myWidenedRef1);
        GenericMigrationTest.assertEquals((int)1, (int)narrowed.size());
        EObject narrowInstance = narrowed.get(0);
        this.checkInstanceClassChanged(narrowInstance, this.myWidenedRef1);
        this.checkNarrowedInstanceAttribute(narrowInstance, this.myAttrNarrow, "narrow value");
    }

    public void testWidenedReferenceWith2Types() {
        EList<EObject> narrowValues = this.create2DifferentReferences("narrow value", "narrow child value");
        EObject testObject = this.createRootWithReferences(this.myWidenedRef1, narrowValues);
        EPackage metamodel = this.getMetaModel();
        URI uri = this.saveToResource(metamodel, "widened2Types", "tests", testObject);
        this.widenReferenceTypeFrom(this.myWidenedRef1, this.myAttrNarrow.getEContainingClass(), metamodel);
        this.assertLoadingProblemsAfterMetamodelChanges(metamodel, uri);
        MigrationDelegateImpl delegate = new MigrationDelegateImpl();
        delegate.registerNarrowedAbstractType(this.myWidenedRef1.getEType().getName(), this.myAttrNarrow.getEContainingClass());
        Resource migrated = this.loadMigrationResource(metamodel, (MigrationDelegate)delegate, uri);
        this.checkResourceHasNoProblems(migrated);
        GenericMigrationTest.assertEquals((int)1, (int)migrated.getContents().size());
        EObject migratedObj = (EObject)migrated.getContents().get(0);
        GenericMigrationTest.assertEquals((Object)testObject.eClass(), (Object)migratedObj.eClass());
        List<EObject> narrowed = this.checkReferenceIsNarrowed(migratedObj, this.myWidenedRef1);
        GenericMigrationTest.assertEquals((int)2, (int)narrowed.size());
        EObject narrowInstance1 = narrowed.get(0);
        this.checkInstanceClassChanged(narrowInstance1, this.myWidenedRef1);
        this.checkNarrowedInstanceAttribute(narrowInstance1, this.myAttrNarrow, "narrow value");
        EObject narrowInstance2 = narrowed.get(1);
        this.checkInstanceClassChanged(narrowInstance2, this.myWidenedRef1);
        this.checkNarrowedInstanceAttribute(narrowInstance2, this.myAttrNarrowChild, "narrow child value");
    }

    public void test2WidenedReferences() {
        EList<EObject> narrowValues1 = this.createNarrowReferences("narrow value 1");
        EObject testObject1 = this.createRootWithReferences(this.myWidenedRef1, narrowValues1);
        EList<EObject> narrowValues2 = this.create2DifferentReferences("narrow value 2", "narrow child value 2");
        EObject testObject2 = this.createRootWithReferences(this.myWidenedRef2, narrowValues2);
        EList<EObject> narrowValues3 = this.createNarrowReferences("narrow value 3");
        EObject testObject3 = this.createRootWithReferences(this.myWidenedRef1, narrowValues3);
        EList<EObject> narrowValues4 = this.createNarrowReferences("narrow value 4");
        EObject testObject4 = this.createRootWithReferences(this.myWidenedRef2, narrowValues4);
        EPackage metamodel = this.getMetaModel();
        URI uri = this.saveToResource(metamodel, "widened2Refs", "tests", testObject1, testObject2, testObject3, testObject4);
        this.widenReferenceTypeFrom(this.myWidenedRef1, this.myAttrNarrow.getEContainingClass(), metamodel);
        this.widenReferenceTypeFrom(this.myWidenedRef2, this.myAttrNarrow.getEContainingClass(), metamodel);
        this.assertLoadingProblemsAfterMetamodelChanges(metamodel, uri);
        MigrationDelegateImpl delegate = new MigrationDelegateImpl();
        delegate.registerNarrowedAbstractType(this.myWidenedRef1.getEType().getName(), this.myAttrNarrow.getEContainingClass());
        delegate.registerNarrowedAbstractType(this.myWidenedRef2.getEType().getName(), this.myAttrNarrow.getEContainingClass());
        Resource migrated = this.loadMigrationResource(metamodel, (MigrationDelegate)delegate, uri);
        this.checkResourceHasNoProblems(migrated);
        GenericMigrationTest.assertEquals((int)4, (int)migrated.getContents().size());
        EObject migratedObj1 = (EObject)migrated.getContents().get(0);
        GenericMigrationTest.assertEquals((Object)testObject1.eClass(), (Object)migratedObj1.eClass());
        List<EObject> narrowed1 = this.checkReferenceIsNarrowed(migratedObj1, this.myWidenedRef1);
        GenericMigrationTest.assertEquals((int)1, (int)narrowed1.size());
        this.checkReferenceIsNarrowed(migratedObj1, this.myWidenedRef1);
        EObject narrowed1first = narrowed1.get(0);
        this.checkNarrowedInstanceAttribute(narrowed1first, this.myAttrNarrow, "narrow value 1");
        EObject migratedObj2 = (EObject)migrated.getContents().get(1);
        GenericMigrationTest.assertEquals((Object)testObject2.eClass(), (Object)migratedObj2.eClass());
        List<EObject> narrowed2 = this.checkReferenceIsNarrowed(migratedObj2, this.myWidenedRef2);
        GenericMigrationTest.assertEquals((int)2, (int)narrowed2.size());
        this.checkReferenceIsNarrowed(migratedObj2, this.myWidenedRef2);
        EObject narrowed2first = narrowed2.get(0);
        this.checkNarrowedInstanceAttribute(narrowed2first, this.myAttrNarrow, "narrow value 2");
        EObject narrowed2second = narrowed2.get(1);
        this.checkNarrowedInstanceAttribute(narrowed2second, this.myAttrNarrowChild, "narrow child value 2");
        EObject migratedObj3 = (EObject)migrated.getContents().get(2);
        GenericMigrationTest.assertEquals((Object)testObject3.eClass(), (Object)migratedObj3.eClass());
        List<EObject> narrowed3 = this.checkReferenceIsNarrowed(migratedObj3, this.myWidenedRef1);
        GenericMigrationTest.assertEquals((int)1, (int)narrowed3.size());
        this.checkReferenceIsNarrowed(migratedObj3, this.myWidenedRef1);
        EObject narrowed3first = narrowed3.get(0);
        this.checkNarrowedInstanceAttribute(narrowed3first, this.myAttrNarrow, "narrow value 3");
        EObject migratedObj4 = (EObject)migrated.getContents().get(3);
        GenericMigrationTest.assertEquals((Object)testObject4.eClass(), (Object)migratedObj4.eClass());
        List<EObject> narrowed4 = this.checkReferenceIsNarrowed(migratedObj4, this.myWidenedRef2);
        GenericMigrationTest.assertEquals((int)1, (int)narrowed3.size());
        this.checkReferenceIsNarrowed(migratedObj4, this.myWidenedRef2);
        EObject narrowed4first = narrowed4.get(0);
        this.checkNarrowedInstanceAttribute(narrowed4first, this.myAttrNarrow, "narrow value 4");
    }

    public void testWidenedReferenceWithDifferentDefaults() {
        String attrValue = "narrow value";
        String attrChildValue = "narrow child value";
        EList<EObject> narrowValues = this.create2DifferentReferences(attrValue, attrChildValue);
        EObject testObject = this.createRootWithReferences(this.myWidenedRef1, narrowValues);
        EPackage metamodel = this.getMetaModel();
        URI uri = this.saveToResource(metamodel, "widened2Defaults", "tests", testObject);
        try {
            ResourceSetImpl resourceSetImpl = new ResourceSetImpl();
            resourceSetImpl.getPackageRegistry().put((Object)metamodel.getNsURI(), (Object)metamodel);
            Resource ordinaryResource = resourceSetImpl.createResource(uri);
            ordinaryResource.load(null);
            boolean validate = this.checkResourceHasNoProblems(ordinaryResource);
            GenericMigrationTest.assertTrue((String)"Should not fail with obligatory metamodel attribute not set", (boolean)validate);
        }
        catch (RuntimeException runtimeException) {
            GenericMigrationTest.fail();
        }
        catch (IOException iOException) {
            GenericMigrationTest.fail();
        }
        MigrationDelegateImpl badDelegate = new MigrationDelegateImpl();
        badDelegate.registerNarrowedAbstractType(this.myWidenedRef1.getEType().getName(), this.myAttrNarrowChild.getEContainingClass());
        Resource badMigrated = this.loadMigrationResource(this.getMetaModel(), (MigrationDelegate)badDelegate, uri);
        this.checkResourceHasNoProblems(badMigrated);
        boolean validateBad = this.checkResourceHasNoProblems(badMigrated);
        GenericMigrationTest.assertFalse((String)"Should fail with obligatory metamodel attribute not set", (boolean)validateBad);
    }

    private Resource loadMigrationResource(EPackage metamodel, MigrationDelegate delegate, URI modelResourceURI) {
        if (modelResourceURI == null) {
            throw new IllegalArgumentException("null resource uri");
        }
        ResourceSetImpl rset = new ResourceSetImpl();
        rset.getResources().add((Object)this.createMigrationResource(delegate, modelResourceURI));
        rset.getPackageRegistry().put((Object)metamodel.getNsURI(), (Object)metamodel);
        return rset.getResource(modelResourceURI, true);
    }

    private Resource createMigrationResource(final MigrationDelegate delegate, URI modelResourceURI) {
        return new MigrationResource(modelResourceURI){

            protected MigrationDelegate createDelegate() {
                return delegate;
            }
        };
    }
}

