/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.tests.xtend;

import java.util.Arrays;
import java.util.HashSet;
import junit.framework.TestCase;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.gmf.internal.xpand.ResourceManager;
import org.eclipse.gmf.internal.xpand.ResourceMarker;
import org.eclipse.gmf.internal.xpand.expression.AnalysationIssue;
import org.eclipse.gmf.internal.xpand.expression.ExecutionContext;
import org.eclipse.gmf.internal.xpand.expression.ExecutionContextImpl;
import org.eclipse.gmf.internal.xpand.expression.Variable;
import org.eclipse.gmf.internal.xpand.xtend.ast.XtendResource;
import org.eclipse.gmf.tests.xpand.TestsResourceManager;
import org.eclipse.gmf.tests.xtend.XtendFacade;

public class XtendFacadeTest
extends TestCase {
    private ResourceManager resourceManager;

    protected void setUp() throws Exception {
        super.setUp();
        this.resourceManager = new TestsResourceManager();
    }

    public final void testEval() {
        XtendFacade f = XtendFacade.create(this.resourceManager, XtendFacadeTest.qualified("Extensions"));
        XtendFacadeTest.assertEquals((Object)"_Stuff", (Object)f.call("appendStuff", new Object[]{"_"}));
    }

    public final void testEval1() {
        XtendFacade f = XtendFacade.create(this.resourceManager, XtendFacadeTest.qualified("AnotherExt"));
        XtendFacadeTest.assertEquals((Object)"XXStuff", (Object)f.call("doStuff", new Object[]{"X"}));
    }

    public final void testReExported() {
        XtendFacade f = XtendFacade.create(this.resourceManager, XtendFacadeTest.qualified("AnotherExt"));
        XtendFacadeTest.assertEquals((Object)"_Stuff", (Object)f.call("appendStuff", new Object[]{"_"}));
    }

    public final void testAnalyze() {
        XtendFacade f = XtendFacade.create(this.resourceManager, XtendFacadeTest.qualified("AnotherExt"));
        EClassifier t = f.analyze("doStuff", new Object[]{"X"}, new HashSet<AnalysationIssue>());
        XtendFacadeTest.assertEquals((String)"EString", (String)t.getName());
    }

    public void testGlobalVar() {
        XtendResource xres = this.resourceManager.loadXtendResource(XtendFacadeTest.qualified("globalvarExt"));
        Variable v1 = new Variable("xy", (Object)new Short(17));
        ExecutionContextImpl ctx = new ExecutionContextImpl(this.resourceManager, (ResourceMarker)xres, null, Arrays.asList(v1));
        XtendFacade f = new XtendFacade((ExecutionContext)ctx);
        Object result = f.call("abc");
        XtendFacadeTest.assertEquals((Object)v1.getValue(), (Object)result);
    }

    private static String qualified(String extensionFileName) {
        return "org::eclipse::gmf::tests::xtend::" + extensionFileName;
    }
}

