/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.tests.runtime.common.ui.services.action.internal.filter;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.AbstractOperation;
import org.eclipse.core.commands.operations.IOperationHistory;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.gmf.runtime.common.core.service.IOperation;
import org.eclipse.gmf.runtime.common.core.service.IProvider;
import org.eclipse.gmf.runtime.common.core.service.IProviderChangeListener;
import org.eclipse.gmf.runtime.common.core.service.IProviderPolicy;
import org.eclipse.gmf.runtime.common.core.service.ProviderPriority;
import org.eclipse.gmf.runtime.common.core.service.Service;
import org.eclipse.gmf.runtime.common.ui.action.ActionManager;
import org.eclipse.gmf.runtime.common.ui.services.action.filter.AbstractActionFilterProvider;
import org.eclipse.gmf.runtime.common.ui.services.action.filter.ActionFilterService;
import org.eclipse.gmf.runtime.common.ui.services.action.filter.TestAttributeOperation;

public class ActionFilterServiceTest
extends TestCase {
    private Fixture fixture = null;

    public ActionFilterServiceTest(String name) {
        super(name);
    }

    public static void main(String[] args) {
        TestRunner.run((Test)ActionFilterServiceTest.suite());
    }

    public static Test suite() {
        return new TestSuite(ActionFilterServiceTest.class);
    }

    protected Fixture getFixture() {
        return this.fixture;
    }

    private void setFixture(Fixture fixture) {
        this.fixture = fixture;
    }

    protected void setUp() throws Exception {
        this.setFixture(new Fixture());
    }

    public void test_testAttribute() {
        String prefix = "@";
        String zero = "zero";
        String one = "one";
        ActionFilterServiceTest.assertTrue((!this.getFixture().testAttribute(zero, String.valueOf(prefix) + this.getName(), zero) ? 1 : 0) != 0);
        IOperationHistory history = ActionManager.getDefault().getOperationHistory();
        AbstractOperation operation = new AbstractOperation("ActionFilterServiceTest"){

            public IStatus execute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                return Status.OK_STATUS;
            }

            public IStatus redo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                return Status.OK_STATUS;
            }

            public IStatus undo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                return Status.OK_STATUS;
            }
        };
        ActionFilterProvider provider0 = new ActionFilterProvider(this.getName(), zero);
        Fixture.ProviderDescriptor providerDescriptor0 = new Fixture.ProviderDescriptor((IProvider)provider0);
        this.getFixture().addFixtureProvider(ProviderPriority.HIGHEST, (Service.ProviderDescriptor)providerDescriptor0);
        ActionFilterServiceTest.assertTrue((!this.getFixture().testAttribute(zero, String.valueOf(prefix) + this.getName(), zero) ? 1 : 0) != 0);
        try {
            history.execute((IUndoableOperation)operation, (IProgressMonitor)new NullProgressMonitor(), null);
        }
        catch (ExecutionException e) {
            ActionFilterServiceTest.fail((String)("command execution failed: " + e.getLocalizedMessage()));
        }
        history.dispose(IOperationHistory.GLOBAL_UNDO_CONTEXT, true, true, false);
        ActionFilterServiceTest.assertTrue((boolean)this.getFixture().testAttribute(zero, String.valueOf(prefix) + this.getName(), zero));
        ActionFilterServiceTest.assertTrue((boolean)this.getFixture().testAttribute(one, String.valueOf(prefix) + this.getName(), zero));
        try {
            history.execute((IUndoableOperation)operation, (IProgressMonitor)new NullProgressMonitor(), null);
        }
        catch (ExecutionException e) {
            ActionFilterServiceTest.fail((String)("command execution failed: " + e.getLocalizedMessage()));
        }
        history.dispose(IOperationHistory.GLOBAL_UNDO_CONTEXT, true, true, false);
        ActionFilterServiceTest.assertTrue((!this.getFixture().testAttribute(one, String.valueOf(prefix) + this.getName(), zero) ? 1 : 0) != 0);
        ActionFilterServiceTest.assertTrue((!this.getFixture().testAttribute(one, String.valueOf(prefix) + this.getName(), one) ? 1 : 0) != 0);
        ActionFilterProvider provider1 = new ActionFilterProvider(this.getName(), one);
        Fixture.ProviderDescriptor providerDescriptor1 = new Fixture.ProviderDescriptor((IProvider)provider1);
        this.getFixture().addFixtureProvider(ProviderPriority.LOWEST, (Service.ProviderDescriptor)providerDescriptor1);
        ActionFilterServiceTest.assertTrue((!this.getFixture().testAttribute(one, String.valueOf(prefix) + this.getName(), one) ? 1 : 0) != 0);
        try {
            history.execute((IUndoableOperation)operation, (IProgressMonitor)new NullProgressMonitor(), null);
        }
        catch (ExecutionException e) {
            ActionFilterServiceTest.fail((String)("command execution failed: " + e.getLocalizedMessage()));
        }
        history.dispose(IOperationHistory.GLOBAL_UNDO_CONTEXT, true, true, false);
        ActionFilterServiceTest.assertTrue((boolean)this.getFixture().testAttribute(one, String.valueOf(prefix) + this.getName(), one));
        ActionFilterServiceTest.assertTrue((boolean)this.getFixture().testAttribute(zero, String.valueOf(prefix) + this.getName(), one));
        try {
            history.execute((IUndoableOperation)operation, (IProgressMonitor)new NullProgressMonitor(), null);
        }
        catch (ExecutionException e) {
            ActionFilterServiceTest.fail((String)("command execution failed: " + e.getLocalizedMessage()));
        }
        history.dispose(IOperationHistory.GLOBAL_UNDO_CONTEXT, true, true, false);
        ActionFilterServiceTest.assertTrue((!this.getFixture().testAttribute(zero, String.valueOf(prefix) + this.getName(), one) ? 1 : 0) != 0);
        ActionFilterServiceTest.assertTrue((boolean)this.getFixture().testAttribute(zero, String.valueOf(prefix) + this.getName(), zero));
        this.getFixture().removeFixtureProvider((Service.ProviderDescriptor)providerDescriptor0);
        ActionFilterServiceTest.assertTrue((boolean)this.getFixture().testAttribute(zero, String.valueOf(prefix) + this.getName(), zero));
        try {
            history.execute((IUndoableOperation)operation, (IProgressMonitor)new NullProgressMonitor(), null);
        }
        catch (ExecutionException e) {
            ActionFilterServiceTest.fail((String)("command execution failed: " + e.getLocalizedMessage()));
        }
        history.dispose(IOperationHistory.GLOBAL_UNDO_CONTEXT, true, true, false);
        ActionFilterServiceTest.assertTrue((!this.getFixture().testAttribute(zero, String.valueOf(prefix) + this.getName(), zero) ? 1 : 0) != 0);
    }

    public class ActionFilterProvider
    extends AbstractActionFilterProvider {
        private final String name;
        private final String value;

        protected ActionFilterProvider(String name, String value) {
            this.name = name;
            this.value = value;
        }

        protected String getName() {
            return this.name;
        }

        protected String getValue() {
            return this.value;
        }

        public boolean provides(IOperation operation) {
            TestAttributeOperation tao = (TestAttributeOperation)operation;
            return tao.getName().equals(this.getName()) && tao.getValue().equals(this.getValue());
        }

        public boolean testAttribute(Object target, String nam, String val) {
            return String.valueOf(target).equals(val);
        }
    }

    protected static class Fixture
    extends ActionFilterService {
        protected Fixture() {
        }

        protected void addFixtureProvider(ProviderPriority priority, Service.ProviderDescriptor provider) {
            super.addProvider(priority, provider);
        }

        protected void removeFixtureProvider(Service.ProviderDescriptor provider) {
            super.removeProvider(provider);
        }

        protected static class ProviderDescriptor
        extends ActionFilterService.ProviderDescriptor {
            protected ProviderDescriptor(IProvider provider) {
                super(null);
                this.provider = provider;
                provider.addProviderChangeListener((IProviderChangeListener)this);
            }

            public IProvider getProvider() {
                return this.provider;
            }

            protected IProviderPolicy getPolicy() {
                return null;
            }

            public boolean provides(IOperation operation) {
                return this.getProvider().provides(operation);
            }
        }
    }
}

