/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.tests.runtime.common.core.internal.command;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.AbstractOperation;
import org.eclipse.core.commands.operations.IOperationHistory;
import org.eclipse.core.commands.operations.IUndoContext;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.commands.operations.OperationHistoryFactory;
import org.eclipse.core.commands.operations.UndoContext;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.gmf.runtime.common.core.command.AbstractCommand;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.CompositeCommand;

public class CompositeCommandTest
extends TestCase {
    private IOperationHistory history;
    private static IStatus ERROR_STATUS = new Status(4, "error", 1, "no message", null);

    public static void main(String[] args) {
        TestRunner.run((Test)CompositeCommandTest.suite());
    }

    public static Test suite() {
        return new TestSuite(CompositeCommandTest.class);
    }

    public CompositeCommandTest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.history = OperationHistoryFactory.getOperationHistory();
    }

    protected void fail(Exception e) {
        e.printStackTrace();
        CompositeCommandTest.fail((String)("Should not have thrown: " + e.getLocalizedMessage()));
    }

    public void test_contexts() {
        CompositeCommand composite = new CompositeCommand("Composite");
        UndoContext ctx1 = new UndoContext();
        UndoContext ctx2 = new UndoContext();
        UndoContext ctx3 = new UndoContext();
        TestCommand child1 = new TestCommand();
        TestCommand child2 = new TestCommand();
        TestCommand child3 = new TestCommand();
        child1.addContext((IUndoContext)ctx1);
        child2.addContext((IUndoContext)ctx2);
        child2.addContext((IUndoContext)ctx1);
        child3.addContext((IUndoContext)ctx3);
        CompositeCommandTest.assertEquals((Object)Collections.EMPTY_LIST, Arrays.asList(composite.getContexts()));
        composite.add((IUndoableOperation)child1);
        CompositeCommandTest.assertEquals(Arrays.asList(ctx1), Arrays.asList(composite.getContexts()));
        composite.add((IUndoableOperation)child2);
        CompositeCommandTest.assertEquals(Arrays.asList(ctx1, ctx2), Arrays.asList(composite.getContexts()));
        composite.add((IUndoableOperation)child3);
        CompositeCommandTest.assertEquals(Arrays.asList(ctx1, ctx2, ctx3), Arrays.asList(composite.getContexts()));
        composite.remove((IUndoableOperation)child2);
        CompositeCommandTest.assertEquals(Arrays.asList(ctx1, ctx3), Arrays.asList(composite.getContexts()));
        composite.remove((IUndoableOperation)child1);
        CompositeCommandTest.assertEquals(Arrays.asList(ctx3), Arrays.asList(composite.getContexts()));
        composite.remove((IUndoableOperation)child3);
        CompositeCommandTest.assertEquals((Object)Collections.EMPTY_LIST, Arrays.asList(composite.getContexts()));
    }

    public void test_contexts_listIterator() {
        CompositeCommand composite = new CompositeCommand("Composite");
        UndoContext ctx1 = new UndoContext();
        UndoContext ctx2 = new UndoContext();
        UndoContext ctx3 = new UndoContext();
        TestCommand child1 = new TestCommand();
        TestCommand child2 = new TestCommand();
        TestCommand child3 = new TestCommand();
        child1.addContext((IUndoContext)ctx1);
        child2.addContext((IUndoContext)ctx2);
        child2.addContext((IUndoContext)ctx1);
        child3.addContext((IUndoContext)ctx3);
        ListIterator iter = composite.listIterator();
        CompositeCommandTest.assertEquals((Object)Collections.EMPTY_LIST, Arrays.asList(composite.getContexts()));
        iter.add(child1);
        CompositeCommandTest.assertEquals(Arrays.asList(ctx1), Arrays.asList(composite.getContexts()));
        iter.add(child2);
        CompositeCommandTest.assertEquals(Arrays.asList(ctx1, ctx2), Arrays.asList(composite.getContexts()));
        iter.add(child3);
        CompositeCommandTest.assertEquals(Arrays.asList(ctx1, ctx2, ctx3), Arrays.asList(composite.getContexts()));
        iter.previous();
        iter.previous();
        iter.remove();
        CompositeCommandTest.assertEquals(Arrays.asList(ctx1, ctx3), Arrays.asList(composite.getContexts()));
        iter.previous();
        iter.remove();
        CompositeCommandTest.assertEquals(Arrays.asList(ctx3), Arrays.asList(composite.getContexts()));
        iter.next();
        iter.remove();
        CompositeCommandTest.assertEquals((Object)Collections.EMPTY_LIST, Arrays.asList(composite.getContexts()));
    }

    public void test_canUndo() {
        UndoContext ctx = new UndoContext();
        CompositeCommand composite = new CompositeCommand("Composite");
        CompositeCommand composite2 = new CompositeCommand("Composite");
        composite.add((IUndoableOperation)new TestCommand());
        composite.add((IUndoableOperation)new TestCommand());
        composite.add((IUndoableOperation)composite2);
        composite.add((IUndoableOperation)new TestCommand());
        composite2.add((IUndoableOperation)new TestCommand());
        composite2.add((IUndoableOperation)new TestCommand(true, false));
        composite2.add((IUndoableOperation)new TestCommand());
        composite.addContext((IUndoContext)ctx);
        CompositeCommandTest.assertTrue((boolean)composite.canExecute());
        try {
            this.history.execute((IUndoableOperation)composite, (IProgressMonitor)new NullProgressMonitor(), null);
        }
        catch (ExecutionException e) {
            this.fail((Exception)((Object)e));
        }
        CompositeCommandTest.assertFalse((boolean)composite.canUndo());
        CompositeCommandTest.assertFalse((boolean)this.history.canUndo((IUndoContext)ctx));
    }

    public void test_canRedo() {
        UndoContext ctx = new UndoContext();
        CompositeCommand composite = new CompositeCommand("Composite");
        CompositeCommand composite2 = new CompositeCommand("Composite");
        composite.add((IUndoableOperation)new TestCommand());
        composite.add((IUndoableOperation)new TestCommand());
        composite.add((IUndoableOperation)composite2);
        composite.add((IUndoableOperation)new TestCommand());
        composite2.add((IUndoableOperation)new TestCommand());
        composite2.add((IUndoableOperation)new TestCommand(true, true, false));
        composite2.add((IUndoableOperation)new TestCommand());
        composite.addContext((IUndoContext)ctx);
        CompositeCommandTest.assertTrue((boolean)composite.canExecute());
        try {
            this.history.execute((IUndoableOperation)composite, (IProgressMonitor)new NullProgressMonitor(), null);
        }
        catch (ExecutionException e) {
            this.fail((Exception)((Object)e));
        }
        CompositeCommandTest.assertTrue((boolean)composite.canUndo());
        CompositeCommandTest.assertTrue((boolean)this.history.canUndo((IUndoContext)ctx));
        try {
            this.history.undo((IUndoContext)ctx, (IProgressMonitor)new NullProgressMonitor(), null);
        }
        catch (ExecutionException e) {
            this.fail((Exception)((Object)e));
        }
        CompositeCommandTest.assertFalse((boolean)composite.canRedo());
        CompositeCommandTest.assertFalse((boolean)this.history.canRedo((IUndoContext)ctx));
    }

    public void test_execute_undo_redo() {
        UndoContext ctx = new UndoContext();
        CompositeCommand composite = new CompositeCommand("Composite");
        TestCommand child1 = new TestCommand();
        TestCommand child2 = new TestCommand();
        TestCommand child3 = new TestCommand();
        composite.add((IUndoableOperation)child1);
        composite.add((IUndoableOperation)child2);
        composite.add((IUndoableOperation)child3);
        try {
            composite.addContext((IUndoContext)ctx);
            this.history.execute((IUndoableOperation)composite, (IProgressMonitor)new NullProgressMonitor(), null);
        }
        catch (ExecutionException e) {
            this.fail((Exception)((Object)e));
        }
        child1.assertExecuted();
        child2.assertExecuted();
        child3.assertExecuted();
        CommandResult result = composite.getCommandResult();
        IStatus status = result.getStatus();
        CompositeCommandTest.assertTrue((boolean)status.isOK());
        Object returnValue = result.getReturnValue();
        CompositeCommandTest.assertTrue((boolean)(returnValue instanceof Collection));
        Collection collection = (Collection)returnValue;
        CompositeCommandTest.assertEquals((int)3, (int)collection.size());
        CompositeCommandTest.assertTrue((boolean)collection.contains(child1.getCommandResult().getReturnValue()));
        CompositeCommandTest.assertTrue((boolean)collection.contains(child2.getCommandResult().getReturnValue()));
        CompositeCommandTest.assertTrue((boolean)collection.contains(child3.getCommandResult().getReturnValue()));
        try {
            CompositeCommandTest.assertTrue((boolean)this.history.canUndo((IUndoContext)ctx));
            this.history.undo((IUndoContext)ctx, (IProgressMonitor)new NullProgressMonitor(), null);
        }
        catch (ExecutionException e) {
            this.fail((Exception)((Object)e));
        }
        child1.assertUndone();
        child2.assertUndone();
        child3.assertUndone();
        result = composite.getCommandResult();
        status = result.getStatus();
        CompositeCommandTest.assertTrue((boolean)status.isOK());
        returnValue = result.getReturnValue();
        CompositeCommandTest.assertTrue((boolean)(returnValue instanceof Collection));
        collection = (Collection)returnValue;
        CompositeCommandTest.assertEquals((int)3, (int)collection.size());
        CompositeCommandTest.assertTrue((boolean)collection.contains(child1.getCommandResult().getReturnValue()));
        CompositeCommandTest.assertTrue((boolean)collection.contains(child2.getCommandResult().getReturnValue()));
        CompositeCommandTest.assertTrue((boolean)collection.contains(child3.getCommandResult().getReturnValue()));
        try {
            CompositeCommandTest.assertTrue((boolean)this.history.canRedo((IUndoContext)ctx));
            this.history.redo((IUndoContext)ctx, (IProgressMonitor)new NullProgressMonitor(), null);
        }
        catch (ExecutionException e) {
            this.fail((Exception)((Object)e));
        }
        child1.assertRedone();
        child2.assertRedone();
        child3.assertRedone();
        result = composite.getCommandResult();
        status = result.getStatus();
        CompositeCommandTest.assertTrue((boolean)status.isOK());
        returnValue = result.getReturnValue();
        CompositeCommandTest.assertTrue((boolean)(returnValue instanceof Collection));
        collection = (Collection)returnValue;
        CompositeCommandTest.assertEquals((int)3, (int)collection.size());
        CompositeCommandTest.assertTrue((boolean)collection.contains(child1.getCommandResult().getReturnValue()));
        CompositeCommandTest.assertTrue((boolean)collection.contains(child2.getCommandResult().getReturnValue()));
        CompositeCommandTest.assertTrue((boolean)collection.contains(child3.getCommandResult().getReturnValue()));
    }

    public void test_execute_error() {
        UndoContext ctx = new UndoContext();
        CompositeCommand composite = new CompositeCommand("Composite");
        MarkerOperation marker1 = new MarkerOperation();
        composite.add((IUndoableOperation)marker1);
        FailCancelOperation c = new FailCancelOperation(ERROR_STATUS, Status.OK_STATUS, Status.OK_STATUS, false);
        composite.add((IUndoableOperation)c);
        MarkerOperation marker2 = new MarkerOperation();
        composite.add((IUndoableOperation)marker2);
        IStatus status = null;
        try {
            composite.addContext((IUndoContext)ctx);
            status = this.history.execute((IUndoableOperation)composite, (IProgressMonitor)new NullProgressMonitor(), null);
        }
        catch (ExecutionException e) {
            this.fail((Exception)((Object)e));
        }
        CompositeCommandTest.assertTrue((boolean)marker1.wasExecuted);
        CompositeCommandTest.assertFalse((boolean)marker2.wasExecuted);
        CompositeCommandTest.assertTrue((boolean)marker1.wasUndone);
        CompositeCommandTest.assertEquals((int)4, (int)status.getSeverity());
    }

    public void test_execute_cancel() {
        UndoContext ctx = new UndoContext();
        CompositeCommand composite = new CompositeCommand("Composite");
        MarkerOperation marker1 = new MarkerOperation();
        composite.add((IUndoableOperation)marker1);
        FailCancelOperation op = new FailCancelOperation(Status.CANCEL_STATUS, Status.OK_STATUS, Status.OK_STATUS, false);
        composite.add((IUndoableOperation)op);
        MarkerOperation marker2 = new MarkerOperation();
        composite.add((IUndoableOperation)marker2);
        IStatus status = null;
        try {
            composite.addContext((IUndoContext)ctx);
            status = this.history.execute((IUndoableOperation)composite, (IProgressMonitor)new NullProgressMonitor(), null);
        }
        catch (ExecutionException e) {
            this.fail((Exception)((Object)e));
        }
        CompositeCommandTest.assertTrue((boolean)marker1.wasExecuted);
        CompositeCommandTest.assertFalse((boolean)marker2.wasExecuted);
        CompositeCommandTest.assertTrue((boolean)marker1.wasUndone);
        CompositeCommandTest.assertEquals((int)8, (int)status.getSeverity());
    }

    public void test_execute_cancelMonitor() {
        UndoContext ctx = new UndoContext();
        CompositeCommand composite = new CompositeCommand("Composite");
        MarkerOperation marker1 = new MarkerOperation();
        composite.add((IUndoableOperation)marker1);
        FailCancelOperation op = new FailCancelOperation(Status.CANCEL_STATUS, Status.OK_STATUS, Status.OK_STATUS, true);
        composite.add((IUndoableOperation)op);
        MarkerOperation marker2 = new MarkerOperation();
        composite.add((IUndoableOperation)marker2);
        IStatus status = null;
        try {
            composite.addContext((IUndoContext)ctx);
            status = this.history.execute((IUndoableOperation)composite, (IProgressMonitor)new NullProgressMonitor(), null);
        }
        catch (ExecutionException e) {
            this.fail((Exception)((Object)e));
        }
        CompositeCommandTest.assertTrue((boolean)marker1.wasExecuted);
        CompositeCommandTest.assertFalse((boolean)marker2.wasExecuted);
        CompositeCommandTest.assertTrue((boolean)marker1.wasUndone);
        CompositeCommandTest.assertEquals((int)8, (int)status.getSeverity());
    }

    public void test_undo_error() {
        UndoContext ctx = new UndoContext();
        CompositeCommand composite = new CompositeCommand("Composite");
        MarkerOperation marker1 = new MarkerOperation();
        composite.add((IUndoableOperation)marker1);
        FailCancelOperation op = new FailCancelOperation(Status.OK_STATUS, ERROR_STATUS, Status.OK_STATUS, false);
        composite.add((IUndoableOperation)op);
        MarkerOperation marker2 = new MarkerOperation();
        composite.add((IUndoableOperation)marker2);
        IStatus status = null;
        try {
            composite.addContext((IUndoContext)ctx);
            status = this.history.execute((IUndoableOperation)composite, (IProgressMonitor)new NullProgressMonitor(), null);
        }
        catch (ExecutionException e) {
            this.fail((Exception)((Object)e));
        }
        CompositeCommandTest.assertTrue((boolean)marker1.wasExecuted);
        CompositeCommandTest.assertTrue((boolean)marker2.wasExecuted);
        CompositeCommandTest.assertFalse((boolean)marker1.wasUndone);
        CompositeCommandTest.assertEquals((int)0, (int)status.getSeverity());
        marker1.reset();
        marker2.reset();
        try {
            status = this.history.undo((IUndoContext)ctx, (IProgressMonitor)new NullProgressMonitor(), null);
        }
        catch (ExecutionException e) {
            this.fail((Exception)((Object)e));
        }
        CompositeCommandTest.assertFalse((boolean)marker1.wasUndone);
        CompositeCommandTest.assertTrue((boolean)marker2.wasUndone);
        CompositeCommandTest.assertTrue((boolean)marker2.wasRedone);
        CompositeCommandTest.assertEquals((int)4, (int)status.getSeverity());
    }

    public void test_undo_cancel() {
        UndoContext ctx = new UndoContext();
        CompositeCommand composite = new CompositeCommand("Composite");
        MarkerOperation marker1 = new MarkerOperation();
        composite.add((IUndoableOperation)marker1);
        FailCancelOperation op = new FailCancelOperation(Status.OK_STATUS, Status.CANCEL_STATUS, Status.OK_STATUS, false);
        composite.add((IUndoableOperation)op);
        MarkerOperation marker2 = new MarkerOperation();
        composite.add((IUndoableOperation)marker2);
        IStatus status = null;
        try {
            composite.addContext((IUndoContext)ctx);
            status = this.history.execute((IUndoableOperation)composite, (IProgressMonitor)new NullProgressMonitor(), null);
        }
        catch (ExecutionException e) {
            this.fail((Exception)((Object)e));
        }
        CompositeCommandTest.assertTrue((boolean)marker1.wasExecuted);
        CompositeCommandTest.assertTrue((boolean)marker2.wasExecuted);
        CompositeCommandTest.assertFalse((boolean)marker1.wasUndone);
        CompositeCommandTest.assertEquals((int)0, (int)status.getSeverity());
        marker1.reset();
        marker2.reset();
        try {
            status = this.history.undo((IUndoContext)ctx, (IProgressMonitor)new NullProgressMonitor(), null);
        }
        catch (ExecutionException e) {
            this.fail((Exception)((Object)e));
        }
        CompositeCommandTest.assertFalse((boolean)marker1.wasUndone);
        CompositeCommandTest.assertTrue((boolean)marker2.wasUndone);
        CompositeCommandTest.assertTrue((boolean)marker2.wasRedone);
        CompositeCommandTest.assertEquals((int)8, (int)status.getSeverity());
    }

    public void test_undo_cancelMonitor() {
        UndoContext ctx = new UndoContext();
        CompositeCommand composite = new CompositeCommand("Composite");
        MarkerOperation marker1 = new MarkerOperation();
        composite.add((IUndoableOperation)marker1);
        FailCancelOperation op = new FailCancelOperation(Status.OK_STATUS, Status.CANCEL_STATUS, Status.OK_STATUS, true);
        composite.add((IUndoableOperation)op);
        MarkerOperation marker2 = new MarkerOperation();
        composite.add((IUndoableOperation)marker2);
        IStatus status = null;
        try {
            composite.addContext((IUndoContext)ctx);
            status = this.history.execute((IUndoableOperation)composite, (IProgressMonitor)new NullProgressMonitor(), null);
        }
        catch (ExecutionException e) {
            this.fail((Exception)((Object)e));
        }
        CompositeCommandTest.assertTrue((boolean)marker1.wasExecuted);
        CompositeCommandTest.assertTrue((boolean)marker2.wasExecuted);
        CompositeCommandTest.assertFalse((boolean)marker1.wasUndone);
        CompositeCommandTest.assertEquals((int)0, (int)status.getSeverity());
        marker1.reset();
        marker2.reset();
        try {
            status = this.history.undo((IUndoContext)ctx, (IProgressMonitor)new NullProgressMonitor(), null);
        }
        catch (ExecutionException e) {
            this.fail((Exception)((Object)e));
        }
        CompositeCommandTest.assertFalse((boolean)marker1.wasUndone);
        CompositeCommandTest.assertTrue((boolean)marker2.wasUndone);
        CompositeCommandTest.assertTrue((boolean)marker2.wasRedone);
        CompositeCommandTest.assertEquals((int)8, (int)status.getSeverity());
    }

    public void test_redo_error() {
        UndoContext ctx = new UndoContext();
        CompositeCommand composite = new CompositeCommand("Composite");
        MarkerOperation marker1 = new MarkerOperation();
        composite.add((IUndoableOperation)marker1);
        FailCancelOperation op = new FailCancelOperation(Status.OK_STATUS, Status.OK_STATUS, ERROR_STATUS, false);
        composite.add((IUndoableOperation)op);
        MarkerOperation marker2 = new MarkerOperation();
        composite.add((IUndoableOperation)marker2);
        IStatus status = null;
        try {
            composite.addContext((IUndoContext)ctx);
            status = this.history.execute((IUndoableOperation)composite, (IProgressMonitor)new NullProgressMonitor(), null);
        }
        catch (ExecutionException e) {
            this.fail((Exception)((Object)e));
        }
        CompositeCommandTest.assertTrue((boolean)marker1.wasExecuted);
        CompositeCommandTest.assertTrue((boolean)marker2.wasExecuted);
        CompositeCommandTest.assertFalse((boolean)marker1.wasUndone);
        CompositeCommandTest.assertEquals((int)0, (int)status.getSeverity());
        marker1.reset();
        marker2.reset();
        try {
            status = this.history.undo((IUndoContext)ctx, (IProgressMonitor)new NullProgressMonitor(), null);
        }
        catch (ExecutionException e) {
            this.fail((Exception)((Object)e));
        }
        CompositeCommandTest.assertTrue((boolean)marker1.wasUndone);
        CompositeCommandTest.assertTrue((boolean)marker2.wasUndone);
        CompositeCommandTest.assertFalse((boolean)marker2.wasRedone);
        CompositeCommandTest.assertEquals((int)0, (int)status.getSeverity());
        marker1.reset();
        marker2.reset();
        try {
            status = this.history.redo((IUndoContext)ctx, (IProgressMonitor)new NullProgressMonitor(), null);
        }
        catch (ExecutionException e) {
            this.fail((Exception)((Object)e));
        }
        CompositeCommandTest.assertTrue((boolean)marker1.wasRedone);
        CompositeCommandTest.assertFalse((boolean)marker2.wasRedone);
        CompositeCommandTest.assertTrue((boolean)marker1.wasUndone);
        CompositeCommandTest.assertEquals((int)4, (int)status.getSeverity());
    }

    public void test_redo_cancel() {
        UndoContext ctx = new UndoContext();
        CompositeCommand composite = new CompositeCommand("Composite");
        MarkerOperation marker1 = new MarkerOperation();
        composite.add((IUndoableOperation)marker1);
        FailCancelOperation op = new FailCancelOperation(Status.OK_STATUS, Status.OK_STATUS, Status.CANCEL_STATUS, false);
        composite.add((IUndoableOperation)op);
        MarkerOperation marker2 = new MarkerOperation();
        composite.add((IUndoableOperation)marker2);
        IStatus status = null;
        try {
            composite.addContext((IUndoContext)ctx);
            status = this.history.execute((IUndoableOperation)composite, (IProgressMonitor)new NullProgressMonitor(), null);
        }
        catch (ExecutionException e) {
            this.fail((Exception)((Object)e));
        }
        CompositeCommandTest.assertTrue((boolean)marker1.wasExecuted);
        CompositeCommandTest.assertTrue((boolean)marker2.wasExecuted);
        CompositeCommandTest.assertFalse((boolean)marker1.wasUndone);
        CompositeCommandTest.assertEquals((int)0, (int)status.getSeverity());
        marker1.reset();
        marker2.reset();
        try {
            status = this.history.undo((IUndoContext)ctx, (IProgressMonitor)new NullProgressMonitor(), null);
        }
        catch (ExecutionException e) {
            this.fail((Exception)((Object)e));
        }
        CompositeCommandTest.assertTrue((boolean)marker1.wasUndone);
        CompositeCommandTest.assertTrue((boolean)marker2.wasUndone);
        CompositeCommandTest.assertFalse((boolean)marker2.wasRedone);
        CompositeCommandTest.assertEquals((int)0, (int)status.getSeverity());
        marker1.reset();
        marker2.reset();
        try {
            status = this.history.redo((IUndoContext)ctx, (IProgressMonitor)new NullProgressMonitor(), null);
        }
        catch (ExecutionException e) {
            this.fail((Exception)((Object)e));
        }
        CompositeCommandTest.assertTrue((boolean)marker1.wasRedone);
        CompositeCommandTest.assertFalse((boolean)marker2.wasRedone);
        CompositeCommandTest.assertTrue((boolean)marker1.wasUndone);
        CompositeCommandTest.assertEquals((int)8, (int)status.getSeverity());
    }

    public void test_redo_cancelMonitor() {
        UndoContext ctx = new UndoContext();
        CompositeCommand composite = new CompositeCommand("Composite");
        MarkerOperation marker1 = new MarkerOperation();
        composite.add((IUndoableOperation)marker1);
        FailCancelOperation op = new FailCancelOperation(Status.OK_STATUS, Status.OK_STATUS, Status.CANCEL_STATUS, true);
        composite.add((IUndoableOperation)op);
        MarkerOperation marker2 = new MarkerOperation();
        composite.add((IUndoableOperation)marker2);
        IStatus status = null;
        try {
            composite.addContext((IUndoContext)ctx);
            status = this.history.execute((IUndoableOperation)composite, (IProgressMonitor)new NullProgressMonitor(), null);
        }
        catch (ExecutionException e) {
            this.fail((Exception)((Object)e));
        }
        CompositeCommandTest.assertTrue((boolean)marker1.wasExecuted);
        CompositeCommandTest.assertTrue((boolean)marker2.wasExecuted);
        CompositeCommandTest.assertFalse((boolean)marker1.wasUndone);
        CompositeCommandTest.assertEquals((int)0, (int)status.getSeverity());
        marker1.reset();
        marker2.reset();
        try {
            status = this.history.undo((IUndoContext)ctx, (IProgressMonitor)new NullProgressMonitor(), null);
        }
        catch (ExecutionException e) {
            this.fail((Exception)((Object)e));
        }
        CompositeCommandTest.assertTrue((boolean)marker1.wasUndone);
        CompositeCommandTest.assertTrue((boolean)marker2.wasUndone);
        CompositeCommandTest.assertFalse((boolean)marker2.wasRedone);
        CompositeCommandTest.assertEquals((int)0, (int)status.getSeverity());
        marker1.reset();
        marker2.reset();
        try {
            status = this.history.redo((IUndoContext)ctx, (IProgressMonitor)new NullProgressMonitor(), null);
        }
        catch (ExecutionException e) {
            this.fail((Exception)((Object)e));
        }
        CompositeCommandTest.assertTrue((boolean)marker1.wasRedone);
        CompositeCommandTest.assertFalse((boolean)marker2.wasRedone);
        CompositeCommandTest.assertTrue((boolean)marker1.wasUndone);
        CompositeCommandTest.assertEquals((int)8, (int)status.getSeverity());
    }

    private static class FailCancelOperation
    extends AbstractOperation {
        private IStatus executeStatus;
        private IStatus undoStatus;
        private IStatus redoStatus;
        private boolean cancelMonitor;

        FailCancelOperation(IStatus exec, IStatus undo, IStatus redo, boolean cancel) {
            super("Fail/Cancel Operation");
            this.executeStatus = exec;
            this.undoStatus = undo;
            this.redoStatus = redo;
            this.cancelMonitor = cancel;
        }

        public IStatus execute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
            if (this.executeStatus.getSeverity() == 8 && this.cancelMonitor) {
                monitor.setCanceled(true);
                return Status.OK_STATUS;
            }
            return this.executeStatus;
        }

        public IStatus undo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
            if (this.undoStatus.getSeverity() == 8 && this.cancelMonitor) {
                monitor.setCanceled(true);
                return Status.OK_STATUS;
            }
            return this.undoStatus;
        }

        public IStatus redo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
            if (this.redoStatus.getSeverity() == 8 && this.cancelMonitor) {
                monitor.setCanceled(true);
                return Status.OK_STATUS;
            }
            return this.redoStatus;
        }
    }

    static class MarkerOperation
    extends AbstractOperation {
        boolean wasExecuted;
        boolean wasUndone;
        boolean wasRedone;

        MarkerOperation() {
            super("Marker operation");
        }

        void reset() {
            this.wasExecuted = false;
            this.wasUndone = false;
            this.wasRedone = false;
        }

        public IStatus execute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
            this.wasExecuted = true;
            return Status.OK_STATUS;
        }

        public IStatus undo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
            this.wasUndone = true;
            return Status.OK_STATUS;
        }

        public IStatus redo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
            this.wasRedone = true;
            return Status.OK_STATUS;
        }
    }

    protected static class TestCommand
    extends AbstractCommand {
        private boolean executed;
        private boolean undone;
        private boolean redone;
        private final boolean isExecutable;
        private final boolean isUndoable;
        private final boolean isRedoable;

        public TestCommand() {
            this(true, true, true, null);
        }

        public TestCommand(List affectedFiles) {
            this(true, true, true, affectedFiles);
        }

        public TestCommand(boolean isExecutable) {
            this(isExecutable, true, true, null);
        }

        public TestCommand(boolean isExecutable, boolean isUndoable) {
            this(isExecutable, isUndoable, true, null);
        }

        public TestCommand(boolean isExecutable, boolean isUndoable, boolean isRedoable) {
            this(isExecutable, isUndoable, isRedoable, null);
        }

        public TestCommand(boolean isExecutable, boolean isUndoable, boolean isRedoable, List affectedFiles) {
            super("TestCommand", affectedFiles);
            this.isExecutable = isExecutable;
            this.isUndoable = isUndoable;
            this.isRedoable = isRedoable;
        }

        public boolean canExecute() {
            return this.isExecutable;
        }

        public boolean canUndo() {
            return this.isUndoable;
        }

        public boolean canRedo() {
            return this.isRedoable;
        }

        protected CommandResult doExecuteWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
            this.executed = true;
            this.undone = false;
            this.redone = false;
            return CommandResult.newOKCommandResult((Object)((Object)this));
        }

        protected CommandResult doRedoWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
            this.executed = false;
            this.undone = false;
            this.redone = true;
            return CommandResult.newOKCommandResult((Object)((Object)this));
        }

        protected CommandResult doUndoWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
            this.executed = false;
            this.undone = true;
            this.redone = false;
            return CommandResult.newOKCommandResult((Object)((Object)this));
        }

        public void assertExecuted() {
            CompositeCommandTest.assertTrue((boolean)this.executed);
            CompositeCommandTest.assertFalse((boolean)this.undone);
            CompositeCommandTest.assertFalse((boolean)this.redone);
            CompositeCommandTest.assertEquals((int)0, (int)this.getCommandResult().getStatus().getSeverity());
            CompositeCommandTest.assertSame((Object)((Object)this), (Object)this.getCommandResult().getReturnValue());
        }

        public void assertUndone() {
            CompositeCommandTest.assertTrue((boolean)this.undone);
            CompositeCommandTest.assertFalse((boolean)this.executed);
            CompositeCommandTest.assertFalse((boolean)this.redone);
            CompositeCommandTest.assertEquals((int)0, (int)this.getCommandResult().getStatus().getSeverity());
            CompositeCommandTest.assertSame((Object)((Object)this), (Object)this.getCommandResult().getReturnValue());
        }

        public void assertRedone() {
            CompositeCommandTest.assertTrue((boolean)this.redone);
            CompositeCommandTest.assertFalse((boolean)this.undone);
            CompositeCommandTest.assertFalse((boolean)this.executed);
            CompositeCommandTest.assertEquals((int)0, (int)this.getCommandResult().getStatus().getSeverity());
            CompositeCommandTest.assertSame((Object)((Object)this), (Object)this.getCommandResult().getReturnValue());
        }
    }
}

