/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.lite.edit.parts.decorations;

import org.eclipse.draw2d.DelegatingLayout;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.Locator;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gmf.runtime.lite.edit.parts.decorations.AbstractDecorationManager;

public class PaneDecorationManager
extends AbstractDecorationManager {
    public PaneDecorationManager(IFigure decorationParent) {
        super(decorationParent);
        decorationParent.setLayoutManager((LayoutManager)new DelegatingLayout());
    }

    protected Object getConstraint(String key, IFigure decoration) {
        return new DecorationLocator(this.getDecorationPosition(key));
    }

    protected int getDecorationPosition(String key) {
        return 9;
    }

    private class DecorationLocator
    implements Locator {
        private final int myPosition;

        public DecorationLocator(int position) {
            this.myPosition = position;
        }

        public void relocate(IFigure target) {
            Rectangle bounds = PaneDecorationManager.this.getDecorationParent().getBounds().getCopy();
            Dimension size = target.getPreferredSize();
            Point pt = bounds.getTopLeft();
            switch (this.myPosition & 0x18) {
                case 8: {
                    break;
                }
                case 0: 
                case 24: {
                    pt.x += (bounds.width - size.width) / 2;
                    break;
                }
                case 16: {
                    pt.x += bounds.width - size.width;
                }
            }
            switch (this.myPosition & 5) {
                case 1: {
                    break;
                }
                case 0: 
                case 5: {
                    pt.y += (bounds.height - size.height) / 2;
                    break;
                }
                case 4: {
                    pt.y += bounds.height - size.height;
                }
            }
            target.setBounds(new Rectangle(pt, size));
        }
    }
}

