/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.draw2d.ui.render.internal;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.gmf.runtime.draw2d.ui.render.RenderInfo;
import org.eclipse.gmf.runtime.draw2d.ui.render.RenderedImage;
import org.eclipse.gmf.runtime.draw2d.ui.render.internal.DrawableRenderedImage;
import org.eclipse.gmf.runtime.draw2d.ui.render.internal.RenderingListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;

public class RenderHelper {
    double scale = 1.0;
    boolean scaleTargetCoordinates = true;
    boolean allowDelayRender = false;
    private Dimension maximumRenderSize = null;
    private static Map threadMap = new HashMap();
    private static final int RENDER_TOLERANCE = 5;

    private RenderHelper(double scale, boolean scaleTargetCoordinates, boolean allowDelayRender, Dimension maximumRenderSize) {
        this.scale = scale;
        this.allowDelayRender = allowDelayRender;
        this.scaleTargetCoordinates = scaleTargetCoordinates;
        this.maximumRenderSize = maximumRenderSize;
    }

    public static RenderHelper getInstance(double scale, boolean scaleDrawable, boolean allowDelayRender, Dimension maximumRenderSize) {
        return new RenderHelper(scale, scaleDrawable, allowDelayRender, maximumRenderSize);
    }

    private boolean shouldScaleTargetCoordinates() {
        return this.scaleTargetCoordinates;
    }

    private boolean shouldAllowDelayRender() {
        return this.allowDelayRender;
    }

    private double getScale() {
        return this.scale;
    }

    private Dimension getMaximumRenderSize() {
        return this.maximumRenderSize;
    }

    private boolean renderSWTImage(RenderedImage srcImage, final RenderingListener listener) {
        if (srcImage.isRendered()) {
            return true;
        }
        Thread existingThread = (Thread)threadMap.get(listener);
        if (existingThread != null) {
            existingThread.interrupt();
            threadMap.remove(listener);
        }
        final RenderedImage rndImg = srcImage;
        Thread renderThread = new Thread(new Runnable(){

            public void run() {
                Image img = null;
                try {
                    img = rndImg.getSWTImage();
                }
                catch (RuntimeException e) {
                    threadMap.remove(listener);
                    throw e;
                }
                if (img != null) {
                    listener.imageRendered(rndImg);
                }
                threadMap.remove(listener);
            }
        });
        threadMap.put(listener, renderThread);
        renderThread.start();
        return false;
    }

    public RenderedImage drawRenderedImage(Graphics g, RenderedImage srcImage, org.eclipse.draw2d.geometry.Rectangle rect, RenderingListener listener) {
        org.eclipse.draw2d.geometry.Rectangle targetRect = rect.getCopy();
        if (this.shouldScaleTargetCoordinates()) {
            targetRect.performScale(this.getScale());
        }
        if (g instanceof DrawableRenderedImage) {
            return ((DrawableRenderedImage)g).drawRenderedImage(srcImage, targetRect, listener);
        }
        org.eclipse.draw2d.geometry.Rectangle sourceRect = rect.getCopy();
        sourceRect.performScale(this.getScale());
        RenderedImage trgImage = this.calculateTargetImage(srcImage, sourceRect);
        if (!this.shouldAllowDelayRender() || this.renderSWTImage(trgImage, listener)) {
            Image swtImg = trgImage.getSWTImage();
            if (swtImg != null) {
                Rectangle imgBox = swtImg.getBounds();
                g.drawImage(swtImg, 0, 0, imgBox.width, imgBox.height, targetRect.x, targetRect.y, targetRect.width, targetRect.height);
            }
        } else {
            if (srcImage.isRendered()) {
                Image swtImg = srcImage.getSWTImage();
                Rectangle imgBox = swtImg.getBounds();
                g.drawImage(swtImg, 0, 0, imgBox.width, imgBox.height, targetRect.x, targetRect.y, targetRect.width, targetRect.height);
                return srcImage;
            }
            listener.paintFigureWhileRendering(g);
        }
        return trgImage;
    }

    private RenderedImage calculateTargetImage(RenderedImage srcImage, org.eclipse.draw2d.geometry.Rectangle sourceRect) {
        RenderedImage trgImage = srcImage;
        RenderInfo info = trgImage.getRenderInfo();
        if (Math.abs(sourceRect.width - info.getWidth()) > 5 || Math.abs(sourceRect.height - info.getHeight()) > 5) {
            info.setValues(sourceRect.width, sourceRect.height, info.shouldMaintainAspectRatio(), info.shouldAntiAlias(), info.getBackgroundColor(), info.getForegroundColor());
            trgImage = srcImage.getNewRenderedImage(info);
            info = trgImage.getRenderInfo();
        }
        if (this.getMaximumRenderSize() == null) {
            return trgImage;
        }
        if (sourceRect.width > this.getMaximumRenderSize().width || sourceRect.height > this.getMaximumRenderSize().height) {
            double ratio;
            if (sourceRect.width > this.getMaximumRenderSize().width) {
                ratio = (double)sourceRect.height / (double)sourceRect.width;
                sourceRect.width = this.getMaximumRenderSize().width;
                sourceRect.height = (int)Math.round((double)sourceRect.width * ratio);
            }
            if (sourceRect.height > this.getMaximumRenderSize().height) {
                ratio = (double)sourceRect.width / (double)sourceRect.height;
                sourceRect.height = this.getMaximumRenderSize().height;
                sourceRect.width = (int)Math.round((double)sourceRect.height * ratio);
            }
            info.setValues(sourceRect.width, sourceRect.height, info.shouldMaintainAspectRatio(), info.shouldAntiAlias(), info.getBackgroundColor(), info.getForegroundColor());
            trgImage = srcImage.getNewRenderedImage(info);
            info = trgImage.getRenderInfo();
        }
        return trgImage;
    }
}

