/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.diagram.ui.actions.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.draw2d.Animation;
import org.eclipse.draw2d.XYLayout;
import org.eclipse.gef.ConnectionEditPart;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.tools.ToolUtilities;
import org.eclipse.gmf.runtime.diagram.ui.actions.DiagramAction;
import org.eclipse.gmf.runtime.diagram.ui.actions.internal.l10n.DiagramUIActionsMessages;
import org.eclipse.gmf.runtime.diagram.ui.actions.internal.l10n.DiagramUIActionsPluginImages;
import org.eclipse.gmf.runtime.diagram.ui.editparts.CompartmentEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.GroupEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ShapeCompartmentEditPart;
import org.eclipse.gmf.runtime.diagram.ui.internal.editparts.IEditableEditPart;
import org.eclipse.gmf.runtime.diagram.ui.requests.ArrangeRequest;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.ui.IWorkbenchPage;

public class ArrangeAction
extends DiagramAction {
    private boolean selectionOnly;

    protected ArrangeAction(IWorkbenchPage workbenchPage, boolean selectionOnly) {
        super(workbenchPage);
        this.selectionOnly = selectionOnly;
    }

    protected Request createTargetRequest() {
        return new ArrangeRequest(this.getId());
    }

    protected void updateTargetRequest() {
        ArrangeRequest request = (ArrangeRequest)this.getTargetRequest();
        request.setPartsToArrange(this.getOperationSet());
    }

    private boolean isArrangeAll() {
        return !this.selectionOnly;
    }

    protected Command getCommand() {
        List operationSet = this.getOperationSet();
        if (operationSet.isEmpty()) {
            return null;
        }
        CompoundCommand arrangeCC = new CompoundCommand(this.getLabel());
        if (this.isArrangeAll()) {
            for (EditPart element : operationSet) {
                Command cmd = element.getCommand(this.getTargetRequest());
                if (cmd == null) continue;
                arrangeCC.add(cmd);
            }
        } else {
            Command cmd;
            EditPart targetEP = this.getTargetEditPartForArrangeSelection(operationSet);
            if (targetEP != null && (cmd = targetEP.getCommand(this.getTargetRequest())) != null) {
                arrangeCC.add(cmd);
            }
        }
        return arrangeCC;
    }

    private EditPart getTargetEditPartForArrangeSelection(List editparts) {
        if (editparts.size() == 1) {
            return ((EditPart)editparts.get(0)).getTargetEditPart(this.getTargetRequest());
        }
        EditPart parentEP = this.getSelectionParent(editparts);
        if (parentEP == null) {
            return null;
        }
        int i = 1;
        while (i < editparts.size()) {
            EditPart part = (EditPart)editparts.get(i);
            if (!(part instanceof ConnectionEditPart) && part.getParent() != parentEP) {
                return null;
            }
            ++i;
        }
        return parentEP;
    }

    protected List createOperationSet() {
        List selection = this.getSelectedObjects();
        if (this.isArrangeAll()) {
            if (!selection.isEmpty()) {
                return this.createOperationSetForArrangeAll(selection);
            }
            if (this.getDiagramEditPart() != null) {
                return this.getDiagramEditPart().getChildren();
            }
            return Collections.EMPTY_LIST;
        }
        if (selection.isEmpty() || !(selection.get(0) instanceof IGraphicalEditPart)) {
            return Collections.EMPTY_LIST;
        }
        selection = ToolUtilities.getSelectionWithoutDependants((List)selection);
        return selection;
    }

    private EditPart getSelectionParent(List editparts) {
        ListIterator li = editparts.listIterator();
        while (li.hasNext()) {
            Object obj = li.next();
            if (obj instanceof ConnectionEditPart || !(obj instanceof EditPart)) continue;
            return ((EditPart)obj).getParent();
        }
        return null;
    }

    protected boolean isSelectionListener() {
        return true;
    }

    public static ArrangeAction createArrangeAllAction(IWorkbenchPage workbenchPage) {
        ArrangeAction action = new ArrangeAction(workbenchPage, false);
        action.setId("arrangeAllAction");
        action.setText(DiagramUIActionsMessages.ArrangeAction_ArrangeAll_ActionLabelText);
        action.setToolTipText(DiagramUIActionsMessages.ArrangeAction_ArrangeAll_ActionToolTipText);
        action.setImageDescriptor(DiagramUIActionsPluginImages.DESC_ARRANGE_ALL);
        action.setDisabledImageDescriptor(DiagramUIActionsPluginImages.DESC_ARRANGE_ALL_DISABLED);
        action.setHoverImageDescriptor(DiagramUIActionsPluginImages.DESC_ARRANGE_ALL);
        return action;
    }

    public static ArrangeAction createToolbarArrangeAllAction(IWorkbenchPage workbenchPage) {
        ArrangeAction action = new ArrangeAction(workbenchPage, false);
        action.setId("toolbarArrangeAllAction");
        action.setText(DiagramUIActionsMessages.ArrangeAction_toolbar_ArrangeAll_ActionLabelText);
        action.setToolTipText(DiagramUIActionsMessages.ArrangeAction_toolbar_ArrangeAll_ActionToolTipText);
        action.setImageDescriptor(DiagramUIActionsPluginImages.DESC_ARRANGE_ALL);
        action.setDisabledImageDescriptor(DiagramUIActionsPluginImages.DESC_ARRANGE_ALL_DISABLED);
        action.setHoverImageDescriptor(DiagramUIActionsPluginImages.DESC_ARRANGE_ALL);
        return action;
    }

    public static ArrangeAction createArrangeSelectionAction(IWorkbenchPage workbenchPage) {
        ArrangeAction action = new ArrangeAction(workbenchPage, true);
        action.setId("arrangeSelectionAction");
        action.setText(DiagramUIActionsMessages.ArrangeAction_ArrangeSelection_ActionLabelText);
        action.setToolTipText(DiagramUIActionsMessages.ArrangeAction_ArrangeSelection_ActionToolTipText);
        action.setImageDescriptor(DiagramUIActionsPluginImages.DESC_ARRANGE_SELECTED);
        action.setDisabledImageDescriptor(DiagramUIActionsPluginImages.DESC_ARRANGE_SELECTED_DISABLED);
        action.setHoverImageDescriptor(DiagramUIActionsPluginImages.DESC_ARRANGE_SELECTED);
        return action;
    }

    public static ArrangeAction createToolbarArrangeSelectionAction(IWorkbenchPage workbenchPage) {
        ArrangeAction action = new ArrangeAction(workbenchPage, true);
        action.setId("toolbarArrangeSelectionAction");
        action.setText(DiagramUIActionsMessages.ArrangeAction_toolbar_ArrangeSelection_ActionLabelText);
        action.setToolTipText(DiagramUIActionsMessages.ArrangeAction_toolbar_ArrangeSelection_ActionToolTipText);
        action.setImageDescriptor(DiagramUIActionsPluginImages.DESC_ARRANGE_SELECTED);
        action.setDisabledImageDescriptor(DiagramUIActionsPluginImages.DESC_ARRANGE_SELECTED_DISABLED);
        action.setHoverImageDescriptor(DiagramUIActionsPluginImages.DESC_ARRANGE_SELECTED);
        return action;
    }

    protected void doRun(IProgressMonitor progressMonitor) {
        IPreferenceStore preferenceStore = (IPreferenceStore)this.getDiagramEditPart().getDiagramPreferencesHint().getPreferenceStore();
        boolean animatedLayout = preferenceStore.getBoolean("Global.enableAnimatedLayout");
        if (animatedLayout) {
            Animation.markBegin();
        }
        super.doRun(progressMonitor);
        if (animatedLayout) {
            int durationInc = 800;
            int factor = 10;
            int size = 0;
            List operationSet = this.getOperationSet();
            if (this.isArrangeAll()) {
                for (IGraphicalEditPart element : operationSet) {
                    size += element.getFigure().getChildren().size();
                }
            } else if (operationSet != null && !operationSet.isEmpty()) {
                IGraphicalEditPart container = (IGraphicalEditPart)this.getSelectionParent(operationSet);
                size += container.getFigure().getChildren().size();
            }
            int totalDuration = Math.min(durationInc * factor / 2, Math.max(durationInc, size / factor * durationInc));
            Animation.run((int)totalDuration);
        }
    }

    private List createOperationSetForArrangeAll(List selection) {
        HashSet parentsSet = new HashSet();
        for (Object element : selection) {
            EditPart gEditPart;
            EditPart parentEditPart;
            if (element instanceof ShapeCompartmentEditPart || element instanceof DiagramEditPart) {
                parentsSet.add(element);
                continue;
            }
            if (!(element instanceof EditPart) || !((parentEditPart = (gEditPart = (EditPart)element).getParent()) instanceof ShapeCompartmentEditPart) && !(parentEditPart instanceof DiagramEditPart) || parentsSet.contains(parentEditPart)) continue;
            parentsSet.add(parentEditPart);
        }
        if (parentsSet.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        ArrayList elements = new ArrayList();
        elements.addAll(parentsSet);
        return elements;
    }

    public String getLabel() {
        return this.isArrangeAll() ? DiagramUIActionsMessages.ArrangeAction_toolbar_ArrangeAll_ActionLabelText : DiagramUIActionsMessages.ArrangeAction_toolbar_ArrangeSelection_ActionLabelText;
    }

    protected boolean calculateEnabled() {
        List operationSet = this.getOperationSet();
        if (this.isArrangeAll() && !operationSet.isEmpty()) {
            return true;
        }
        EditPart parentEP = this.getSelectionParent(operationSet);
        if (parentEP instanceof IEditableEditPart && !((IEditableEditPart)parentEP).isEditModeEnabled()) {
            return false;
        }
        for (Object next : operationSet) {
            if (!(next instanceof IEditableEditPart) || ((IEditableEditPart)next).isEditModeEnabled()) continue;
            return false;
        }
        if (operationSet.size() >= 2) {
            GraphicalEditPart parent;
            if (parentEP instanceof GraphicalEditPart && (parent = (GraphicalEditPart)parentEP) != null && parent.getContentPane().getLayoutManager() instanceof XYLayout) {
                return true;
            }
        } else if (operationSet.size() == 1) {
            if (operationSet.get(0) instanceof GroupEditPart) {
                return true;
            }
            EditPart host = (EditPart)operationSet.get(0);
            for (Object childEP : host.getChildren()) {
                if (!(childEP instanceof CompartmentEditPart) || !(((CompartmentEditPart)childEP).getContentPane().getLayoutManager() instanceof XYLayout)) continue;
                return true;
            }
        }
        return false;
    }
}

