/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.map.editor.part;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.common.util.URI;
import org.eclipse.gmf.map.editor.part.GMFMapCreationWizardPage;
import org.eclipse.gmf.map.editor.part.GMFMapDiagramEditorPlugin;
import org.eclipse.gmf.map.editor.part.GMFMapDiagramEditorUtil;
import org.eclipse.gmf.mappings.Mapping;
import org.eclipse.gmf.mappings.presentation.MapRefModelPages;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.actions.WorkspaceModifyOperation;

public class GMFMapCreationWizard
extends Wizard
implements INewWizard {
    private IWorkbench workbench;
    protected IStructuredSelection selection;
    protected GMFMapCreationWizardPage page;
    protected URI diagramURI;
    private boolean openNewlyCreatedDiagramEditor = true;
    protected MapRefModelPages refPages;

    public IWorkbench getWorkbench() {
        return this.workbench;
    }

    public IStructuredSelection getSelection() {
        return this.selection;
    }

    public final URI getDiagramURI() {
        return this.diagramURI;
    }

    public final boolean isOpenNewlyCreatedDiagramEditor() {
        return this.openNewlyCreatedDiagramEditor;
    }

    public void setOpenNewlyCreatedDiagramEditor(boolean openNewlyCreatedDiagramEditor) {
        this.openNewlyCreatedDiagramEditor = openNewlyCreatedDiagramEditor;
    }

    public void addPages() {
        super.addPages();
        if (this.page == null) {
            this.page = new GMFMapCreationWizardPage("Initial", this.getSelection());
        }
        this.addPage((IWizardPage)this.page);
        this.refPages.addPages((Wizard)this, (ISelection)this.selection);
    }

    public boolean performFinish() {
        WorkspaceModifyOperation op = new WorkspaceModifyOperation(null){

            protected void execute(IProgressMonitor monitor) throws CoreException, InterruptedException {
                GMFMapCreationWizard.this.diagramURI = GMFMapDiagramEditorUtil.createAndOpenDiagram(GMFMapCreationWizard.this.page.getDiagramFileCreator(), GMFMapCreationWizard.this.page.getContainerFullPath(), GMFMapCreationWizard.this.page.getFileName(), GMFMapCreationWizard.this.page.getInitialContents(), "GMFMap", GMFMapCreationWizard.this.getWorkbench().getActiveWorkbenchWindow(), monitor, GMFMapCreationWizard.this.isOpenNewlyCreatedDiagramEditor(), true);
            }
        };
        try {
            this.getContainer().run(false, true, (IRunnableWithProgress)op);
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        catch (InvocationTargetException e) {
            if (e.getTargetException() instanceof CoreException) {
                ErrorDialog.openError((Shell)this.getContainer().getShell(), (String)"Creation Problems", null, (IStatus)((CoreException)e.getTargetException()).getStatus());
            } else {
                GMFMapDiagramEditorPlugin.getInstance().logError("Error creating diagram", e.getTargetException());
            }
            return false;
        }
        return this.diagramURI != null;
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.workbench = workbench;
        this.selection = selection;
        this.setWindowTitle("New GMFMap Diagram");
        this.setDefaultPageImageDescriptor(GMFMapDiagramEditorPlugin.getBundledImageDescriptor("icons/wizban/NewGMFMapWizard.gif"));
        this.setNeedsProgressMonitor(true);
        this.refPages = new MapRefModelPages(true, null);
    }

    public Mapping createInitialModel() {
        return this.refPages.createMapping();
    }
}

