/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.internal.bridge.transform;

import java.io.IOException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.emf.codegen.ecore.genmodel.GenModel;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.gmf.codegen.gmfgen.GenEditorGenerator;
import org.eclipse.gmf.graphdef.codegen.MapModeCodeGenStrategy;
import org.eclipse.gmf.internal.bridge.VisualIdentifierDispenser;
import org.eclipse.gmf.internal.bridge.genmodel.BasicDiagramRunTimeModelHelper;
import org.eclipse.gmf.internal.bridge.genmodel.DiagramGenModelTransformer;
import org.eclipse.gmf.internal.bridge.genmodel.DiagramRunTimeModelHelper;
import org.eclipse.gmf.internal.bridge.genmodel.GenModelProducer;
import org.eclipse.gmf.internal.bridge.genmodel.InnerClassViewmapProducer;
import org.eclipse.gmf.internal.bridge.genmodel.ViewmapProducer;
import org.eclipse.gmf.internal.bridge.naming.gen.GenModelNamingMediator;
import org.eclipse.gmf.internal.bridge.naming.gen.GenNamingMediatorImpl;
import org.eclipse.gmf.internal.bridge.transform.GenModelDetector;
import org.eclipse.gmf.internal.bridge.transform.Messages;
import org.eclipse.gmf.internal.bridge.transform.StaleGenModelDetector;
import org.eclipse.gmf.internal.bridge.transform.TransformOptions;
import org.eclipse.gmf.internal.bridge.transform.ValidationHelper;
import org.eclipse.gmf.internal.bridge.transform.VisualIdentifierDispenserProvider;
import org.eclipse.gmf.internal.bridge.ui.Plugin;
import org.eclipse.gmf.internal.codegen.util.GMFGenConfig;
import org.eclipse.gmf.internal.common.migrate.ModelLoadHelper;
import org.eclipse.gmf.internal.common.reconcile.Reconciler;
import org.eclipse.gmf.internal.common.reconcile.ReconcilerConfig;
import org.eclipse.gmf.mappings.Mapping;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TransformToGenModelOperation {
    private URI myGMFGenModelURI;
    private TransformOptions myOptions;
    private Mapping myMapping;
    private GenModelDetector myGMDetector;
    private GenModel myGenModel;
    private Diagnostic myMapmodelValidationResult = Diagnostic.CANCEL_INSTANCE;
    private Diagnostic myGMFGenValidationResult = Diagnostic.CANCEL_INSTANCE;
    private IStatus myStaleGenmodelStatus = Status.CANCEL_STATUS;
    private final ResourceSet myResourceSet;

    public TransformToGenModelOperation(ResourceSet rs) {
        assert (rs != null);
        this.myResourceSet = rs;
        this.myOptions = new TransformOptions();
    }

    public TransformOptions getOptions() {
        return this.myOptions;
    }

    public URI getGenURI() {
        return this.myGMFGenModelURI;
    }

    public void setGenURI(URI gmfGen) {
        this.myGMFGenModelURI = gmfGen;
    }

    public GenModel getGenModel() {
        return this.myGenModel;
    }

    public final ResourceSet getResourceSet() {
        return this.myResourceSet;
    }

    Mapping getMapping() {
        return this.myMapping;
    }

    private void setMapping(Mapping m, Diagnostic validationResult) {
        this.myMapping = m;
        this.myMapmodelValidationResult = validationResult;
        this.myGMDetector = m != null ? new GenModelDetector(m) : null;
        this.myGenModel = null;
    }

    private void setGMFGenValidationResult(Diagnostic validationResult) {
        this.myGMFGenValidationResult = validationResult;
    }

    public GenModelDetector getGenModelDetector() {
        return this.myGMDetector;
    }

    public Diagnostic getGMFGenValidationResult() {
        return this.myGMFGenValidationResult;
    }

    public Diagnostic getMapmodelValidationResult() {
        return this.myMapmodelValidationResult;
    }

    public IStatus getStaleGenmodelStatus() {
        return this.myStaleGenmodelStatus;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Mapping loadMappingModel(URI uri, IProgressMonitor pm) throws CoreException {
        Mapping mapping;
        block10: {
            Mapping content = null;
            IStatus status = Status.CANCEL_STATUS;
            Diagnostic validation = Diagnostic.CANCEL_INSTANCE;
            SubProgressMonitor monitor = null;
            try {
                if (uri == null) {
                    throw new IllegalArgumentException(Messages.TransformToGenModelOperation_e_null_map_uri);
                }
                monitor = pm != null ? new SubProgressMonitor(pm, 1, 4) : new NullProgressMonitor();
                String cancelMessage = Messages.TransformToGenModelOperation_e_map_load_cancelled;
                monitor.beginTask("", 100);
                TransformToGenModelOperation.subTask((IProgressMonitor)monitor, 0, Messages.TransformToGenModelOperation_task_load, cancelMessage);
                ModelLoadHelper loadHelper = new ModelLoadHelper(this.getResourceSet(), uri);
                if (!loadHelper.isOK()) {
                    throw new CoreException(loadHelper.getStatus());
                }
                TransformToGenModelOperation.subTask((IProgressMonitor)monitor, 20, Messages.TransformToGenModelOperation_task_validate, cancelMessage);
                EObject root = loadHelper.getContentsRoot();
                if (!(root instanceof Mapping)) {
                    String msg = MessageFormat.format(Messages.TransformToGenModelOperation_e_wrong_root_element, root.getClass().getName());
                    status = Plugin.createError(msg, null);
                    throw new CoreException(status);
                }
                content = (Mapping)loadHelper.getContentsRoot();
                validation = ValidationHelper.validate((EObject)content, true, (IProgressMonitor)monitor);
                monitor.worked(60);
                if (8 == validation.getSeverity()) {
                    throw new CoreException(Plugin.createCancel(cancelMessage));
                }
                mapping = content;
                this.setMapping(content, validation);
                if (monitor == null) break block10;
            }
            catch (CoreException e) {
                try {
                    throw e;
                    catch (Exception e2) {
                        IStatus error = Plugin.createError(Messages.TransformToGenModelOperation_e_load_mapping_model, e2);
                        throw new CoreException(error);
                    }
                }
                catch (Throwable throwable) {
                    this.setMapping(content, validation);
                    if (monitor != null) {
                        monitor.done();
                    }
                    throw throwable;
                }
            }
            monitor.done();
        }
        return mapping;
    }

    public GenModel findGenmodel() throws CoreException {
        try {
            this.checkMapping();
            GenModelDetector gmd = this.getGenModelDetector();
            IStatus detect = gmd.detect();
            if (detect.isOK()) {
                GenModel genModel;
                this.myGenModel = genModel = gmd.get(this.getResourceSet());
                return genModel;
            }
            throw new CoreException(detect);
        }
        catch (Exception e) {
            IStatus error = Plugin.createError(Messages.TransformToGenModelOperation_e_mapping_invalid, e);
            throw new CoreException(error);
        }
    }

    public GenModel loadGenModel(URI uri, IProgressMonitor pm) throws CoreException {
        SubProgressMonitor monitor = null;
        try {
            this.checkMapping();
            monitor = pm != null ? new SubProgressMonitor(pm, 1, 4) : new NullProgressMonitor();
            String cancelMessage = Messages.TransformToGenModelOperation_e_genmodel_load_cancelled;
            monitor.beginTask("", 100);
            monitor.subTask(Messages.TransformToGenModelOperation_task_detect);
            GenModelDetector gmd = this.getGenModelDetector();
            IStatus status = Status.OK_STATUS;
            status = uri == null ? gmd.detect() : gmd.advise(uri);
            if (!status.isOK()) {
                throw new CoreException(status);
            }
            TransformToGenModelOperation.subTask((IProgressMonitor)monitor, 30, Messages.TransformToGenModelOperation_task_load, cancelMessage);
            GenModel genModel = gmd.get(this.getResourceSet());
            if (genModel == null) {
                if (uri == null) {
                    this.myStaleGenmodelStatus = Status.CANCEL_STATUS;
                    this.myGenModel = null;
                    return null;
                }
                IStatus notFound = Plugin.createError(Messages.GenModelDetector_e_not_found, null);
                throw new CoreException(notFound);
            }
            TransformToGenModelOperation.subTask((IProgressMonitor)monitor, 40, Messages.TransformToGenModelOperation_task_validate, cancelMessage);
            StaleGenModelDetector staleDetector = new StaleGenModelDetector(genModel);
            IStatus stale = staleDetector.detect();
            this.myGenModel = genModel;
            this.myStaleGenmodelStatus = stale;
            GenModel genModel2 = genModel;
            return genModel2;
        }
        catch (CoreException e) {
            throw e;
        }
        catch (Exception e) {
            IStatus error = Plugin.createError(Messages.TransformToGenModelOperation_e_genmodel_load, e);
            throw new CoreException(error);
        }
        finally {
            if (monitor != null) {
                monitor.done();
            }
        }
    }

    public IStatus executeTransformation(IProgressMonitor pm) {
        SubProgressMonitor monitor = null;
        Diagnostic validation = Diagnostic.CANCEL_INSTANCE;
        try {
            if (this.getGenURI() == null) {
                throw new IllegalStateException(Messages.TransformToGenModelOperation_e_null_gmfgen_uri);
            }
            this.checkMapping();
            monitor = pm != null ? new SubProgressMonitor(pm, 1, 4) : new NullProgressMonitor();
            monitor.beginTask("", 100);
            if (monitor.isCanceled()) {
                IStatus iStatus = Status.CANCEL_STATUS;
                return iStatus;
            }
            DiagramRunTimeModelHelper drtModelHelper = this.detectRunTimeModel();
            ViewmapProducer viewmapProducer = this.detectTransformationOptions();
            VisualIdentifierDispenserProvider idDispenser = this.getVisualIdDispenser();
            idDispenser.acquire();
            GenModelProducer t = this.createGenModelProducer(this.getGenModel(), drtModelHelper, viewmapProducer, idDispenser.get());
            monitor.subTask(Messages.TransformToGenModelOperation_task_generate);
            GenEditorGenerator genEditor = t.process(this.getMapping(), (IProgressMonitor)new SubProgressMonitor((IProgressMonitor)monitor, 20));
            if (monitor.isCanceled()) {
                IStatus iStatus = Status.CANCEL_STATUS;
                return iStatus;
            }
            monitor.subTask(Messages.TransformToGenModelOperation_task_reconcile);
            if (Plugin.needsReconcile()) {
                this.reconcile(genEditor);
            }
            GenNamingMediatorImpl namer = new GenNamingMediatorImpl();
            namer.setMode(GenNamingMediatorImpl.Mode.COLLECT_NAMES);
            namer.traverse(genEditor);
            namer.setMode(GenNamingMediatorImpl.Mode.DISPENSE_NAMES);
            namer.traverse(genEditor);
            monitor.worked(20);
            if (monitor.isCanceled()) {
                IStatus iStatus = Status.CANCEL_STATUS;
                return iStatus;
            }
            monitor.subTask(Messages.TransformToGenModelOperation_task_save);
            this.save(genEditor);
            monitor.worked(20);
            if (monitor.isCanceled()) {
                IStatus iStatus = Status.CANCEL_STATUS;
                return iStatus;
            }
            monitor.subTask(Messages.TransformToGenModelOperation_task_validate);
            try {
                validation = ValidationHelper.validate((EObject)genEditor, true, (IProgressMonitor)monitor);
            }
            catch (RuntimeException re) {
                validation = BasicDiagnostic.toDiagnostic((Throwable)re);
            }
            if (8 != validation.getSeverity()) {
                idDispenser.release();
            }
            IStatus iStatus = Status.OK_STATUS;
            return iStatus;
        }
        catch (Exception ex) {
            String message = ex.getMessage();
            if (message == null) {
                message = Messages.TransformToGenModelOperation_e_generator_creation;
            }
            IStatus iStatus = Plugin.createError(message, ex);
            return iStatus;
        }
        finally {
            this.setGMFGenValidationResult(validation);
            if (monitor != null) {
                monitor.done();
            }
        }
    }

    private void checkMapping() {
        if (this.getMapping() == null) {
            throw new IllegalStateException(Messages.TransformToGenModelOperation_e_null_mapping);
        }
    }

    static IStatus getFirst(Diagnostic d) {
        if (d == null) {
            return Status.OK_STATUS;
        }
        List children = d.getChildren();
        if (children.isEmpty()) {
            return BasicDiagnostic.toIStatus((Diagnostic)d);
        }
        return BasicDiagnostic.toIStatus((Diagnostic)((Diagnostic)children.get(0)));
    }

    private DiagramRunTimeModelHelper detectRunTimeModel() {
        return new BasicDiagramRunTimeModelHelper();
    }

    private ViewmapProducer detectTransformationOptions() {
        URL[] uRLArray;
        String runtimeToken = this.getOptions().getUseRuntimeFigures() ? "full" : "lite";
        MapModeCodeGenStrategy mmStrategy = this.getOptions().getUseMapMode() ? MapModeCodeGenStrategy.DYNAMIC : MapModeCodeGenStrategy.STATIC;
        URL dynamicFigureTemplates = this.getOptions().getFigureTemplatesPath();
        if (dynamicFigureTemplates == null) {
            uRLArray = null;
        } else {
            URL[] uRLArray2 = new URL[1];
            uRLArray = uRLArray2;
            uRLArray2[0] = dynamicFigureTemplates;
        }
        return new InnerClassViewmapProducer(runtimeToken, mmStrategy, uRLArray);
    }

    private VisualIdentifierDispenserProvider getVisualIdDispenser() {
        return new VisualIdentifierDispenserProvider(this.getGenURI());
    }

    private GenModelProducer createGenModelProducer(GenModel domainGenModel, DiagramRunTimeModelHelper drtModelHelper, ViewmapProducer viewmapProducer, VisualIdentifierDispenser idDespenser) {
        final DiagramGenModelTransformer t = new DiagramGenModelTransformer(drtModelHelper, (GenModelNamingMediator)new GenModelNamingMediator.Empty(), viewmapProducer, idDespenser, this.getOptions().getGenerateRCP());
        if (domainGenModel != null) {
            t.setEMFGenModel(domainGenModel);
        }
        return new GenModelProducer(){

            public GenEditorGenerator process(Mapping mapping, IProgressMonitor progress) {
                progress.beginTask(null, 1);
                try {
                    t.transform(mapping);
                    GenEditorGenerator genEditorGenerator = t.getResult();
                    return genEditorGenerator;
                }
                finally {
                    progress.done();
                }
            }
        };
    }

    private void reconcile(GenEditorGenerator genBurdern) {
        GenEditorGenerator old = null;
        Resource resource = null;
        try {
            try {
                resource = this.getResourceSet().getResource(this.getGenURI(), true);
                EList contents = resource.getContents();
                if (!contents.isEmpty() && contents.get(0) instanceof GenEditorGenerator) {
                    old = (GenEditorGenerator)contents.get(0);
                }
                if (old != null) {
                    new Reconciler((ReconcilerConfig)new GMFGenConfig()).reconcileTree((EObject)genBurdern, (EObject)old);
                }
            }
            catch (RuntimeException runtimeException) {
                old = null;
                if (resource != null) {
                    resource.unload();
                }
            }
        }
        finally {
            if (resource != null) {
                resource.unload();
            }
        }
    }

    private void save(GenEditorGenerator genBurdern) throws IOException {
        try {
            Resource gmfgenRes = this.getResourceSet().getResource(this.getGenURI(), true);
            TransformToGenModelOperation.updateExistingResource(gmfgenRes, genBurdern);
            Map<String, Object> saveOptions = this.getSaveOptions();
            if (gmfgenRes.getContents().size() > 1 && Plugin.ignoreDanglingHrefOnSave()) {
                saveOptions.put("PROCESS_DANGLING_HREF", "RECORD");
            }
            gmfgenRes.save(saveOptions);
        }
        catch (RuntimeException runtimeException) {
            Resource dgmmRes = this.getResourceSet().createResource(this.getGenURI());
            dgmmRes.getContents().add((Object)genBurdern);
            dgmmRes.save(this.getSaveOptions());
        }
    }

    private static void updateExistingResource(Resource gmfgenRes, GenEditorGenerator genBurden) {
        boolean editorGenFound = false;
        int i = 0;
        while (!editorGenFound && i < gmfgenRes.getContents().size()) {
            if (gmfgenRes.getContents().get(i) instanceof GenEditorGenerator) {
                if (gmfgenRes.getContents().size() > 1) {
                    LinkedList<EObject> rest = new LinkedList<EObject>((Collection<EObject>)gmfgenRes.getContents());
                    GenEditorGenerator oldEditorGenerator = (GenEditorGenerator)rest.remove(i);
                    TransformToGenModelOperation.updateExternalReferences(genBurden, oldEditorGenerator, rest);
                }
                gmfgenRes.getContents().set(i, (Object)genBurden);
                editorGenFound = true;
            }
            ++i;
        }
        if (!editorGenFound) {
            gmfgenRes.getContents().add((Object)genBurden);
        }
    }

    private static void updateExternalReferences(GenEditorGenerator newEditorGenerator, final GenEditorGenerator oldEditorGenerator, List<EObject> allContentButOldGenerator) {
        final Map<EObject, Collection<EStructuralFeature.Setting>> crossReferences = new EcoreUtil.ExternalCrossReferencer(allContentButOldGenerator){

            protected boolean crossReference(EObject object, EReference reference, EObject crossReferencedEObject) {
                return super.crossReference(object, reference, crossReferencedEObject) && EcoreUtil.isAncestor((EObject)oldEditorGenerator, (EObject)crossReferencedEObject);
            }

            Map<EObject, Collection<EStructuralFeature.Setting>> find() {
                return this.findExternalCrossReferences();
            }
        }.find();
        new Reconciler((ReconcilerConfig)new GMFGenConfig()){

            protected void handleNotMatchedCurrent(EObject current) {
            }

            protected EObject handleNotMatchedOld(EObject currentParent, EObject notMatchedOld) {
                return null;
            }

            protected void reconcileVertex(EObject current, EObject old) {
                if (!crossReferences.containsKey(old)) {
                    return;
                }
                for (EStructuralFeature.Setting s : (Collection)crossReferences.get(old)) {
                    EcoreUtil.replace((EStructuralFeature.Setting)s, (Object)old, (Object)current);
                }
            }
        }.reconcileTree((EObject)newEditorGenerator, (EObject)oldEditorGenerator);
    }

    private Map<String, Object> getSaveOptions() {
        HashMap<String, Object> saveOptions = new HashMap<String, Object>();
        saveOptions.put("ENCODING", "UTF-8");
        return saveOptions;
    }

    private static void subTask(IProgressMonitor monitor, int ticks, String name, String cancelMessage) throws CoreException {
        if (monitor == null) {
            return;
        }
        if (monitor.isCanceled()) {
            IStatus cancel = Plugin.createCancel(cancelMessage);
            throw new CoreException(cancel);
        }
        if (ticks > 0) {
            monitor.worked(ticks);
        }
        if (name != null) {
            monitor.subTask(name);
        }
    }
}

