/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.ecore.expressions;

import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EEnumLiteral;
import org.eclipse.emf.ecore.ETypedElement;
import org.eclipse.emf.ocl.expressions.ExpressionsFactory;
import org.eclipse.emf.ocl.expressions.OCLExpression;
import org.eclipse.emf.ocl.expressions.OperationCallExp;
import org.eclipse.emf.ocl.expressions.Variable;
import org.eclipse.emf.ocl.expressions.Visitor;
import org.eclipse.emf.ocl.expressions.util.AbstractVisitor;
import org.eclipse.emf.ocl.helper.HelperUtil;
import org.eclipse.emf.ocl.helper.IOCLHelper;
import org.eclipse.emf.ocl.helper.OCLParsingException;
import org.eclipse.emf.ocl.parser.EcoreEnvironment;
import org.eclipse.emf.ocl.parser.EcoreEnvironmentFactory;
import org.eclipse.emf.ocl.parser.Environment;
import org.eclipse.emf.ocl.parser.EnvironmentFactory;
import org.eclipse.emf.ocl.parser.EvaluationEnvironment;
import org.eclipse.emf.ocl.query.Query;
import org.eclipse.emf.ocl.query.QueryFactory;
import org.eclipse.emf.ocl.types.util.Types;
import org.eclipse.gmf.ecore.expressions.EcoreAbstractExpression;

public class EcoreOCLFactory {
    private EcoreOCLFactory() {
    }

    public static EcoreAbstractExpression getExpression(String body, EClassifier context, Map environment) {
        return new Expression(body, context, environment);
    }

    public static EcoreAbstractExpression getExpression(String body, EClassifier context) {
        return EcoreOCLFactory.getExpression(body, context, Collections.EMPTY_MAP);
    }

    private static class Expression
    extends EcoreAbstractExpression {
        private Query query;

        public Expression(String body, EClassifier context, Map environment) {
            super(body, context, environment);
            IOCLHelper oclHelper = environment.isEmpty() ? HelperUtil.createOCLHelper() : HelperUtil.createOCLHelper((EnvironmentFactory)Expression.createCustomEnv(environment));
            oclHelper.setContext((Object)this.context());
            try {
                OCLExpression oclExpression = oclHelper.createQuery(body);
                this.query = QueryFactory.eINSTANCE.createQuery(oclExpression);
            }
            catch (OCLParsingException e) {
                this.setStatus(4, e.getMessage(), e);
            }
        }

        protected Object doEvaluate(Object context, Map env) {
            Object var5_5;
            Object object;
            if (this.query == null) {
                return null;
            }
            EvaluationEnvironment evalEnv = this.query.getEvaluationEnvironment();
            Iterator it = env.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry nextEntry = it.next();
                evalEnv.replace((String)nextEntry.getKey(), nextEntry.getValue());
            }
            try {
                this.initExtentMap(context);
                Object result = this.query.evaluate(context);
                object = result != Types.OCL_INVALID ? result : null;
                var5_5 = null;
            }
            catch (Throwable throwable) {
                var5_5 = null;
                evalEnv.clear();
                this.query.setExtentMap(Collections.EMPTY_MAP);
                throw throwable;
            }
            evalEnv.clear();
            this.query.setExtentMap(Collections.EMPTY_MAP);
            return object;
        }

        protected Object performCast(Object value, ETypedElement targetType) {
            if (targetType.getEType() instanceof EEnum && value instanceof EEnumLiteral) {
                EEnumLiteral literal = (EEnumLiteral)value;
                return literal.getInstance() != null ? literal.getInstance() : literal;
            }
            return super.performCast(value, targetType);
        }

        private void initExtentMap(Object context) {
            if (this.query == null || context == null) {
                return;
            }
            Query queryToInit = this.query;
            Object extentContext = context;
            queryToInit.setExtentMap(Collections.EMPTY_MAP);
            if (queryToInit.queryText() != null && queryToInit.queryText().indexOf("allInstances") >= 0) {
                AbstractVisitor visitior = new AbstractVisitor(this, queryToInit, extentContext){
                    private boolean usesAllInstances;
                    final /* synthetic */ Expression this$1;
                    private final /* synthetic */ Query val$queryToInit;
                    private final /* synthetic */ Object val$extentContext;
                    {
                        this.this$1 = expression;
                        this.val$queryToInit = query;
                        this.val$extentContext = object;
                        this.usesAllInstances = false;
                    }

                    public Object visitOperationCallExp(OperationCallExp oc) {
                        if (!this.usesAllInstances) {
                            boolean bl = this.usesAllInstances = 40 == oc.getOperationCode();
                            if (this.usesAllInstances) {
                                this.val$queryToInit.setExtentMap(EcoreEnvironmentFactory.ECORE_INSTANCE.createExtentMap(this.val$extentContext));
                            }
                        }
                        return super.visitOperationCallExp(oc);
                    }
                };
                queryToInit.getExpression().accept((Visitor)visitior);
            }
        }

        private static EcoreEnvironmentFactory createCustomEnv(Map environment) {
            Map env = environment;
            return new EcoreEnvironmentFactory(env){
                private final /* synthetic */ Map val$env;
                {
                    this.val$env = map;
                }

                public Environment createClassifierContext(Object context) {
                    Environment ecoreEnv = super.createClassifierContext(context);
                    Iterator<K> it = this.val$env.keySet().iterator();
                    while (it.hasNext()) {
                        String varName = (String)it.next();
                        EClassifier varType = (EClassifier)this.val$env.get(varName);
                        ecoreEnv.addElement(varName, Expression.access$0(varName, varType), false);
                    }
                    return ecoreEnv;
                }
            };
        }

        private static Variable createVar(String name, EClassifier type) {
            Variable var = ExpressionsFactory.eINSTANCE.createVariable();
            var.setName(name);
            var.setType(EcoreEnvironment.getOCLType((EClassifier)type));
            return var;
        }

        static /* synthetic */ Variable access$0(String string, EClassifier eClassifier) {
            return Expression.createVar(string, eClassifier);
        }
    }
}

