/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.internal.xpand.ast;

import org.eclipse.gmf.internal.xpand.ast.AbstractDefinition;
import org.eclipse.gmf.internal.xpand.ast.AstVisitor;
import org.eclipse.gmf.internal.xpand.ast.ErrorStatement;
import org.eclipse.gmf.internal.xpand.ast.ExpandStatement;
import org.eclipse.gmf.internal.xpand.ast.ExpressionStatement;
import org.eclipse.gmf.internal.xpand.ast.FileStatement;
import org.eclipse.gmf.internal.xpand.ast.ForEachStatement;
import org.eclipse.gmf.internal.xpand.ast.IfStatement;
import org.eclipse.gmf.internal.xpand.ast.LetStatement;
import org.eclipse.gmf.internal.xpand.ast.ProtectStatement;
import org.eclipse.gmf.internal.xpand.ast.Statement;
import org.eclipse.gmf.internal.xpand.ast.Template;
import org.eclipse.gmf.internal.xpand.ast.TextStatement;
import org.eclipse.gmf.internal.xpand.model.XpandAdvice;
import org.eclipse.gmf.internal.xpand.model.XpandDefinition;

public class AstIterator {
    private AstVisitor myVisitor;

    AstIterator(AstVisitor visitor) {
        this.myVisitor = visitor;
    }

    public void iterate(Template template) {
        if (!this.myVisitor.visit(template)) {
            return;
        }
        Object[] objectArray = template.getDefinitions();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            XpandDefinition definition = objectArray[n2];
            this.iterate(definition);
            ++n2;
        }
        objectArray = template.getAdvices();
        n = objectArray.length;
        n2 = 0;
        while (n2 < n) {
            Object advice = objectArray[n2];
            this.iterate((XpandAdvice)advice);
            ++n2;
        }
    }

    public void iterate(XpandDefinition definition) {
        if (!this.myVisitor.visit(definition)) {
            return;
        }
        if (definition instanceof AbstractDefinition) {
            this.iterate(((AbstractDefinition)((Object)definition)).getBody());
        }
    }

    public void iterate(XpandAdvice advice) {
        if (!this.myVisitor.visit(advice)) {
            return;
        }
        if (advice instanceof AbstractDefinition) {
            this.iterate(((AbstractDefinition)((Object)advice)).getBody());
        }
    }

    public void iterate(Statement[] body) {
        Statement[] statementArray = body;
        int n = body.length;
        int n2 = 0;
        while (n2 < n) {
            Statement statement = statementArray[n2];
            if (statement instanceof ErrorStatement) {
                this.iterate((ErrorStatement)statement);
            } else if (statement instanceof ExpandStatement) {
                this.iterate((ExpandStatement)statement);
            } else if (statement instanceof ExpressionStatement) {
                this.iterate((ExpressionStatement)statement);
            } else if (statement instanceof FileStatement) {
                this.iterate((FileStatement)statement);
            } else if (statement instanceof ForEachStatement) {
                this.iterate((ForEachStatement)statement);
            } else if (statement instanceof IfStatement) {
                this.iterate((IfStatement)statement);
            } else if (statement instanceof LetStatement) {
                this.iterate((LetStatement)statement);
            } else if (statement instanceof ProtectStatement) {
                this.iterate((ProtectStatement)statement);
            } else if (statement instanceof TextStatement) {
                this.iterate((TextStatement)statement);
            } else {
                this.iterate(statement);
            }
            ++n2;
        }
    }

    public void iterate(Statement statement) {
        this.myVisitor.visit(statement);
    }

    public void iterate(TextStatement statement) {
        this.myVisitor.visit(statement);
    }

    public void iterate(ProtectStatement statement) {
        if (!this.myVisitor.visit(statement)) {
            return;
        }
        this.iterate(statement.getBody());
    }

    public void iterate(LetStatement statement) {
        if (!this.myVisitor.visit(statement)) {
            return;
        }
        this.iterate(statement.getBody());
    }

    public void iterate(IfStatement statement) {
        if (!this.myVisitor.visit(statement)) {
            return;
        }
        this.iterate(statement.getThenPart());
        if (statement.getElseIf() != null) {
            this.iterate(statement.getElseIf());
        }
    }

    public void iterate(ForEachStatement statement) {
        if (!this.myVisitor.visit(statement)) {
            return;
        }
        this.iterate(statement.getBody());
    }

    public void iterate(FileStatement statement) {
        if (!this.myVisitor.visit(statement)) {
            return;
        }
        this.iterate(statement.getBody());
    }

    public void iterate(ExpressionStatement statement) {
        this.myVisitor.visit(statement);
    }

    public void iterate(ExpandStatement statement) {
        this.myVisitor.visit(statement);
    }

    public void iterate(ErrorStatement statement) {
        this.myVisitor.visit(statement);
    }
}

