/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.internal.xpand.ast;

import org.eclipse.gmf.internal.xpand.ast.AbstractDefinition;
import org.eclipse.gmf.internal.xpand.ast.Statement;
import org.eclipse.gmf.internal.xpand.expression.ast.DeclaredParameter;
import org.eclipse.gmf.internal.xpand.expression.ast.Identifier;
import org.eclipse.gmf.internal.xpand.model.XpandDefinition;

public class Definition
extends AbstractDefinition
implements XpandDefinition {
    private final Identifier name;

    public Definition(int start, int end, int line, int startOffset, int endOffset, Identifier name, Identifier type, DeclaredParameter[] params, Statement[] body) {
        super(start, end, line, startOffset, endOffset, type, params, body);
        this.name = name;
    }

    public Identifier getDefName() {
        return this.name;
    }

    public String toString() {
        return String.valueOf(this.getOwner().getFullyQualifiedName()) + "::" + this.getName() + this.getParamString() + " FOR " + this.getType().getValue();
    }

    private String getParamString() {
        if (this.getParams() == null || this.getParams().length == 0) {
            return "";
        }
        StringBuffer buff = new StringBuffer("(");
        int i = 0;
        while (i < this.getParams().length) {
            DeclaredParameter p = this.getParams()[i];
            buff.append(p.getName().getValue()).append(" ").append(p.getType().getValue());
            if (i + 1 < this.getParams().length) {
                buff.append(",");
            }
            ++i;
        }
        return buff.toString();
    }

    public String getName() {
        return this.getDefName().getValue();
    }
}

