/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.internal.xpand.codeassist;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.gmf.internal.xpand.codeassist.XpandTokens;
import org.eclipse.gmf.internal.xpand.expression.ExecutionContext;
import org.eclipse.gmf.internal.xpand.expression.codeassist.ProposalComputer;
import org.eclipse.gmf.internal.xpand.expression.codeassist.ProposalFactory;
import org.eclipse.jface.text.contentassist.ICompletionProposal;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KeywordProposalComputer
implements ProposalComputer {
    private final String textPastInsertionPoint;
    private static final Pattern PREFIX = Pattern.compile("([A-Z]+)\\z");

    public KeywordProposalComputer(String textPastInsertionPoint) {
        this.textPastInsertionPoint = textPastInsertionPoint;
    }

    @Override
    public List<ICompletionProposal> computeProposals(String txt, ExecutionContext ctx, ProposalFactory factory) {
        String prefix = this.getPrefix(txt);
        ArrayList<ICompletionProposal> result = new ArrayList<ICompletionProposal>();
        if (prefix.length() > 0 || txt.endsWith("\u00ab")) {
            String[] kw;
            boolean needsRT = !this.textPastInsertionPoint.trim().startsWith("\u00bb");
            String[] stringArray = kw = XpandTokens.allKeywords();
            int n = kw.length;
            int n2 = 0;
            while (n2 < n) {
                String string = stringArray[n2];
                if (string.toLowerCase().startsWith(prefix.toLowerCase())) {
                    String insertString = string;
                    if (!string.startsWith("END")) {
                        insertString = String.valueOf(insertString) + " ";
                    } else if (needsRT) {
                        insertString = String.valueOf(insertString) + "\u00bb";
                    }
                    result.add(factory.createKeywordProposal(insertString, string, prefix));
                }
                ++n2;
            }
        }
        return result;
    }

    private String getPrefix(String txt) {
        Matcher m = PREFIX.matcher(txt);
        if (m.find()) {
            return m.group(1);
        }
        return "";
    }
}

