/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.tests;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.eclipse.gmf.tests.ConfigurationFailedCase;
import org.eclipse.gmf.tests.NeedsSetup;
import org.eclipse.gmf.tests.TestConfiguration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Configurator {
    private final Map<Class<? extends TestCase>, Class<? extends TestConfiguration>> config = new HashMap<Class<? extends TestCase>, Class<? extends TestConfiguration>>();
    private final Map<Class<? extends TestConfiguration>, TestConfiguration> state = new HashMap<Class<? extends TestConfiguration>, TestConfiguration>();
    private Class<?> lastSetupLookupTarget;
    private Method[] lastSetupLookupResult;

    public void dispose() {
        this.config.clear();
        this.state.clear();
    }

    public void register(Class<? extends TestCase> target, Class<? extends TestConfiguration> configClass) {
        this.config.put(target, configClass);
    }

    public void register(Class<? extends TestCase> target, TestConfiguration configInstance) {
        Class<?> configClass = configInstance.getClass();
        this.register(target, configClass);
        this.registerInstance(configClass, configInstance);
    }

    public void registerInstance(Class<? extends TestConfiguration> configClass, TestConfiguration configInstance) {
        this.state.put(configClass, configInstance);
    }

    private TestConfiguration getConfig(Class<? extends TestCase> target, String testName, boolean instantiate) {
        Class<? extends TestConfiguration> configClass = this.config.get(target);
        if (configClass == null) {
            return null;
        }
        TestConfiguration configInstance = this.state.get(configClass);
        if (configInstance == null && instantiate) {
            configInstance = this.newInstance(configClass);
            this.state.put(configClass, configInstance);
        }
        return configInstance;
    }

    private TestConfiguration newInstance(Class<? extends TestConfiguration> configClass) {
        Method[] methodArray = configClass.getMethods();
        int n = methodArray.length;
        int n2 = 0;
        while (n2 < n) {
            Method m = methodArray[n2];
            if (Modifier.isStatic(m.getModifiers()) && m.getAnnotation(TestConfiguration.FactoryMethod.class) != null) {
                if (configClass.isAssignableFrom(m.getReturnType())) {
                    try {
                        return (TestConfiguration)m.invoke(null, new Object[0]);
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
                Assert.fail((String)("Bad factory method: " + m));
                assert (false);
            }
            ++n2;
        }
        Assert.fail((String)("Can't find factory method in " + configClass));
        return null;
    }

    private Method[] getSetupMethods(Class<?> target) {
        if (this.lastSetupLookupTarget == target) {
            return this.lastSetupLookupResult;
        }
        this.lastSetupLookupTarget = target;
        this.lastSetupLookupResult = Configurator.findSetupMethods(target);
        return this.lastSetupLookupResult;
    }

    private static Method[] findSetupMethods(Class<?> target) {
        ArrayList<Method> setupMethods = new ArrayList<Method>(3);
        Method[] methodArray = target.getMethods();
        int n = methodArray.length;
        int n2 = 0;
        while (n2 < n) {
            Method m = methodArray[n2];
            if (m.getAnnotation(NeedsSetup.class) != null) {
                Class<?>[] parameterTypes = m.getParameterTypes();
                if (parameterTypes.length == 1 && TestConfiguration.class.isAssignableFrom(parameterTypes[0])) {
                    setupMethods.add(m);
                } else {
                    Assert.fail((String)("Invalid test configuration method:" + m));
                }
            }
            ++n2;
        }
        return setupMethods.toArray(new Method[setupMethods.size()]);
    }

    public void prepare(TestCase test) {
        Class<?> testClass = test.getClass();
        Method[] setupMethods = this.getSetupMethods(testClass);
        if (setupMethods.length == 0) {
            return;
        }
        TestConfiguration config = this.getConfig(testClass, test.getName(), true);
        if (config == null) {
            return;
        }
        Method[] methodArray = setupMethods;
        int n = setupMethods.length;
        int n2 = 0;
        while (n2 < n) {
            Method m = methodArray[n2];
            if (m.getParameterTypes()[0].isInstance(config)) {
                try {
                    m.invoke((Object)test, config);
                }
                catch (Exception ex) {
                    Assert.fail((String)ex.toString());
                }
            }
            ++n2;
        }
    }

    public static TestSuite feed(Class<? extends TestCase> theClass, TestConfiguration config, String suiteName) {
        TestSuite suite = new TestSuite(theClass, suiteName);
        try {
            Method[] methodArray = Configurator.findSetupMethods(theClass);
            int n = methodArray.length;
            int n2 = 0;
            while (n2 < n) {
                Method m = methodArray[n2];
                if (m.getParameterTypes()[0].isInstance(config)) {
                    Enumeration en = suite.tests();
                    while (en.hasMoreElements()) {
                        Object nextTest = en.nextElement();
                        m.invoke(nextTest, config);
                    }
                }
                ++n2;
            }
        }
        catch (Exception ex) {
            suite.addTest((Test)new ConfigurationFailedCase(String.valueOf(theClass.getName()) + ": " + ex.getMessage(), ex));
        }
        return suite;
    }
}

