/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.tests.setup;

import java.util.Collection;
import org.eclipse.emf.codegen.ecore.genmodel.GenClass;
import org.eclipse.emf.codegen.ecore.genmodel.GenModel;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.impl.ResourceImpl;
import org.eclipse.gmf.codegen.gmfgen.ElementType;
import org.eclipse.gmf.codegen.gmfgen.FeatureLabelModelFacet;
import org.eclipse.gmf.codegen.gmfgen.FeatureLinkModelFacet;
import org.eclipse.gmf.codegen.gmfgen.FigureViewmap;
import org.eclipse.gmf.codegen.gmfgen.GMFGenFactory;
import org.eclipse.gmf.codegen.gmfgen.GenAuditContainer;
import org.eclipse.gmf.codegen.gmfgen.GenAuditRoot;
import org.eclipse.gmf.codegen.gmfgen.GenAuditRule;
import org.eclipse.gmf.codegen.gmfgen.GenAuditable;
import org.eclipse.gmf.codegen.gmfgen.GenConstraint;
import org.eclipse.gmf.codegen.gmfgen.GenDiagram;
import org.eclipse.gmf.codegen.gmfgen.GenDomainElementTarget;
import org.eclipse.gmf.codegen.gmfgen.GenEditorGenerator;
import org.eclipse.gmf.codegen.gmfgen.GenLink;
import org.eclipse.gmf.codegen.gmfgen.GenNode;
import org.eclipse.gmf.codegen.gmfgen.GenNodeLabel;
import org.eclipse.gmf.codegen.gmfgen.GenSeverity;
import org.eclipse.gmf.codegen.gmfgen.GenTopLevelNode;
import org.eclipse.gmf.codegen.gmfgen.LabelModelFacet;
import org.eclipse.gmf.codegen.gmfgen.LinkModelFacet;
import org.eclipse.gmf.codegen.gmfgen.MetamodelType;
import org.eclipse.gmf.codegen.gmfgen.Palette;
import org.eclipse.gmf.codegen.gmfgen.TypeLinkModelFacet;
import org.eclipse.gmf.codegen.gmfgen.TypeModelFacet;
import org.eclipse.gmf.codegen.gmfgen.Viewmap;
import org.eclipse.gmf.internal.bridge.NaiveIdentifierDispenser;
import org.eclipse.gmf.internal.bridge.VisualIdentifierDispenser;
import org.eclipse.gmf.internal.bridge.genmodel.BasicDiagramRunTimeModelHelper;
import org.eclipse.gmf.internal.bridge.genmodel.DiagramGenModelTransformer;
import org.eclipse.gmf.internal.bridge.genmodel.DiagramRunTimeModelHelper;
import org.eclipse.gmf.internal.bridge.genmodel.GenModelMatcher;
import org.eclipse.gmf.internal.bridge.genmodel.InnerClassViewmapProducer;
import org.eclipse.gmf.internal.bridge.genmodel.RuntimeGenModelAccess;
import org.eclipse.gmf.internal.bridge.genmodel.ViewmapProducer;
import org.eclipse.gmf.internal.bridge.naming.NamingStrategy;
import org.eclipse.gmf.internal.bridge.naming.gen.GenModelNamingMediator;
import org.eclipse.gmf.internal.bridge.naming.gen.GenModelNamingMediatorImpl;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.tests.Plugin;
import org.eclipse.gmf.tests.Utils;
import org.eclipse.gmf.tests.setup.DiaGenSource;
import org.eclipse.gmf.tests.setup.DomainModelSource;
import org.eclipse.gmf.tests.setup.MapDefSource;
import org.eclipse.gmf.tests.setup.MapSetup;

public class DiaGenSetup
implements DiaGenSource {
    private GenDiagram myGenDiagram;
    private GenTopLevelNode myNodeA;
    private GenLink myLinkC;
    private GenLink myLinkD;
    private GenNode myNodeB;
    private ViewmapProducer myViewmapProducer;

    public DiaGenSetup() {
        this((ViewmapProducer)new InnerClassViewmapProducer());
    }

    public DiaGenSetup(ViewmapProducer viewmapProducer) {
        this.myViewmapProducer = viewmapProducer;
    }

    public DiaGenSetup init(DomainModelSource domainSource) {
        GenModel runtimeModel = this.getRuntimeGenModel();
        assert (runtimeModel != null);
        GenModelMatcher gmm = new GenModelMatcher(Utils.createGenModel(domainSource.getModel()));
        this.myGenDiagram = GMFGenFactory.eINSTANCE.createGenDiagram();
        GenEditorGenerator genBurden = GMFGenFactory.eINSTANCE.createGenEditorGenerator();
        this.myGenDiagram.setDomainDiagramElement(gmm.findGenClass(domainSource.getDiagramElement()));
        genBurden.setDomainGenModel(this.myGenDiagram.getDomainDiagramElement().getGenModel());
        genBurden.setEditor(GMFGenFactory.eINSTANCE.createGenEditorView());
        this.myGenDiagram.setDiagramRunTimeClass(Utils.findGenClass(runtimeModel, NotationPackage.eINSTANCE.getDiagram()));
        this.myGenDiagram.setPalette(this.createPalette());
        this.myGenDiagram.setViewmap(DiaGenSetup.createDiagramViewmap());
        this.myGenDiagram.setVisualID(99);
        MetamodelType dgmmType = GMFGenFactory.eINSTANCE.createMetamodelType();
        this.myGenDiagram.setElementType((ElementType)dgmmType);
        genBurden.setDiagram(this.myGenDiagram);
        genBurden.setPlugin(GMFGenFactory.eINSTANCE.createGenPlugin());
        genBurden.setDiagramUpdater(GMFGenFactory.eINSTANCE.createGenDiagramUpdater());
        this.myNodeA = GMFGenFactory.eINSTANCE.createGenTopLevelNode();
        this.myNodeA.setDiagramRunTimeClass(Utils.findGenClass(runtimeModel, NotationPackage.eINSTANCE.getNode()));
        this.myNodeA.setModelFacet(this.createNodeModelFacet(gmm, domainSource.getNodeA()));
        this.myNodeA.setElementType((ElementType)GMFGenFactory.eINSTANCE.createMetamodelType());
        EAttribute editFeature = domainSource.getNodeA().getNameAttr();
        if (editFeature != null) {
            FeatureLabelModelFacet modelFacet = GMFGenFactory.eINSTANCE.createFeatureLabelModelFacet();
            modelFacet.getMetaFeatures().add((Object)gmm.findGenFeature((EStructuralFeature)editFeature));
            GenNodeLabel label = GMFGenFactory.eINSTANCE.createGenNodeLabel();
            label.setModelFacet((LabelModelFacet)modelFacet);
            label.setVisualID(401);
            label.setViewmap(DiaGenSetup.createLabelViewmap());
            label.setDiagramRunTimeClass(this.myNodeA.getDiagramRunTimeClass());
            this.myNodeA.getLabels().add((Object)label);
        }
        this.myNodeA.setViewmap(DiaGenSetup.createNodeViewmap());
        this.myNodeA.setVisualID(100);
        this.myLinkC = GMFGenFactory.eINSTANCE.createGenLink();
        this.myLinkC.setDiagramRunTimeClass(Utils.findGenClass(runtimeModel, NotationPackage.eINSTANCE.getEdge()));
        this.myLinkC.setModelFacet((LinkModelFacet)this.createLinkModelFacet(gmm, domainSource.getLinkAsClass()));
        this.myLinkC.setViewmap(DiaGenSetup.createLinkViewmap());
        this.myLinkC.setVisualID(200);
        this.myLinkC.setElementType((ElementType)GMFGenFactory.eINSTANCE.createMetamodelType());
        this.myGenDiagram.getTopLevelNodes().add((Object)this.myNodeA);
        this.myGenDiagram.getLinks().add((Object)this.myLinkC);
        this.myGenDiagram.getEditorGen().setAudits(this.createAudits());
        this.confineInResource();
        return this;
    }

    private static Viewmap createLinkViewmap() {
        FigureViewmap v = GMFGenFactory.eINSTANCE.createFigureViewmap();
        v.setFigureQualifiedClassName("org.eclipse.gmf.runtime.draw2d.ui.figures.PolylineConnectionEx");
        return v;
    }

    private static Viewmap createNodeViewmap() {
        FigureViewmap v = GMFGenFactory.eINSTANCE.createFigureViewmap();
        v.setFigureQualifiedClassName("org.eclipse.draw2d.RoundedRectangle");
        return v;
    }

    private static Viewmap createDiagramViewmap() {
        FigureViewmap v = GMFGenFactory.eINSTANCE.createFigureViewmap();
        v.setFigureQualifiedClassName("org.eclipse.draw2d.FreeformLayer");
        return v;
    }

    private static Viewmap createLabelViewmap() {
        FigureViewmap v = GMFGenFactory.eINSTANCE.createFigureViewmap();
        v.setFigureQualifiedClassName("org.eclipse.draw2d.Label");
        return v;
    }

    private TypeModelFacet createNodeModelFacet(GenModelMatcher gmm, DomainModelSource.NodeData node) {
        TypeModelFacet mf = GMFGenFactory.eINSTANCE.createTypeModelFacet();
        mf.setMetaClass(gmm.findGenClass(node.getEClass()));
        mf.setContainmentMetaFeature(gmm.findGenFeature((EStructuralFeature)node.getContainment()));
        mf.setChildMetaFeature(mf.getContainmentMetaFeature());
        return mf;
    }

    private TypeLinkModelFacet createLinkModelFacet(GenModelMatcher gmm, DomainModelSource.LinkData link) {
        TypeLinkModelFacet mf = GMFGenFactory.eINSTANCE.createTypeLinkModelFacet();
        mf.setMetaClass(gmm.findGenClass(link.getEClass()));
        mf.setContainmentMetaFeature(gmm.findGenFeature((EStructuralFeature)link.getContainment()));
        mf.setChildMetaFeature(mf.getContainmentMetaFeature());
        mf.setTargetMetaFeature(gmm.findGenFeature(link.getTargetFeature()));
        return mf;
    }

    private GenModel getRuntimeGenModel() {
        RuntimeGenModelAccess runtimeAccess = new RuntimeGenModelAccess();
        runtimeAccess.ensure();
        return runtimeAccess.model();
    }

    public DiaGenSetup init(MapDefSource mapSource) {
        BasicDiagramRunTimeModelHelper drth = new BasicDiagramRunTimeModelHelper();
        GenModelNamingMediatorImpl namingMediator = new GenModelNamingMediatorImpl();
        DiagramGenModelTransformer t = new DiagramGenModelTransformer((DiagramRunTimeModelHelper)drth, (GenModelNamingMediator)namingMediator, this.myViewmapProducer, (VisualIdentifierDispenser)new NaiveIdentifierDispenser(), false);
        t.setEMFGenModel(this.initGenModel(mapSource.getMapping().getDiagram().getDomainModel()));
        t.transform(mapSource.getMapping());
        this.myGenDiagram = t.getResult().getDiagram();
        namingMediator.reset();
        NamingStrategy epns = namingMediator.getEditPart();
        String aNodeEPName = epns.get(mapSource.getNodeA());
        String bNodeEPName = mapSource.getNodeB() == null ? null : epns.get(mapSource.getNodeB());
        String cLinkEPName = epns.get(mapSource.getClassLink());
        String dLinkEPName = epns.get(mapSource.getReferenceLink());
        for (GenTopLevelNode n : this.myGenDiagram.getTopLevelNodes()) {
            if (n.getEditPartClassName().equals(aNodeEPName)) {
                this.myNodeA = n;
            }
            if (!n.getEditPartClassName().equals(bNodeEPName)) continue;
            this.myNodeB = n;
        }
        for (GenLink l : this.myGenDiagram.getLinks()) {
            if (l.getEditPartClassName().equals(cLinkEPName)) {
                this.myLinkC = l;
            }
            if (!l.getEditPartClassName().equals(dLinkEPName)) continue;
            this.myLinkD = l;
        }
        if (mapSource instanceof MapSetup) {
            this.initSpecific((MapSetup)mapSource);
        }
        assert (this.myNodeA != null);
        assert (this.myLinkC != null);
        assert (this.myLinkD != null);
        this.confineInResource();
        return this;
    }

    private void initSpecific(MapSetup setup) {
        for (GenLink nextLink : this.myGenDiagram.getLinks()) {
            TypeLinkModelFacet modelFacet;
            if (nextLink == this.myLinkC || nextLink == this.myLinkD) continue;
            if (nextLink.getModelFacet() instanceof TypeLinkModelFacet) {
                modelFacet = (TypeLinkModelFacet)nextLink.getModelFacet();
                nextLink.setIncomingCreationAllowed(true);
                if (this.isSelfLink(modelFacet) || modelFacet.getContainmentMetaFeature().getEcoreFeature().getUpperBound() > 1) {
                    nextLink.setOutgoingCreationAllowed(true);
                    continue;
                }
                nextLink.setOutgoingCreationAllowed(false);
                continue;
            }
            if (!(nextLink.getModelFacet() instanceof FeatureLinkModelFacet)) continue;
            modelFacet = (FeatureLinkModelFacet)nextLink.getModelFacet();
            nextLink.setIncomingCreationAllowed(true);
            if (this.isSelfLink((FeatureLinkModelFacet)modelFacet) || modelFacet.getMetaFeature().getEcoreFeature().getUpperBound() > 1) {
                nextLink.setOutgoingCreationAllowed(true);
                continue;
            }
            nextLink.setOutgoingCreationAllowed(false);
        }
    }

    private boolean isSelfLink(FeatureLinkModelFacet modelFacet) {
        return modelFacet.getMetaFeature().getTypeGenClass() == modelFacet.getMetaFeature().getGenClass();
    }

    private boolean isSelfLink(TypeLinkModelFacet modelFacet) {
        return modelFacet.getTargetMetaFeature().getTypeGenClass() == modelFacet.getContainmentMetaFeature().getGenClass();
    }

    protected GenModel initGenModel(EPackage domainModel) {
        return Utils.createGenModel(domainModel);
    }

    private void confineInResource() {
        new ResourceImpl(URI.createURI((String)"uri://org.eclipse.gmf/tests/DiaGenSetup")).getContents().add((Object)this.myGenDiagram.getEditorGen());
    }

    public final GenDiagram getGenDiagram() {
        return this.myGenDiagram;
    }

    public final GenNode getNodeA() {
        return this.myNodeA;
    }

    public final GenNode getNodeB() {
        return this.myNodeB;
    }

    public final GenLink getLinkC() {
        return this.myLinkC;
    }

    public GenLink getLinkD() {
        return this.myLinkD;
    }

    private GenAuditRoot createAudits() {
        GenClass classA = this.getNodeA().getDomainMetaClass();
        assert (this.getLinkC().getModelFacet() instanceof TypeLinkModelFacet) : "Expecting link with class";
        GenClass classC = ((TypeLinkModelFacet)this.getLinkC().getModelFacet()).getMetaClass();
        GenAuditRoot root = GMFGenFactory.eINSTANCE.createGenAuditRoot();
        GenAuditContainer topCat = this.createAuditContainer(String.valueOf(Plugin.getPluginID()) + ".category1" + System.currentTimeMillis());
        root.getCategories().add((Object)topCat);
        topCat.getPath().add((Object)topCat);
        topCat.getAudits().add((Object)this.createAudit("constraint.id1", "true", classA, GenSeverity.ERROR_LITERAL, false));
        topCat.getAudits().add((Object)this.createAudit("constraint.id2", "10 > 0", classC, GenSeverity.WARNING_LITERAL, false));
        root.getRules().addAll((Collection)topCat.getAudits());
        GenAuditContainer subCat = this.createAuditContainer("category2");
        root.getCategories().add((Object)subCat);
        subCat.getPath().add((Object)topCat);
        subCat.getPath().add((Object)subCat);
        subCat.getAudits().add((Object)this.createAudit("constraint.id3", "''<>'Foo'", classA, GenSeverity.INFO_LITERAL, false));
        root.getRules().addAll((Collection)subCat.getAudits());
        return root;
    }

    private GenAuditRule createAudit(String id, String ruleBody, GenClass target, GenSeverity severity, boolean isLiveMode) {
        GenAuditRule audit = GMFGenFactory.eINSTANCE.createGenAuditRule();
        audit.setId(id);
        audit.setName("Name of" + id);
        GenDomainElementTarget ruleTarget = GMFGenFactory.eINSTANCE.createGenDomainElementTarget();
        ruleTarget.setElement(target);
        audit.setTarget((GenAuditable)ruleTarget);
        GenConstraint rule = GMFGenFactory.eINSTANCE.createGenConstraint();
        rule.setBody(ruleBody);
        audit.setRule(rule);
        audit.setSeverity(severity);
        audit.setUseInLiveMode(isLiveMode);
        return audit;
    }

    private GenAuditContainer createAuditContainer(String id) {
        GenAuditContainer container = GMFGenFactory.eINSTANCE.createGenAuditContainer();
        container.setId(id);
        container.setName("Name of " + id);
        container.setDescription("Description of " + id);
        return container;
    }

    private Palette createPalette() {
        return null;
    }
}

