/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.tests.rt;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import org.eclipse.emf.codegen.ecore.genmodel.GenClass;
import org.eclipse.emf.codegen.ecore.genmodel.GenFeature;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EEnumLiteral;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.gmf.codegen.gmfgen.GenCommonBase;
import org.eclipse.gmf.codegen.gmfgen.GenExpressionProviderContainer;
import org.eclipse.gmf.codegen.gmfgen.GenFeatureSeqInitializer;
import org.eclipse.gmf.codegen.gmfgen.GenFeatureValueSpec;
import org.eclipse.gmf.codegen.gmfgen.GenJavaExpressionProvider;
import org.eclipse.gmf.codegen.gmfgen.TypeModelFacet;
import org.eclipse.gmf.codegen.gmfgen.ValueExpression;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.gmf.tests.rt.RuntimeDiagramTestBase;

public class ElementInitializerTest
extends RuntimeDiagramTestBase {
    private EObject nodeAElement;
    private EObject nodeBElement;
    static /* synthetic */ Class class$0;

    public ElementInitializerTest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        Node nodeA = this.createNode((GenCommonBase)this.getGenModel().getNodeA(), (View)this.getDiagram());
        this.nodeAElement = nodeA.getElement();
        Node nodeB = this.createNode((GenCommonBase)this.getGenModel().getNodeB(), (View)this.getDiagram());
        this.nodeBElement = nodeB.getElement();
        ElementInitializerTest.assertNotNull((String)"Tested node A element not available", (Object)this.nodeAElement);
        ElementInitializerTest.assertNotNull((String)"Tested node B element not available", (Object)this.nodeBElement);
    }

    public void testJavaInitializers() throws Exception {
        Class javaContainerClass = this.loadJavaContainerClass();
        ElementInitializerTest.assertNotNull((String)"Could not find generated java initializer class", (Object)javaContainerClass);
        GenJavaExpressionProvider javaProvider = null;
        GenExpressionProviderContainer container = this.getGenModel().getGenDiagram().getEditorGen().getExpressionProviders();
        Iterator providerIt = container.getProviders().iterator();
        while (providerIt.hasNext()) {
            Object nextProvider = providerIt.next();
            if (!(nextProvider instanceof GenJavaExpressionProvider)) continue;
            javaProvider = (GenJavaExpressionProvider)nextProvider;
        }
        ElementInitializerTest.assertNotNull(javaProvider);
        boolean primitiveTypeAttrTested = false;
        boolean objValTypeAttrTested = false;
        boolean refTested = false;
        boolean multiValPrimitiveTypeAttrTested = false;
        boolean multiObjValTypeAttrTested = false;
        boolean multiRefTested = false;
        TreeIterator it = this.getGenModel().getGenDiagram().eAllContents();
        while (it.hasNext()) {
            Object element = it.next();
            if (!(element instanceof GenFeatureSeqInitializer)) continue;
            GenFeatureSeqInitializer fsInitializer = (GenFeatureSeqInitializer)element;
            TypeModelFacet typeModelFacet = (TypeModelFacet)fsInitializer.eContainer();
            GenClass metaGenClass = typeModelFacet.getMetaClass();
            Iterator ftIt = fsInitializer.getInitializers().iterator();
            while (ftIt.hasNext()) {
                GenFeatureValueSpec nextFtValSpec = (GenFeatureValueSpec)ftIt.next();
                if (container.getProvider((ValueExpression)nextFtValSpec) != javaProvider) continue;
                String operationName = javaProvider.getOperationName((ValueExpression)nextFtValSpec);
                Method method = this.findMethod(javaContainerClass, operationName, metaGenClass);
                GenFeature genFeature = nextFtValSpec.getFeature();
                if (genFeature.isPrimitiveType() && !genFeature.isListType()) {
                    ElementInitializerTest.assertTrue((String)"Use wrapper class for primitive return type", (!method.getReturnType().isPrimitive() && genFeature.isPrimitiveType() ? 1 : 0) != 0);
                    ElementInitializerTest.assertEquals(method.getReturnType(), (Object)EcoreUtil.wrapperClassFor((Class)genFeature.getEcoreFeature().getEType().getInstanceClass()));
                    primitiveTypeAttrTested = true;
                    continue;
                }
                if (!genFeature.isReferenceType() && genFeature.getEcoreFeature().isMany() && genFeature.getEcoreFeature().getEType().getInstanceClass().isPrimitive()) {
                    String string = method.getReturnType().getName();
                    Class<?> clazz = class$0;
                    if (clazz == null) {
                        try {
                            clazz = Class.forName("org.eclipse.emf.common.util.EList");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    ElementInitializerTest.assertEquals((String)string, (String)clazz.getName());
                    multiValPrimitiveTypeAttrTested = true;
                    continue;
                }
                if (!(genFeature.isReferenceType() || genFeature.isPrimitiveType() || genFeature.isListType())) {
                    ElementInitializerTest.assertEquals((String)method.getReturnType().getName(), (String)genFeature.getType());
                    objValTypeAttrTested = true;
                    continue;
                }
                if (!genFeature.isReferenceType() && !genFeature.isPrimitiveType() && genFeature.isListType()) {
                    String string = method.getReturnType().getName();
                    Class<?> clazz = class$0;
                    if (clazz == null) {
                        try {
                            clazz = Class.forName("org.eclipse.emf.common.util.EList");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    ElementInitializerTest.assertEquals((String)string, (String)clazz.getName());
                    multiObjValTypeAttrTested = true;
                    continue;
                }
                if (genFeature.isReferenceType() && !genFeature.isListType()) {
                    ElementInitializerTest.assertEquals((String)method.getReturnType().getName(), (String)genFeature.getTypeGenClass().getQualifiedInterfaceName());
                    refTested = true;
                    continue;
                }
                if (!genFeature.isReferenceType() || !genFeature.isListType()) continue;
                String string = method.getReturnType().getName();
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = Class.forName("org.eclipse.emf.common.util.EList");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                ElementInitializerTest.assertEquals((String)string, (String)clazz.getName());
                multiRefTested = true;
            }
        }
        ElementInitializerTest.assertTrue((boolean)primitiveTypeAttrTested);
        ElementInitializerTest.assertTrue((boolean)objValTypeAttrTested);
        ElementInitializerTest.assertTrue((boolean)refTested);
        ElementInitializerTest.assertTrue((boolean)multiValPrimitiveTypeAttrTested);
        ElementInitializerTest.assertTrue((boolean)multiObjValTypeAttrTested);
        ElementInitializerTest.assertTrue((boolean)multiRefTested);
    }

    protected Class loadJavaContainerClass() {
        String javaContainerName = "Initializers$Java";
        try {
            return this.loadGeneratedClass(String.valueOf(this.getGenModel().getGenDiagram().getElementTypesQualifiedClassName()) + "$" + javaContainerName);
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    public void testAttrMany() throws Exception {
        EStructuralFeature attrManyFeature = this.nodeBElement.eClass().getEStructuralFeature("integers_Init");
        ElementInitializerTest.assertNotNull((String)"field not found in tested class", (Object)attrManyFeature);
        Object value = this.nodeBElement.eGet(attrManyFeature);
        ElementInitializerTest.assertEquals((Object)value, (Object)new BasicEList(Arrays.asList(new Integer(10), new Integer(20))));
    }

    public void testReferenceToMany() throws Exception {
        EStructuralFeature refToManyFeature = this.nodeAElement.eClass().getEStructuralFeature("reference_Init");
        ElementInitializerTest.assertNotNull((String)"field not found in tested class", (Object)refToManyFeature);
        Object value = this.nodeAElement.eGet(refToManyFeature);
        ElementInitializerTest.assertEquals((Object)value, (Object)new BasicEList(Arrays.asList(this.nodeAElement)));
    }

    public void testEnumLiteralAttr() throws Exception {
        EStructuralFeature enumField = this.nodeAElement.eClass().getEStructuralFeature("enumAttr_Init");
        ElementInitializerTest.assertNotNull((String)"enum field not found in tested class", (Object)enumField);
        ElementInitializerTest.assertTrue((boolean)(enumField.getEType() instanceof EEnum));
        EEnum testEnum = (EEnum)enumField.getEType();
        EEnumLiteral literal = testEnum.getEEnumLiteral("LIT1");
        Object literalValue = this.nodeAElement.eGet(enumField);
        ElementInitializerTest.assertNotNull((Object)literalValue);
        ElementInitializerTest.assertFalse((String)"Should be set to different from default", (boolean)literalValue.equals(enumField.getDefaultValue()));
        ElementInitializerTest.assertSame((String)"Expected literal set by initializer", (Object)literal.getInstance(), (Object)literalValue);
    }

    public void testManyEnumLiteralAttr() throws Exception {
        EStructuralFeature enumField = this.nodeAElement.eClass().getEStructuralFeature("manyEnumAttr_Init");
        ElementInitializerTest.assertNotNull((String)"enum field not found in tested class", (Object)enumField);
        ElementInitializerTest.assertTrue((boolean)(enumField.getEType() instanceof EEnum));
        EEnum testEnum = (EEnum)enumField.getEType();
        ArrayList<Object> expectedValues = new ArrayList<Object>();
        expectedValues.add(this.getEnumLiteralInstance(testEnum, "LIT0"));
        expectedValues.add(this.getEnumLiteralInstance(testEnum, "LIT1"));
        Object literalValues = this.nodeAElement.eGet(enumField);
        ElementInitializerTest.assertTrue((boolean)(literalValues instanceof Collection));
        Collection retrivedValues = (Collection)literalValues;
        ElementInitializerTest.assertEquals(expectedValues, (Object)retrivedValues);
    }

    public void testManyRealAttr() throws Exception {
        EStructuralFeature realField = this.nodeAElement.eClass().getEStructuralFeature("manyRealAttr_Init");
        ElementInitializerTest.assertNotNull((String)"Float type attribute not found in tested class", (Object)realField);
        Object realValues = this.nodeAElement.eGet(realField);
        ElementInitializerTest.assertTrue((boolean)(realValues instanceof Collection));
        Collection retrivedValues = (Collection)realValues;
        ArrayList<Float> expectedValues = new ArrayList<Float>();
        expectedValues.add(new Float(1.0));
        expectedValues.add(new Float(1.5));
        ElementInitializerTest.assertEquals(expectedValues, (Object)retrivedValues);
    }

    private Object getEnumLiteralInstance(EEnum eEnum, String literalName) {
        EEnumLiteral literal = eEnum.getEEnumLiteral(literalName);
        ElementInitializerTest.assertNotNull((String)"Enum literal not found", (Object)literal);
        ElementInitializerTest.assertNotNull((String)"Enum literal has no instance", (Object)literal.getInstance());
        return literal.getInstance();
    }

    private Method findMethod(Class clazz, String methodName, GenClass contextClass) {
        try {
            Object[] params = new Class[]{this.loadGeneratedClass(contextClass.getQualifiedInterfaceName())};
            int i = 0;
            while (i < clazz.getDeclaredMethods().length) {
                Method method = clazz.getDeclaredMethods()[i];
                if (method.getName().equals(methodName) && Arrays.equals(params, method.getParameterTypes())) {
                    return method;
                }
                ++i;
            }
        }
        catch (ClassNotFoundException e) {
            ElementInitializerTest.fail((String)("Expected class not generated. " + e.toString()));
        }
        return null;
    }
}

