/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.tests.gen;

import java.util.Iterator;
import java.util.LinkedList;
import junit.framework.TestCase;
import org.eclipse.gmf.internal.common.reconcile.AbstractPool;

public class ReconcilerPoolTest
extends TestCase {
    public void testMoreAcquiresThanCapacity() {
        Pool pool = new Pool(2);
        Object a = pool.acquire();
        Object b = pool.acquire();
        Object c = pool.acquire();
        pool.release(a);
        pool.release(b);
        pool.release(c);
        ReconcilerPoolTest.assertEquals((int)0, (int)pool.getNullsCount());
        ReconcilerPoolTest.assertEquals((int)3, (int)pool.getCreationCount());
    }

    public void testMuchMoreAcquiresGoodShaped() {
        Pool pool = new Pool(2);
        Object a = pool.acquire();
        Object b = pool.acquire();
        int i = 0;
        while (i < 50) {
            Object next = pool.acquire();
            pool.release(next);
            ++i;
        }
        pool.release(a);
        pool.release(b);
        ReconcilerPoolTest.assertEquals((String)"When first NOT_POOLED object is release it should be returned to pool", (int)3, (int)pool.getCreationCount());
        ReconcilerPoolTest.assertEquals((int)0, (int)pool.getNullsCount());
    }

    public void testImmediateRelease() {
        Pool pool = new Pool(2);
        int i = 0;
        while (i < 50) {
            Object next = pool.acquire();
            ReconcilerPoolTest.assertEquals((int)pool.capacity(), (int)pool.getNullsCount());
            pool.release(next);
            ++i;
        }
        ReconcilerPoolTest.assertEquals((int)1, (int)pool.getCreationCount());
        ReconcilerPoolTest.assertEquals((int)(pool.capacity() - 1), (int)pool.getNullsCount());
        i = 0;
        while (i < 50) {
            Object nextA = pool.acquire();
            Object nextB = pool.acquire();
            ReconcilerPoolTest.assertEquals((int)pool.capacity(), (int)pool.getNullsCount());
            if (i % 2 == 0) {
                pool.release(nextA);
                pool.release(nextB);
            } else {
                pool.release(nextB);
                pool.release(nextA);
            }
            ++i;
        }
        ReconcilerPoolTest.assertEquals((int)2, (int)pool.getCreationCount());
        ReconcilerPoolTest.assertEquals((int)(pool.capacity() - 2), (int)pool.getNullsCount());
    }

    public void testBadCase() {
        Pool pool = new Pool(2);
        LinkedList<Object> allAcquired = new LinkedList<Object>();
        int i = 0;
        while (i < 50) {
            allAcquired.add(pool.acquire());
            ++i;
        }
        Iterator it = allAcquired.iterator();
        while (it.hasNext()) {
            pool.release(it.next());
            it.remove();
        }
        ReconcilerPoolTest.assertEquals((int)50, (int)pool.getCreationCount());
        ReconcilerPoolTest.assertEquals((int)0, (int)pool.getNullsCount());
        i = 0;
        while (i < 50) {
            allAcquired.add(pool.acquire());
            ++i;
        }
        it = allAcquired.iterator();
        while (it.hasNext()) {
            pool.release(it.next());
            it.remove();
        }
        ReconcilerPoolTest.assertEquals((int)(100 - pool.capacity()), (int)pool.getCreationCount());
        ReconcilerPoolTest.assertEquals((int)0, (int)pool.getNullsCount());
    }

    public void testBaseInternals() {
        Pool pool = new Pool(2);
        Object a = pool.acquire();
        ReconcilerPoolTest.assertEquals((int)1, (int)pool.getCreationCount());
        ReconcilerPoolTest.assertEquals((int)2, (int)pool.getNullsCount());
        pool.release(a);
        ReconcilerPoolTest.assertEquals((int)1, (int)pool.getCreationCount());
        ReconcilerPoolTest.assertEquals((int)1, (int)pool.getNullsCount());
        Object aa = pool.acquire();
        ReconcilerPoolTest.assertEquals((int)1, (int)pool.getCreationCount());
        ReconcilerPoolTest.assertEquals((int)2, (int)pool.getNullsCount());
        ReconcilerPoolTest.assertSame((Object)a, (Object)aa);
        Object b = pool.acquire();
        ReconcilerPoolTest.assertEquals((int)2, (int)pool.getCreationCount());
        ReconcilerPoolTest.assertEquals((int)2, (int)pool.getNullsCount());
        ReconcilerPoolTest.assertNotSame((Object)a, (Object)b);
        pool.release(a);
        ReconcilerPoolTest.assertEquals((int)2, (int)pool.getCreationCount());
        ReconcilerPoolTest.assertEquals((int)1, (int)pool.getNullsCount());
        pool.release(b);
        ReconcilerPoolTest.assertEquals((int)2, (int)pool.getCreationCount());
        ReconcilerPoolTest.assertEquals((int)0, (int)pool.getNullsCount());
    }

    private static class Pool
    extends AbstractPool {
        private int myCreationCount;

        public Pool(int capacity) {
            super(capacity);
        }

        protected Object createNew() {
            ++this.myCreationCount;
            return new Object();
        }

        public Object acquire() {
            Object result = this.internalAcquire();
            ReconcilerPoolTest.assertNotNull((Object)result);
            return result;
        }

        public void release(Object object) {
            this.internalRelease(object);
        }

        public int getCreationCount() {
            return this.myCreationCount;
        }

        public int getNullsCount() {
            return this.internalCountNulls();
        }
    }
}

