/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.tests.expression;

import junit.framework.TestCase;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.gmf.internal.xpand.BuiltinMetaModel;
import org.eclipse.gmf.internal.xpand.model.ExecutionContext;
import org.eclipse.gmf.internal.xpand.model.ExecutionContextImpl;
import org.eclipse.gmf.internal.xpand.model.Scope;
import org.eclipse.gmf.internal.xpand.ocl.TypeHelper;
import org.eclipse.ocl.cst.CSTFactory;
import org.eclipse.ocl.cst.CollectionTypeCS;
import org.eclipse.ocl.cst.CollectionTypeIdentifierEnum;
import org.eclipse.ocl.cst.PrimitiveTypeCS;
import org.eclipse.ocl.cst.SimpleTypeEnum;
import org.eclipse.ocl.cst.TypeCS;
import org.eclipse.ocl.ecore.CollectionType;
import org.eclipse.ocl.expressions.CollectionKind;
import org.eclipse.ocl.types.OCLStandardLibrary;

public class ExecutionContextImplTest
extends TestCase {
    ExecutionContext ec;

    protected void setUp() throws Exception {
        this.ec = new ExecutionContextImpl(new Scope(){});
    }

    public final void testgetType() {
        OCLStandardLibrary stdlib = this.ec.getOCLEnvironment().getOCLStandardLibrary();
        ExecutionContextImplTest.assertEquals((Object)stdlib.getInteger(), (Object)BuiltinMetaModel.getType((ExecutionContext)this.ec, (Object)new Integer(3)));
        ExecutionContextImplTest.assertEquals((Object)stdlib.getInteger(), (Object)BuiltinMetaModel.getType((ExecutionContext)this.ec, (Object)new Short(3)));
        ExecutionContextImplTest.assertEquals((Object)stdlib.getInteger(), (Object)BuiltinMetaModel.getType((ExecutionContext)this.ec, (Object)new Long(3L)));
        ExecutionContextImplTest.assertEquals((Object)stdlib.getReal(), (Object)BuiltinMetaModel.getType((ExecutionContext)this.ec, (Object)new Float(3.0f)));
        ExecutionContextImplTest.assertEquals((Object)stdlib.getReal(), (Object)BuiltinMetaModel.getType((ExecutionContext)this.ec, (Object)new Double(3.0)));
        ExecutionContextImplTest.assertEquals((Object)stdlib.getString(), (Object)BuiltinMetaModel.getType((ExecutionContext)this.ec, (Object)"Test"));
    }

    public void off_testOCLDoesntSupportByte() {
        OCLStandardLibrary stdlib = this.ec.getOCLEnvironment().getOCLStandardLibrary();
        ExecutionContextImplTest.assertEquals((Object)stdlib.getInteger(), (Object)BuiltinMetaModel.getType((ExecutionContext)this.ec, (Object)new Byte(3)));
    }

    public final void testGetTypeForName() {
        CollectionTypeCS type = CSTFactory.eINSTANCE.createCollectionTypeCS();
        type.setCollectionTypeIdentifier(CollectionTypeIdentifierEnum.SEQUENCE_LITERAL);
        PrimitiveTypeCS inner = CSTFactory.eINSTANCE.createPrimitiveTypeCS();
        inner.setType(SimpleTypeEnum.STRING_LITERAL);
        inner.setValue("String");
        type.setTypeCS((TypeCS)inner);
        OCLStandardLibrary stdlib = this.ec.getOCLEnvironment().getOCLStandardLibrary();
        TypeHelper th = new TypeHelper((TypeCS)type);
        EClassifier t = th.getTypeForName(this.ec);
        ExecutionContextImplTest.assertNotNull((Object)t);
        ExecutionContextImplTest.assertTrue((boolean)(t instanceof org.eclipse.ocl.types.CollectionType));
        CollectionType tt = (CollectionType)t;
        ExecutionContextImplTest.assertEquals((Object)CollectionKind.SEQUENCE_LITERAL, (Object)tt.getKind());
        ExecutionContextImplTest.assertEquals((Object)stdlib.getString(), (Object)tt.getElementType());
    }
}

