/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.tests.xpand;

import java.util.Arrays;
import java.util.List;
import org.eclipse.gmf.internal.xpand.ast.AbstractDefinition;
import org.eclipse.gmf.internal.xpand.ast.Definition;
import org.eclipse.gmf.internal.xpand.ast.FileStatement;
import org.eclipse.gmf.internal.xpand.ast.IfStatement;
import org.eclipse.gmf.internal.xpand.ast.Statement;
import org.eclipse.gmf.internal.xpand.ast.Template;
import org.eclipse.gmf.internal.xpand.ast.TextStatement;
import org.eclipse.gmf.internal.xpand.expression.ast.DeclaredParameter;
import org.eclipse.gmf.internal.xpand.expression.ast.Expression;
import org.eclipse.gmf.tests.xpand.AbstractXpandTest;

public class StatementParserTest
extends AbstractXpandTest {
    public final void testEmptyTemplate() throws Exception {
        Template t = this.parse("");
        StatementParserTest.assertEquals((int)0, (int)t.getDefinitions().length);
    }

    public final void testSimpleDefine() throws Exception {
        Template t = this.parse(String.valueOf(this.tag("DEFINE test FOR ecore::EClass")) + this.tag("ENDDEFINE"));
        StatementParserTest.assertEquals((int)1, (int)t.getDefinitions().length);
    }

    public final void testTextStmtWithUnusualChars() throws Exception {
        Template t = this.parse(String.valueOf(this.tag("DEFINE test FOR ecore::EClass")) + "$" + this.tag("ENDDEFINE"));
        StatementParserTest.assertEquals((int)1, (int)t.getDefinitions().length);
        Statement st = ((AbstractDefinition)t.getDefinitions()[0]).getBody()[0];
        StatementParserTest.assertTrue((boolean)(st instanceof TextStatement));
        StatementParserTest.assertEquals((String)"$", (String)((TextStatement)st).getValue());
    }

    public final void testDoubleDefine() throws Exception {
        Template t = this.parse(String.valueOf(this.tag("DEFINE test FOR ecore::EClass")) + this.tag("ENDDEFINE") + this.tag("DEFINE test2(String txt) FOR ecore::EClass") + this.tag("ENDDEFINE"));
        StatementParserTest.assertEquals((int)2, (int)t.getDefinitions().length);
    }

    public final void testMoreComplexDefine() throws Exception {
        Template t = this.parse(String.valueOf(this.tag("DEFINE test(ecore::EPackage a,String b) FOR ecore::EClass")) + this.tag("FILE name+\".txt\"") + "Text und so " + this.tag("name") + this.tag("FOREACH eAllattributes AS attr") + "Attribute : " + this.tag("attr.name") + this.tag("ENDFOREACH") + this.tag("ENDFILE") + this.tag("ENDDEFINE"));
        StatementParserTest.assertEquals((int)1, (int)t.getDefinitions().length);
        Definition def = (Definition)t.getDefinitions()[0];
        StatementParserTest.assertEquals((String)"test", (String)def.getName());
        StatementParserTest.assertEquals((int)2, (int)def.getParams().length);
        DeclaredParameter param = def.getParams()[0];
        StatementParserTest.assertEquals((String)"a", (String)param.getName().getValue());
        StatementParserTest.assertEquals((String)"ecore::EPackage", (String)param.getType().getValue());
        param = def.getParams()[1];
        StatementParserTest.assertEquals((String)"b", (String)param.getName().getValue());
        StatementParserTest.assertEquals((String)"String", (String)param.getType().getValue());
        StatementParserTest.assertEquals((String)"ecore::EClass", (String)def.getType().getValue());
        List<Statement> statements = Arrays.asList(def.getBody());
        StatementParserTest.assertEquals((int)3, (int)statements.size());
        FileStatement f = (FileStatement)statements.get(1);
        Expression concat = f.getTargetFileName();
        StatementParserTest.assertNotNull((Object)concat);
        statements = Arrays.asList(f.getBody());
        StatementParserTest.assertEquals((int)5, (int)statements.size());
        StatementParserTest.assertEquals((String)"Text und so ", (String)((TextStatement)statements.get(0)).getValue());
    }

    public final void testImportDeclaration() throws Exception {
        Template t = this.parse(String.valueOf(this.tag("IMPORT \"http://ecore/x\"")) + this.tag("IMPORT \"zzz\"") + this.tag("DEFINE test FOR ecore::EClass") + this.tag("ENDDEFINE"));
        StatementParserTest.assertEquals((int)1, (int)t.getDefinitions().length);
        StatementParserTest.assertEquals((int)2, (int)t.getImports().length);
        StatementParserTest.assertEquals((String)"http://ecore/x", (String)t.getImports()[0].getImportString());
        StatementParserTest.assertEquals((String)"zzz", (String)t.getImports()[1].getImportString());
    }

    public final void testFileStatement() throws Exception {
        Template t = this.parse(String.valueOf(this.tag("DEFINE test FOR ecore::EClass")) + this.tag("FILE \"test.txt\" ONCE") + this.tag("ENDFILE") + this.tag("ENDDEFINE"));
        StatementParserTest.assertEquals((int)1, (int)t.getDefinitions().length);
        FileStatement file = (FileStatement)((Definition)t.getDefinitions()[0]).getBody()[1];
        StatementParserTest.assertEquals((String)"ONCE", (String)file.getMode().getValue());
    }

    public final void testIfStatement() throws Exception {
        Template t = this.parse(String.valueOf(this.tag("DEFINE test FOR ecore::EClass")) + this.tag("IF !true") + this.tag("ELSEIF false") + this.tag("ELSE") + this.tag("ENDIF") + this.tag("ENDDEFINE"));
        StatementParserTest.assertEquals((int)1, (int)t.getDefinitions().length);
        IfStatement ifSt = (IfStatement)((Definition)t.getDefinitions()[0]).getBody()[1];
        StatementParserTest.assertNotNull((Object)ifSt);
        StatementParserTest.assertNotNull((Object)ifSt.getCondition());
        StatementParserTest.assertNotNull((Object)ifSt.getElseIf());
        StatementParserTest.assertNotNull((Object)ifSt.getElseIf().getCondition());
        StatementParserTest.assertNotNull((Object)ifSt.getElseIf().getElseIf());
        StatementParserTest.assertNull((Object)ifSt.getElseIf().getElseIf().getCondition());
    }
}

